/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md.
 */
import { type CKEditorCloudConfig, type CKEditorCloudResult } from '@ckeditor/ckeditor5-integrations-common';
import { type AsyncValueHookResult } from '../hooks/useAsyncValue.js';
/**
 * Hook that loads CKEditor bundles from CDN.
 *
 * @template Config The type of the CKEditor Cloud configuration.
 * @param config The configuration of the hook.
 * @returns The state of async operation that resolves to the CKEditor bundles.
 * @experimental
 * @example
 *
 * ```ts
 * const cloud = useCKEditorCloud( {
 * 	version: '42.0.0',
 * 	translations: [ 'es', 'de' ],
 * 	premium: true
 * } );
 *
 * if ( cloud.status === 'success' ) {
 * 	const { ClassicEditor, Bold, Essentials } = cloud.CKEditor;
 * 	const { SlashCommand } = cloud.CKEditorPremiumFeatures;
 * }
 * ```
 */
export default function useCKEditorCloud<Config extends CKEditorCloudConfig>(config: Config): CKEditorCloudHookResult<Config>;
/**
 * The result of the `useCKEditorCloud` hook. It changes success state to be more intuitive.
 */
type CKEditorCloudHookResult<Config extends CKEditorCloudConfig> = Exclude<AsyncValueHookResult<CKEditorCloudResult<Config>>, {
    status: 'success';
}> | (CKEditorCloudResult<Config> & {
    status: 'success';
});
export {};
