import { Awaitable } from '../types/Awaitable.js';
/**
 * Waits for the provided callback to succeed. The callback is executed multiple times until it succeeds or the timeout is reached.
 * It's executed immediately and then with a delay defined by the `retry` option.
 *
 * @param callback The callback to execute.
 * @param config Configuration for the function.
 * @returns A promise that resolves when the callback succeeds.
 *
 * @example
 * ```ts
 * await waitFor( async () => {
 * 	const element = document.querySelector( '.my-element' );
 * 	if ( !element ) {
 * 		throw new Error( 'Element not found.' );
 * 	}
 * } );
 * ```
 */
export declare function waitFor<R>(callback: () => Awaitable<R>, { timeOutAfter, retryAfter }?: WaitForConfig): Promise<R>;
/**
 * Configuration for the `waitFor` function.
 */
export type WaitForConfig = {
    timeOutAfter?: number;
    retryAfter?: number;
};
