/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md.
 */
/**
 * Map of injected stylesheets. It's used to prevent injecting the same stylesheet multiple times.
 * It happens quite often in React Strict mode when the component is rendered twice.
 */
export declare const INJECTED_STYLESHEETS: Map<string, Promise<void>>;
/**
 * Injects a stylesheet into the document.
 *
 * @param props.href The URL of the stylesheet to be injected.
 * @param props.placementInHead The placement of the stylesheet in the head.
 * @param props.attributes Additional attributes to be set on the link element.
 * @returns A promise that resolves when the stylesheet is loaded.
 */
export declare function injectStylesheet({ href, placementInHead, attributes }: InjectStylesheetProps): Promise<void>;
/**
 * Props for the `injectStylesheet` function.
 */
type InjectStylesheetProps = {
    /**
     * The URL of the stylesheet to be injected.
     */
    href: string;
    /**
     * The placement of the stylesheet in the head. It can be either at the start or at the end
     * of the head. Default is 'start' because it allows user to override the styles easily.
     */
    placementInHead?: 'start' | 'end';
    /**
     * Additional attributes to set on the link tag.
     */
    attributes?: Record<string, any>;
};
export {};
