import { SemanticVersion } from '../utils/isSemanticVersion.js';
/**
 * The source from which CKEditor was installed.
 */
type BundleInstallationSource = 'npm' | 'cdn';
/**
 * Information about the currently installed CKEditor.
 */
export type BundleInstallationInfo = {
    /**
     * The source from which CKEditor was installed.
     */
    source: BundleInstallationSource;
    /**
     * The version of CKEditor.
     */
    version: SemanticVersion;
};
export {};
