import { CKCdnResourcesPack, InferCKCdnResourcesPackExportsType, CKCdnResourcesAdvancedPack } from './loadCKCdnResourcesPack.js';
/**
 * Combines multiple CKEditor CDN bundles packs into a single pack.
 *
 * @param packs A map of CKEditor CDN bundles packs.
 * @returns A combined pack of resources for multiple CKEditor CDN bundles.
 * @example
 *
 * ```ts
 * const { Base, Premium } = await loadCKCdnResourcesPack(
 * 	combineCKCdnBundlesPacks( {
 * 		Base: createCKCdnBaseBundlePack( {
 * 			version: '43.0.0',
 * 			translations: [ 'es', 'de' ]
 * 		} ),
 * 		Premium: createCKCdnPremiumBundlePack( {
 * 			version: '43.0.0',
 * 			translations: [ 'es', 'de' ]
 * 		} )
 * 	} )
 * );
 * ```
 */
export declare function combineCKCdnBundlesPacks<P extends CKCdnBundlesPacks>(packs: P): CKCdnCombinedBundlePack<P>;
/**
 * A map of CKEditor CDN bundles packs.
 */
export type CKCdnBundlesPacks = Record<string, CKCdnResourcesPack<any> | undefined>;
/**
 * A combined pack of resources for multiple CKEditor CDN bundles.
 */
export type CKCdnCombinedBundlePack<P extends CKCdnBundlesPacks> = CKCdnResourcesAdvancedPack<{
    [K in keyof P]: InferCKCdnResourcesPackExportsType<P[K]>;
}>;
