import { InferCKCdnResourcesPackExportsType, CKCdnResourcesAdvancedPack } from '../utils/loadCKCdnResourcesPack.js';
import { CKCdnBundlesPacks } from '../utils/combineCKCdnBundlesPacks.js';
/**
 * This function is similar to `combineCKCdnBundlesPacks` but it provides global scope
 * fallback for the plugins that do not define the type of the exported entries. In other
 * words if the plugin `Reader` does not define the type of the exported entries, the type
 * will be picked from the `Window[ 'Reader' ]` object.
 *
 * @param pluginsPacks A map of CKEditor plugins packs.
 * @returns A combined pack of resources for multiple CKEditor plugins.
 * @example
 *
 * ```ts
 * const { ScreenReader, AccessibilityChecker } = await loadCKCdnResourcesPack(
 * 	combineCdnPluginsPacks( {
 * 		ScreenReader: [ 'https://example.org/screen-reader.js' ],
 * 		AccessibilityChecker: [ 'https://example.org/accessibility-checker.js' ]
 * 	} )
 * );
 * ```
 *
 * In example above, `ScreenReader` and `AccessibilityChecker` are the plugins names and
 * the type of the exported entries will be picked from the global (Window) scope.
 */
export declare function combineCdnPluginsPacks<Plugins extends CdnPluginsPacks>(pluginsPacks: Plugins): CombinedPluginsPackWithFallbackScope<Plugins>;
/**
 * A map of CKEditor plugins packs.
 */
export type CdnPluginsPacks = CKCdnBundlesPacks;
/**
 * A combined pack of plugins. It picks the type of the plugin from the global scope if
 * `CKCdnCombinedBundlePack` does not define it in the `checkPluginLoaded` method.
 */
export type CombinedPluginsPackWithFallbackScope<P extends CdnPluginsPacks> = CKCdnResourcesAdvancedPack<{
    [K in keyof P]: FallbackIfUnknown<InferCKCdnResourcesPackExportsType<P[K]>, K extends keyof Window ? Window[K] : unknown>;
}>;
/**
 * Returns the fallback type if the provided type is unknown.
 */
type FallbackIfUnknown<T, Fallback> = unknown extends T ? Fallback : T;
export {};
