import { CKCdnResourcesAdvancedPack } from '../../cdn/utils/loadCKCdnResourcesPack.js';
import { CKBoxCdnVersion } from './createCKBoxCdnUrl.js';
import './globals.js';
/**
 * Creates a pack of resources for the base CKBox bundle.
 *
 * @param config The configuration of the CKBox bundle pack.
 * @returns A pack of resources for the base CKBox bundle.
 * @example
 * ```ts
 * const { CKBox } = await loadCKCdnResourcesPack(
 * 	createCKBoxCdnBundlePack( {
 * 		version: '2.5.1',
 * 		theme: 'lark'
 * 	} )
 * );
 * ```
 */
export declare function createCKBoxBundlePack({ version, theme }: CKBoxCdnBundlePackConfig): CKCdnResourcesAdvancedPack<Window['CKBox']>;
/**
 * Configuration of the base CKEditor bundle pack.
 */
export type CKBoxCdnBundlePackConfig = {
    /**
     * The version of  the base CKEditor bundle.
     */
    version: CKBoxCdnVersion;
    /**
     * The theme of the CKBox bundle. Default is 'lark'.
     */
    theme?: string | null;
};
