import { CKCdnResourcesAdvancedPack } from '../../cdn/utils/loadCKCdnResourcesPack.js';
import { CKCdnVersion } from './createCKCdnUrl.js';
import './globals.js';
/**
 * Creates a pack of resources for the base CKEditor bundle.
 *
 * @param config The configuration of the CKEditor Premium Features pack.
 * @returns A pack of resources for  the base CKEditor bundle.
 * @example
 *
 * ```ts
 * const { Paragraph } = await loadCKCdnResourcesPack(
 * 	createCKCdnBaseBundlePack( {
 * 		version: '43.0.0',
 * 		translations: [ 'es', 'de' ]
 * 	} )
 * );
 * ```
 */
export declare function createCKCdnBaseBundlePack({ version, translations }: CKCdnBaseBundlePackConfig): CKCdnResourcesAdvancedPack<Window['CKEDITOR']>;
/**
 * Configuration of the base CKEditor bundle pack.
 */
export type CKCdnBaseBundlePackConfig = {
    /**
     * The version of  the base CKEditor bundle.
     */
    version: CKCdnVersion;
    /**
     * The list of translations to load.
     */
    translations?: Array<string>;
};
