/*! @azure/msal-browser v3.21.0 2024-08-13 */
'use strict';
import { createBrowserConfigurationAuthError } from '../error/BrowserConfigurationAuthError.mjs';
import { BrowserCacheLocation } from '../utils/BrowserConstants.mjs';
import { storageNotSupported } from '../error/BrowserConfigurationAuthErrorCodes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
class BrowserStorage {
    constructor(cacheLocation) {
        this.validateWindowStorage(cacheLocation);
        this.windowStorage = window[cacheLocation];
    }
    validateWindowStorage(cacheLocation) {
        if ((cacheLocation !== BrowserCacheLocation.LocalStorage &&
            cacheLocation !== BrowserCacheLocation.SessionStorage) ||
            !window[cacheLocation]) {
            throw createBrowserConfigurationAuthError(storageNotSupported);
        }
    }
    getItem(key) {
        return this.windowStorage.getItem(key);
    }
    setItem(key, value) {
        this.windowStorage.setItem(key, value);
    }
    removeItem(key) {
        this.windowStorage.removeItem(key);
    }
    getKeys() {
        return Object.keys(this.windowStorage);
    }
    containsKey(key) {
        return this.windowStorage.hasOwnProperty(key);
    }
}

export { BrowserStorage };
//# sourceMappingURL=BrowserStorage.mjs.map
