"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringToUint8Array = exports.uint8ArrayToString = exports.isWebWorker = exports.isReactNative = exports.isDeno = exports.isNodeRuntime = exports.isNodeLike = exports.isNode = exports.isBun = exports.isBrowser = exports.randomUUID = exports.objectHasProperty = exports.isObjectWithProperties = exports.isDefined = exports.computeSha256Hmac = exports.computeSha256Hash = exports.getErrorMessage = exports.isError = exports.isObject = exports.getRandomIntegerInclusive = exports.createAbortablePromise = exports.cancelablePromiseRace = exports.delay = void 0;
var delay_js_1 = require("./delay.js");
Object.defineProperty(exports, "delay", { enumerable: true, get: function () { return delay_js_1.delay; } });
var aborterUtils_js_1 = require("./aborterUtils.js");
Object.defineProperty(exports, "cancelablePromiseRace", { enumerable: true, get: function () { return aborterUtils_js_1.cancelablePromiseRace; } });
var createAbortablePromise_js_1 = require("./createAbortablePromise.js");
Object.defineProperty(exports, "createAbortablePromise", { enumerable: true, get: function () { return createAbortablePromise_js_1.createAbortablePromise; } });
var random_js_1 = require("./random.js");
Object.defineProperty(exports, "getRandomIntegerInclusive", { enumerable: true, get: function () { return random_js_1.getRandomIntegerInclusive; } });
var object_js_1 = require("./object.js");
Object.defineProperty(exports, "isObject", { enumerable: true, get: function () { return object_js_1.isObject; } });
var error_js_1 = require("./error.js");
Object.defineProperty(exports, "isError", { enumerable: true, get: function () { return error_js_1.isError; } });
Object.defineProperty(exports, "getErrorMessage", { enumerable: true, get: function () { return error_js_1.getErrorMessage; } });
var sha256_js_1 = require("./sha256.js");
Object.defineProperty(exports, "computeSha256Hash", { enumerable: true, get: function () { return sha256_js_1.computeSha256Hash; } });
Object.defineProperty(exports, "computeSha256Hmac", { enumerable: true, get: function () { return sha256_js_1.computeSha256Hmac; } });
var typeGuards_js_1 = require("./typeGuards.js");
Object.defineProperty(exports, "isDefined", { enumerable: true, get: function () { return typeGuards_js_1.isDefined; } });
Object.defineProperty(exports, "isObjectWithProperties", { enumerable: true, get: function () { return typeGuards_js_1.isObjectWithProperties; } });
Object.defineProperty(exports, "objectHasProperty", { enumerable: true, get: function () { return typeGuards_js_1.objectHasProperty; } });
var uuidUtils_js_1 = require("./uuidUtils.js");
Object.defineProperty(exports, "randomUUID", { enumerable: true, get: function () { return uuidUtils_js_1.randomUUID; } });
var checkEnvironment_js_1 = require("./checkEnvironment.js");
Object.defineProperty(exports, "isBrowser", { enumerable: true, get: function () { return checkEnvironment_js_1.isBrowser; } });
Object.defineProperty(exports, "isBun", { enumerable: true, get: function () { return checkEnvironment_js_1.isBun; } });
Object.defineProperty(exports, "isNode", { enumerable: true, get: function () { return checkEnvironment_js_1.isNode; } });
Object.defineProperty(exports, "isNodeLike", { enumerable: true, get: function () { return checkEnvironment_js_1.isNodeLike; } });
Object.defineProperty(exports, "isNodeRuntime", { enumerable: true, get: function () { return checkEnvironment_js_1.isNodeRuntime; } });
Object.defineProperty(exports, "isDeno", { enumerable: true, get: function () { return checkEnvironment_js_1.isDeno; } });
Object.defineProperty(exports, "isReactNative", { enumerable: true, get: function () { return checkEnvironment_js_1.isReactNative; } });
Object.defineProperty(exports, "isWebWorker", { enumerable: true, get: function () { return checkEnvironment_js_1.isWebWorker; } });
var bytesEncoding_js_1 = require("./bytesEncoding.js");
Object.defineProperty(exports, "uint8ArrayToString", { enumerable: true, get: function () { return bytesEncoding_js_1.uint8ArrayToString; } });
Object.defineProperty(exports, "stringToUint8Array", { enumerable: true, get: function () { return bytesEncoding_js_1.stringToUint8Array; } });
//# sourceMappingURL=index.js.map