import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { SecretsManagerServiceException as __BaseException } from "./SecretsManagerServiceException";
export interface ReplicaRegionType {
  Region?: string;
  KmsKeyId?: string;
}
export interface APIErrorType {
  SecretId?: string;
  ErrorCode?: string;
  Message?: string;
}
export declare const FilterNameStringType: {
  readonly all: "all";
  readonly description: "description";
  readonly name: "name";
  readonly owning_service: "owning-service";
  readonly primary_region: "primary-region";
  readonly tag_key: "tag-key";
  readonly tag_value: "tag-value";
};
export type FilterNameStringType =
  (typeof FilterNameStringType)[keyof typeof FilterNameStringType];
export interface Filter {
  Key?: FilterNameStringType;
  Values?: string[];
}
export interface BatchGetSecretValueRequest {
  SecretIdList?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface SecretValueEntry {
  ARN?: string;
  Name?: string;
  VersionId?: string;
  SecretBinary?: Uint8Array;
  SecretString?: string;
  VersionStages?: string[];
  CreatedDate?: Date;
}
export interface BatchGetSecretValueResponse {
  SecretValues?: SecretValueEntry[];
  NextToken?: string;
  Errors?: APIErrorType[];
}
export declare class DecryptionFailure extends __BaseException {
  readonly name: "DecryptionFailure";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<DecryptionFailure, __BaseException>);
}
export declare class InternalServiceError extends __BaseException {
  readonly name: "InternalServiceError";
  readonly $fault: "server";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InternalServiceError, __BaseException>
  );
}
export declare class InvalidNextTokenException extends __BaseException {
  readonly name: "InvalidNextTokenException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidNextTokenException, __BaseException>
  );
}
export declare class InvalidParameterException extends __BaseException {
  readonly name: "InvalidParameterException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidParameterException, __BaseException>
  );
}
export declare class InvalidRequestException extends __BaseException {
  readonly name: "InvalidRequestException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidRequestException, __BaseException>
  );
}
export declare class ResourceNotFoundException extends __BaseException {
  readonly name: "ResourceNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>
  );
}
export interface CancelRotateSecretRequest {
  SecretId: string | undefined;
}
export interface CancelRotateSecretResponse {
  ARN?: string;
  Name?: string;
  VersionId?: string;
}
export interface Tag {
  Key?: string;
  Value?: string;
}
export interface CreateSecretRequest {
  Name: string | undefined;
  ClientRequestToken?: string;
  Description?: string;
  KmsKeyId?: string;
  SecretBinary?: Uint8Array;
  SecretString?: string;
  Tags?: Tag[];
  AddReplicaRegions?: ReplicaRegionType[];
  ForceOverwriteReplicaSecret?: boolean;
}
export declare const StatusType: {
  readonly Failed: "Failed";
  readonly InProgress: "InProgress";
  readonly InSync: "InSync";
};
export type StatusType = (typeof StatusType)[keyof typeof StatusType];
export interface ReplicationStatusType {
  Region?: string;
  KmsKeyId?: string;
  Status?: StatusType;
  StatusMessage?: string;
  LastAccessedDate?: Date;
}
export interface CreateSecretResponse {
  ARN?: string;
  Name?: string;
  VersionId?: string;
  ReplicationStatus?: ReplicationStatusType[];
}
export declare class EncryptionFailure extends __BaseException {
  readonly name: "EncryptionFailure";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<EncryptionFailure, __BaseException>);
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class MalformedPolicyDocumentException extends __BaseException {
  readonly name: "MalformedPolicyDocumentException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      MalformedPolicyDocumentException,
      __BaseException
    >
  );
}
export declare class PreconditionNotMetException extends __BaseException {
  readonly name: "PreconditionNotMetException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<PreconditionNotMetException, __BaseException>
  );
}
export declare class ResourceExistsException extends __BaseException {
  readonly name: "ResourceExistsException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceExistsException, __BaseException>
  );
}
export interface DeleteResourcePolicyRequest {
  SecretId: string | undefined;
}
export interface DeleteResourcePolicyResponse {
  ARN?: string;
  Name?: string;
}
export interface DeleteSecretRequest {
  SecretId: string | undefined;
  RecoveryWindowInDays?: number;
  ForceDeleteWithoutRecovery?: boolean;
}
export interface DeleteSecretResponse {
  ARN?: string;
  Name?: string;
  DeletionDate?: Date;
}
export interface DescribeSecretRequest {
  SecretId: string | undefined;
}
export interface RotationRulesType {
  AutomaticallyAfterDays?: number;
  Duration?: string;
  ScheduleExpression?: string;
}
export interface DescribeSecretResponse {
  ARN?: string;
  Name?: string;
  Description?: string;
  KmsKeyId?: string;
  RotationEnabled?: boolean;
  RotationLambdaARN?: string;
  RotationRules?: RotationRulesType;
  LastRotatedDate?: Date;
  LastChangedDate?: Date;
  LastAccessedDate?: Date;
  DeletedDate?: Date;
  NextRotationDate?: Date;
  Tags?: Tag[];
  VersionIdsToStages?: Record<string, string[]>;
  OwningService?: string;
  CreatedDate?: Date;
  PrimaryRegion?: string;
  ReplicationStatus?: ReplicationStatusType[];
}
export interface GetRandomPasswordRequest {
  PasswordLength?: number;
  ExcludeCharacters?: string;
  ExcludeNumbers?: boolean;
  ExcludePunctuation?: boolean;
  ExcludeUppercase?: boolean;
  ExcludeLowercase?: boolean;
  IncludeSpace?: boolean;
  RequireEachIncludedType?: boolean;
}
export interface GetRandomPasswordResponse {
  RandomPassword?: string;
}
export interface GetResourcePolicyRequest {
  SecretId: string | undefined;
}
export interface GetResourcePolicyResponse {
  ARN?: string;
  Name?: string;
  ResourcePolicy?: string;
}
export interface GetSecretValueRequest {
  SecretId: string | undefined;
  VersionId?: string;
  VersionStage?: string;
}
export interface GetSecretValueResponse {
  ARN?: string;
  Name?: string;
  VersionId?: string;
  SecretBinary?: Uint8Array;
  SecretString?: string;
  VersionStages?: string[];
  CreatedDate?: Date;
}
export declare const SortOrderType: {
  readonly asc: "asc";
  readonly desc: "desc";
};
export type SortOrderType = (typeof SortOrderType)[keyof typeof SortOrderType];
export interface ListSecretsRequest {
  IncludePlannedDeletion?: boolean;
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  SortOrder?: SortOrderType;
}
export interface SecretListEntry {
  ARN?: string;
  Name?: string;
  Description?: string;
  KmsKeyId?: string;
  RotationEnabled?: boolean;
  RotationLambdaARN?: string;
  RotationRules?: RotationRulesType;
  LastRotatedDate?: Date;
  LastChangedDate?: Date;
  LastAccessedDate?: Date;
  DeletedDate?: Date;
  NextRotationDate?: Date;
  Tags?: Tag[];
  SecretVersionsToStages?: Record<string, string[]>;
  OwningService?: string;
  CreatedDate?: Date;
  PrimaryRegion?: string;
}
export interface ListSecretsResponse {
  SecretList?: SecretListEntry[];
  NextToken?: string;
}
export interface ListSecretVersionIdsRequest {
  SecretId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
  IncludeDeprecated?: boolean;
}
export interface SecretVersionsListEntry {
  VersionId?: string;
  VersionStages?: string[];
  LastAccessedDate?: Date;
  CreatedDate?: Date;
  KmsKeyIds?: string[];
}
export interface ListSecretVersionIdsResponse {
  Versions?: SecretVersionsListEntry[];
  NextToken?: string;
  ARN?: string;
  Name?: string;
}
export declare class PublicPolicyException extends __BaseException {
  readonly name: "PublicPolicyException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<PublicPolicyException, __BaseException>
  );
}
export interface PutResourcePolicyRequest {
  SecretId: string | undefined;
  ResourcePolicy: string | undefined;
  BlockPublicPolicy?: boolean;
}
export interface PutResourcePolicyResponse {
  ARN?: string;
  Name?: string;
}
export interface PutSecretValueRequest {
  SecretId: string | undefined;
  ClientRequestToken?: string;
  SecretBinary?: Uint8Array;
  SecretString?: string;
  VersionStages?: string[];
  RotationToken?: string;
}
export interface PutSecretValueResponse {
  ARN?: string;
  Name?: string;
  VersionId?: string;
  VersionStages?: string[];
}
export interface RemoveRegionsFromReplicationRequest {
  SecretId: string | undefined;
  RemoveReplicaRegions: string[] | undefined;
}
export interface RemoveRegionsFromReplicationResponse {
  ARN?: string;
  ReplicationStatus?: ReplicationStatusType[];
}
export interface ReplicateSecretToRegionsRequest {
  SecretId: string | undefined;
  AddReplicaRegions: ReplicaRegionType[] | undefined;
  ForceOverwriteReplicaSecret?: boolean;
}
export interface ReplicateSecretToRegionsResponse {
  ARN?: string;
  ReplicationStatus?: ReplicationStatusType[];
}
export interface RestoreSecretRequest {
  SecretId: string | undefined;
}
export interface RestoreSecretResponse {
  ARN?: string;
  Name?: string;
}
export interface RotateSecretRequest {
  SecretId: string | undefined;
  ClientRequestToken?: string;
  RotationLambdaARN?: string;
  RotationRules?: RotationRulesType;
  RotateImmediately?: boolean;
}
export interface RotateSecretResponse {
  ARN?: string;
  Name?: string;
  VersionId?: string;
}
export interface StopReplicationToReplicaRequest {
  SecretId: string | undefined;
}
export interface StopReplicationToReplicaResponse {
  ARN?: string;
}
export interface TagResourceRequest {
  SecretId: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagResourceRequest {
  SecretId: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UpdateSecretRequest {
  SecretId: string | undefined;
  ClientRequestToken?: string;
  Description?: string;
  KmsKeyId?: string;
  SecretBinary?: Uint8Array;
  SecretString?: string;
}
export interface UpdateSecretResponse {
  ARN?: string;
  Name?: string;
  VersionId?: string;
}
export interface UpdateSecretVersionStageRequest {
  SecretId: string | undefined;
  VersionStage: string | undefined;
  RemoveFromVersionId?: string;
  MoveToVersionId?: string;
}
export interface UpdateSecretVersionStageResponse {
  ARN?: string;
  Name?: string;
}
export interface ValidateResourcePolicyRequest {
  SecretId?: string;
  ResourcePolicy: string | undefined;
}
export interface ValidationErrorsEntry {
  CheckName?: string;
  ErrorMessage?: string;
}
export interface ValidateResourcePolicyResponse {
  PolicyValidationPassed?: boolean;
  ValidationErrors?: ValidationErrorsEntry[];
}
export declare const SecretValueEntryFilterSensitiveLog: (
  obj: SecretValueEntry
) => any;
export declare const BatchGetSecretValueResponseFilterSensitiveLog: (
  obj: BatchGetSecretValueResponse
) => any;
export declare const CreateSecretRequestFilterSensitiveLog: (
  obj: CreateSecretRequest
) => any;
export declare const GetRandomPasswordResponseFilterSensitiveLog: (
  obj: GetRandomPasswordResponse
) => any;
export declare const GetSecretValueResponseFilterSensitiveLog: (
  obj: GetSecretValueResponse
) => any;
export declare const PutSecretValueRequestFilterSensitiveLog: (
  obj: PutSecretValueRequest
) => any;
export declare const UpdateSecretRequestFilterSensitiveLog: (
  obj: UpdateSecretRequest
) => any;
