import { AwsSdkSigV4AuthInputConfig, AwsSdkSigV4AuthResolvedConfig, AwsSdkSigV4PreviouslyResolved } from "@aws-sdk/core";
import { HandlerExecutionContext, HttpAuthScheme, HttpAuthSchemeParameters, HttpAuthSchemeParametersProvider, HttpAuthSchemeProvider } from "@smithy/types";
import { SecretsManagerClientResolvedConfig } from "../SecretsManagerClient";
/**
 * @internal
 */
export interface SecretsManagerHttpAuthSchemeParameters extends HttpAuthSchemeParameters {
    region?: string;
}
/**
 * @internal
 */
export interface SecretsManagerHttpAuthSchemeParametersProvider extends HttpAuthSchemeParametersProvider<SecretsManagerClientResolvedConfig, HandlerExecutionContext, SecretsManagerHttpAuthSchemeParameters, object> {
}
/**
 * @internal
 */
export declare const defaultSecretsManagerHttpAuthSchemeParametersProvider: (config: SecretsManagerClientResolvedConfig, context: HandlerExecutionContext, input: object) => Promise<SecretsManagerHttpAuthSchemeParameters>;
/**
 * @internal
 */
export interface SecretsManagerHttpAuthSchemeProvider extends HttpAuthSchemeProvider<SecretsManagerHttpAuthSchemeParameters> {
}
/**
 * @internal
 */
export declare const defaultSecretsManagerHttpAuthSchemeProvider: SecretsManagerHttpAuthSchemeProvider;
/**
 * @internal
 */
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
    /**
     * Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    httpAuthSchemes?: HttpAuthScheme[];
    /**
     * Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    httpAuthSchemeProvider?: SecretsManagerHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export interface HttpAuthSchemeResolvedConfig extends AwsSdkSigV4AuthResolvedConfig {
    /**
     * Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    readonly httpAuthSchemes: HttpAuthScheme[];
    /**
     * Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    readonly httpAuthSchemeProvider: SecretsManagerHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export declare const resolveHttpAuthSchemeConfig: <T>(config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved) => T & HttpAuthSchemeResolvedConfig;
