"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  BatchGetSecretValueCommand: () => BatchGetSecretValueCommand,
  BatchGetSecretValueResponseFilterSensitiveLog: () => BatchGetSecretValueResponseFilterSensitiveLog,
  CancelRotateSecretCommand: () => CancelRotateSecretCommand,
  CreateSecretCommand: () => CreateSecretCommand,
  CreateSecretRequestFilterSensitiveLog: () => CreateSecretRequestFilterSensitiveLog,
  DecryptionFailure: () => DecryptionFailure,
  DeleteResourcePolicyCommand: () => DeleteResourcePolicyCommand,
  DeleteSecretCommand: () => DeleteSecretCommand,
  DescribeSecretCommand: () => DescribeSecretCommand,
  EncryptionFailure: () => EncryptionFailure,
  FilterNameStringType: () => FilterNameStringType,
  GetRandomPasswordCommand: () => GetRandomPasswordCommand,
  GetRandomPasswordResponseFilterSensitiveLog: () => GetRandomPasswordResponseFilterSensitiveLog,
  GetResourcePolicyCommand: () => GetResourcePolicyCommand,
  GetSecretValueCommand: () => GetSecretValueCommand,
  GetSecretValueResponseFilterSensitiveLog: () => GetSecretValueResponseFilterSensitiveLog,
  InternalServiceError: () => InternalServiceError,
  InvalidNextTokenException: () => InvalidNextTokenException,
  InvalidParameterException: () => InvalidParameterException,
  InvalidRequestException: () => InvalidRequestException,
  LimitExceededException: () => LimitExceededException,
  ListSecretVersionIdsCommand: () => ListSecretVersionIdsCommand,
  ListSecretsCommand: () => ListSecretsCommand,
  MalformedPolicyDocumentException: () => MalformedPolicyDocumentException,
  PreconditionNotMetException: () => PreconditionNotMetException,
  PublicPolicyException: () => PublicPolicyException,
  PutResourcePolicyCommand: () => PutResourcePolicyCommand,
  PutSecretValueCommand: () => PutSecretValueCommand,
  PutSecretValueRequestFilterSensitiveLog: () => PutSecretValueRequestFilterSensitiveLog,
  RemoveRegionsFromReplicationCommand: () => RemoveRegionsFromReplicationCommand,
  ReplicateSecretToRegionsCommand: () => ReplicateSecretToRegionsCommand,
  ResourceExistsException: () => ResourceExistsException,
  ResourceNotFoundException: () => ResourceNotFoundException,
  RestoreSecretCommand: () => RestoreSecretCommand,
  RotateSecretCommand: () => RotateSecretCommand,
  SecretValueEntryFilterSensitiveLog: () => SecretValueEntryFilterSensitiveLog,
  SecretsManager: () => SecretsManager,
  SecretsManagerClient: () => SecretsManagerClient,
  SecretsManagerServiceException: () => SecretsManagerServiceException,
  SortOrderType: () => SortOrderType,
  StatusType: () => StatusType,
  StopReplicationToReplicaCommand: () => StopReplicationToReplicaCommand,
  TagResourceCommand: () => TagResourceCommand,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateSecretCommand: () => UpdateSecretCommand,
  UpdateSecretRequestFilterSensitiveLog: () => UpdateSecretRequestFilterSensitiveLog,
  UpdateSecretVersionStageCommand: () => UpdateSecretVersionStageCommand,
  ValidateResourcePolicyCommand: () => ValidateResourcePolicyCommand,
  __Client: () => import_smithy_client.Client,
  paginateBatchGetSecretValue: () => paginateBatchGetSecretValue,
  paginateListSecretVersionIds: () => paginateListSecretVersionIds,
  paginateListSecrets: () => paginateListSecrets
});
module.exports = __toCommonJS(src_exports);

// src/SecretsManagerClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return {
    ...options,
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "secretsmanager"
  };
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/SecretsManagerClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var asPartial = /* @__PURE__ */ __name((t) => t, "asPartial");
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = {
    ...asPartial((0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig)),
    ...asPartial((0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig)),
    ...asPartial((0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig)),
    ...asPartial(getHttpAuthExtensionConfiguration(runtimeConfig))
  };
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return {
    ...runtimeConfig,
    ...(0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    ...(0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    ...(0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    ...resolveHttpAuthRuntimeConfig(extensionConfiguration)
  };
}, "resolveRuntimeExtensions");

// src/SecretsManagerClient.ts
var _SecretsManagerClient = class _SecretsManagerClient extends import_smithy_client.Client {
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, (configuration == null ? void 0 : configuration.extensions) || []);
    super(_config_8);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultSecretsManagerHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        })
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};
__name(_SecretsManagerClient, "SecretsManagerClient");
var SecretsManagerClient = _SecretsManagerClient;

// src/SecretsManager.ts


// src/commands/BatchGetSecretValueCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/models/models_0.ts


// src/models/SecretsManagerServiceException.ts

var _SecretsManagerServiceException = class _SecretsManagerServiceException extends import_smithy_client.ServiceException {
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _SecretsManagerServiceException.prototype);
  }
};
__name(_SecretsManagerServiceException, "SecretsManagerServiceException");
var SecretsManagerServiceException = _SecretsManagerServiceException;

// src/models/models_0.ts
var FilterNameStringType = {
  all: "all",
  description: "description",
  name: "name",
  owning_service: "owning-service",
  primary_region: "primary-region",
  tag_key: "tag-key",
  tag_value: "tag-value"
};
var _DecryptionFailure = class _DecryptionFailure extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DecryptionFailure",
      $fault: "client",
      ...opts
    });
    this.name = "DecryptionFailure";
    this.$fault = "client";
    Object.setPrototypeOf(this, _DecryptionFailure.prototype);
    this.Message = opts.Message;
  }
};
__name(_DecryptionFailure, "DecryptionFailure");
var DecryptionFailure = _DecryptionFailure;
var _InternalServiceError = class _InternalServiceError extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InternalServiceError",
      $fault: "server",
      ...opts
    });
    this.name = "InternalServiceError";
    this.$fault = "server";
    Object.setPrototypeOf(this, _InternalServiceError.prototype);
    this.Message = opts.Message;
  }
};
__name(_InternalServiceError, "InternalServiceError");
var InternalServiceError = _InternalServiceError;
var _InvalidNextTokenException = class _InvalidNextTokenException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidNextTokenException",
      $fault: "client",
      ...opts
    });
    this.name = "InvalidNextTokenException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _InvalidNextTokenException.prototype);
    this.Message = opts.Message;
  }
};
__name(_InvalidNextTokenException, "InvalidNextTokenException");
var InvalidNextTokenException = _InvalidNextTokenException;
var _InvalidParameterException = class _InvalidParameterException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidParameterException",
      $fault: "client",
      ...opts
    });
    this.name = "InvalidParameterException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _InvalidParameterException.prototype);
    this.Message = opts.Message;
  }
};
__name(_InvalidParameterException, "InvalidParameterException");
var InvalidParameterException = _InvalidParameterException;
var _InvalidRequestException = class _InvalidRequestException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRequestException",
      $fault: "client",
      ...opts
    });
    this.name = "InvalidRequestException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _InvalidRequestException.prototype);
    this.Message = opts.Message;
  }
};
__name(_InvalidRequestException, "InvalidRequestException");
var InvalidRequestException = _InvalidRequestException;
var _ResourceNotFoundException = class _ResourceNotFoundException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "ResourceNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _ResourceNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_ResourceNotFoundException, "ResourceNotFoundException");
var ResourceNotFoundException = _ResourceNotFoundException;
var StatusType = {
  Failed: "Failed",
  InProgress: "InProgress",
  InSync: "InSync"
};
var _EncryptionFailure = class _EncryptionFailure extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionFailure",
      $fault: "client",
      ...opts
    });
    this.name = "EncryptionFailure";
    this.$fault = "client";
    Object.setPrototypeOf(this, _EncryptionFailure.prototype);
    this.Message = opts.Message;
  }
};
__name(_EncryptionFailure, "EncryptionFailure");
var EncryptionFailure = _EncryptionFailure;
var _LimitExceededException = class _LimitExceededException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "LimitExceededException",
      $fault: "client",
      ...opts
    });
    this.name = "LimitExceededException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _LimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
__name(_LimitExceededException, "LimitExceededException");
var LimitExceededException = _LimitExceededException;
var _MalformedPolicyDocumentException = class _MalformedPolicyDocumentException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MalformedPolicyDocumentException",
      $fault: "client",
      ...opts
    });
    this.name = "MalformedPolicyDocumentException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _MalformedPolicyDocumentException.prototype);
    this.Message = opts.Message;
  }
};
__name(_MalformedPolicyDocumentException, "MalformedPolicyDocumentException");
var MalformedPolicyDocumentException = _MalformedPolicyDocumentException;
var _PreconditionNotMetException = class _PreconditionNotMetException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PreconditionNotMetException",
      $fault: "client",
      ...opts
    });
    this.name = "PreconditionNotMetException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _PreconditionNotMetException.prototype);
    this.Message = opts.Message;
  }
};
__name(_PreconditionNotMetException, "PreconditionNotMetException");
var PreconditionNotMetException = _PreconditionNotMetException;
var _ResourceExistsException = class _ResourceExistsException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceExistsException",
      $fault: "client",
      ...opts
    });
    this.name = "ResourceExistsException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _ResourceExistsException.prototype);
    this.Message = opts.Message;
  }
};
__name(_ResourceExistsException, "ResourceExistsException");
var ResourceExistsException = _ResourceExistsException;
var SortOrderType = {
  asc: "asc",
  desc: "desc"
};
var _PublicPolicyException = class _PublicPolicyException extends SecretsManagerServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PublicPolicyException",
      $fault: "client",
      ...opts
    });
    this.name = "PublicPolicyException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _PublicPolicyException.prototype);
    this.Message = opts.Message;
  }
};
__name(_PublicPolicyException, "PublicPolicyException");
var PublicPolicyException = _PublicPolicyException;
var SecretValueEntryFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SecretBinary && { SecretBinary: import_smithy_client.SENSITIVE_STRING },
  ...obj.SecretString && { SecretString: import_smithy_client.SENSITIVE_STRING }
}), "SecretValueEntryFilterSensitiveLog");
var BatchGetSecretValueResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SecretValues && { SecretValues: obj.SecretValues.map((item) => SecretValueEntryFilterSensitiveLog(item)) }
}), "BatchGetSecretValueResponseFilterSensitiveLog");
var CreateSecretRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SecretBinary && { SecretBinary: import_smithy_client.SENSITIVE_STRING },
  ...obj.SecretString && { SecretString: import_smithy_client.SENSITIVE_STRING }
}), "CreateSecretRequestFilterSensitiveLog");
var GetRandomPasswordResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.RandomPassword && { RandomPassword: import_smithy_client.SENSITIVE_STRING }
}), "GetRandomPasswordResponseFilterSensitiveLog");
var GetSecretValueResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SecretBinary && { SecretBinary: import_smithy_client.SENSITIVE_STRING },
  ...obj.SecretString && { SecretString: import_smithy_client.SENSITIVE_STRING }
}), "GetSecretValueResponseFilterSensitiveLog");
var PutSecretValueRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SecretBinary && { SecretBinary: import_smithy_client.SENSITIVE_STRING },
  ...obj.SecretString && { SecretString: import_smithy_client.SENSITIVE_STRING },
  ...obj.RotationToken && { RotationToken: import_smithy_client.SENSITIVE_STRING }
}), "PutSecretValueRequestFilterSensitiveLog");
var UpdateSecretRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SecretBinary && { SecretBinary: import_smithy_client.SENSITIVE_STRING },
  ...obj.SecretString && { SecretString: import_smithy_client.SENSITIVE_STRING }
}), "UpdateSecretRequestFilterSensitiveLog");

// src/protocols/Aws_json1_1.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("uuid");
var se_BatchGetSecretValueCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchGetSecretValue");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchGetSecretValueCommand");
var se_CancelRotateSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CancelRotateSecret");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CancelRotateSecretCommand");
var se_CreateSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateSecret");
  let body;
  body = JSON.stringify(se_CreateSecretRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateSecretCommand");
var se_DeleteResourcePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteResourcePolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteResourcePolicyCommand");
var se_DeleteSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteSecret");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteSecretCommand");
var se_DescribeSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeSecret");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeSecretCommand");
var se_GetRandomPasswordCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetRandomPassword");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetRandomPasswordCommand");
var se_GetResourcePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetResourcePolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetResourcePolicyCommand");
var se_GetSecretValueCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetSecretValue");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetSecretValueCommand");
var se_ListSecretsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListSecrets");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListSecretsCommand");
var se_ListSecretVersionIdsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListSecretVersionIds");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListSecretVersionIdsCommand");
var se_PutResourcePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutResourcePolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutResourcePolicyCommand");
var se_PutSecretValueCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutSecretValue");
  let body;
  body = JSON.stringify(se_PutSecretValueRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutSecretValueCommand");
var se_RemoveRegionsFromReplicationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RemoveRegionsFromReplication");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemoveRegionsFromReplicationCommand");
var se_ReplicateSecretToRegionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ReplicateSecretToRegions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ReplicateSecretToRegionsCommand");
var se_RestoreSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RestoreSecret");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RestoreSecretCommand");
var se_RotateSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RotateSecret");
  let body;
  body = JSON.stringify(se_RotateSecretRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RotateSecretCommand");
var se_StopReplicationToReplicaCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StopReplicationToReplica");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopReplicationToReplicaCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TagResourceCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UntagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UntagResourceCommand");
var se_UpdateSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateSecret");
  let body;
  body = JSON.stringify(se_UpdateSecretRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateSecretCommand");
var se_UpdateSecretVersionStageCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateSecretVersionStage");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateSecretVersionStageCommand");
var se_ValidateResourcePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ValidateResourcePolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ValidateResourcePolicyCommand");
var de_BatchGetSecretValueCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_BatchGetSecretValueResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchGetSecretValueCommand");
var de_CancelRotateSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CancelRotateSecretCommand");
var de_CreateSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateSecretResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateSecretCommand");
var de_DeleteResourcePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteResourcePolicyCommand");
var de_DeleteSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeleteSecretResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteSecretCommand");
var de_DescribeSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeSecretResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeSecretCommand");
var de_GetRandomPasswordCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetRandomPasswordCommand");
var de_GetResourcePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetResourcePolicyCommand");
var de_GetSecretValueCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetSecretValueResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetSecretValueCommand");
var de_ListSecretsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListSecretsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListSecretsCommand");
var de_ListSecretVersionIdsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListSecretVersionIdsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListSecretVersionIdsCommand");
var de_PutResourcePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutResourcePolicyCommand");
var de_PutSecretValueCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutSecretValueCommand");
var de_RemoveRegionsFromReplicationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_RemoveRegionsFromReplicationResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RemoveRegionsFromReplicationCommand");
var de_ReplicateSecretToRegionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ReplicateSecretToRegionsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ReplicateSecretToRegionsCommand");
var de_RestoreSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RestoreSecretCommand");
var de_RotateSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RotateSecretCommand");
var de_StopReplicationToReplicaCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopReplicationToReplicaCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_TagResourceCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UntagResourceCommand");
var de_UpdateSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateSecretCommand");
var de_UpdateSecretVersionStageCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateSecretVersionStageCommand");
var de_ValidateResourcePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ValidateResourcePolicyCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "DecryptionFailure":
    case "com.amazonaws.secretsmanager#DecryptionFailure":
      throw await de_DecryptionFailureRes(parsedOutput, context);
    case "InternalServiceError":
    case "com.amazonaws.secretsmanager#InternalServiceError":
      throw await de_InternalServiceErrorRes(parsedOutput, context);
    case "InvalidNextTokenException":
    case "com.amazonaws.secretsmanager#InvalidNextTokenException":
      throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
    case "InvalidParameterException":
    case "com.amazonaws.secretsmanager#InvalidParameterException":
      throw await de_InvalidParameterExceptionRes(parsedOutput, context);
    case "InvalidRequestException":
    case "com.amazonaws.secretsmanager#InvalidRequestException":
      throw await de_InvalidRequestExceptionRes(parsedOutput, context);
    case "ResourceNotFoundException":
    case "com.amazonaws.secretsmanager#ResourceNotFoundException":
      throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
    case "EncryptionFailure":
    case "com.amazonaws.secretsmanager#EncryptionFailure":
      throw await de_EncryptionFailureRes(parsedOutput, context);
    case "LimitExceededException":
    case "com.amazonaws.secretsmanager#LimitExceededException":
      throw await de_LimitExceededExceptionRes(parsedOutput, context);
    case "MalformedPolicyDocumentException":
    case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException":
      throw await de_MalformedPolicyDocumentExceptionRes(parsedOutput, context);
    case "PreconditionNotMetException":
    case "com.amazonaws.secretsmanager#PreconditionNotMetException":
      throw await de_PreconditionNotMetExceptionRes(parsedOutput, context);
    case "ResourceExistsException":
    case "com.amazonaws.secretsmanager#ResourceExistsException":
      throw await de_ResourceExistsExceptionRes(parsedOutput, context);
    case "PublicPolicyException":
    case "com.amazonaws.secretsmanager#PublicPolicyException":
      throw await de_PublicPolicyExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var de_DecryptionFailureRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DecryptionFailure({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DecryptionFailureRes");
var de_EncryptionFailureRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionFailure({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionFailureRes");
var de_InternalServiceErrorRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InternalServiceError({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InternalServiceErrorRes");
var de_InvalidNextTokenExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidNextTokenException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidNextTokenExceptionRes");
var de_InvalidParameterExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidParameterException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidParameterExceptionRes");
var de_InvalidRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRequestExceptionRes");
var de_LimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new LimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_LimitExceededExceptionRes");
var de_MalformedPolicyDocumentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MalformedPolicyDocumentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MalformedPolicyDocumentExceptionRes");
var de_PreconditionNotMetExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PreconditionNotMetException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PreconditionNotMetExceptionRes");
var de_PublicPolicyExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PublicPolicyException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PublicPolicyExceptionRes");
var de_ResourceExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceExistsExceptionRes");
var de_ResourceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceNotFoundExceptionRes");
var se_CreateSecretRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AddReplicaRegions: import_smithy_client._json,
    ClientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    ForceOverwriteReplicaSecret: [],
    KmsKeyId: [],
    Name: [],
    SecretBinary: context.base64Encoder,
    SecretString: [],
    Tags: import_smithy_client._json
  });
}, "se_CreateSecretRequest");
var se_PutSecretValueRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    RotationToken: [],
    SecretBinary: context.base64Encoder,
    SecretId: [],
    SecretString: [],
    VersionStages: import_smithy_client._json
  });
}, "se_PutSecretValueRequest");
var se_RotateSecretRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    RotateImmediately: [],
    RotationLambdaARN: [],
    RotationRules: import_smithy_client._json,
    SecretId: []
  });
}, "se_RotateSecretRequest");
var se_UpdateSecretRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    KmsKeyId: [],
    SecretBinary: context.base64Encoder,
    SecretId: [],
    SecretString: []
  });
}, "se_UpdateSecretRequest");
var de_BatchGetSecretValueResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Errors: import_smithy_client._json,
    NextToken: import_smithy_client.expectString,
    SecretValues: (_) => de_SecretValuesType(_, context)
  });
}, "de_BatchGetSecretValueResponse");
var de_CreateSecretResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    ReplicationStatus: (_) => de_ReplicationStatusListType(_, context),
    VersionId: import_smithy_client.expectString
  });
}, "de_CreateSecretResponse");
var de_DeleteSecretResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    DeletionDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Name: import_smithy_client.expectString
  });
}, "de_DeleteSecretResponse");
var de_DescribeSecretResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    CreatedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    DeletedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Description: import_smithy_client.expectString,
    KmsKeyId: import_smithy_client.expectString,
    LastAccessedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    LastChangedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    LastRotatedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Name: import_smithy_client.expectString,
    NextRotationDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    OwningService: import_smithy_client.expectString,
    PrimaryRegion: import_smithy_client.expectString,
    ReplicationStatus: (_) => de_ReplicationStatusListType(_, context),
    RotationEnabled: import_smithy_client.expectBoolean,
    RotationLambdaARN: import_smithy_client.expectString,
    RotationRules: import_smithy_client._json,
    Tags: import_smithy_client._json,
    VersionIdsToStages: import_smithy_client._json
  });
}, "de_DescribeSecretResponse");
var de_GetSecretValueResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    CreatedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Name: import_smithy_client.expectString,
    SecretBinary: context.base64Decoder,
    SecretString: import_smithy_client.expectString,
    VersionId: import_smithy_client.expectString,
    VersionStages: import_smithy_client._json
  });
}, "de_GetSecretValueResponse");
var de_ListSecretsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    SecretList: (_) => de_SecretListType(_, context)
  });
}, "de_ListSecretsResponse");
var de_ListSecretVersionIdsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    NextToken: import_smithy_client.expectString,
    Versions: (_) => de_SecretVersionsListType(_, context)
  });
}, "de_ListSecretVersionIdsResponse");
var de_RemoveRegionsFromReplicationResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    ReplicationStatus: (_) => de_ReplicationStatusListType(_, context)
  });
}, "de_RemoveRegionsFromReplicationResponse");
var de_ReplicateSecretToRegionsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    ReplicationStatus: (_) => de_ReplicationStatusListType(_, context)
  });
}, "de_ReplicateSecretToRegionsResponse");
var de_ReplicationStatusListType = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ReplicationStatusType(entry, context);
  });
  return retVal;
}, "de_ReplicationStatusListType");
var de_ReplicationStatusType = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    KmsKeyId: import_smithy_client.expectString,
    LastAccessedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Region: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusMessage: import_smithy_client.expectString
  });
}, "de_ReplicationStatusType");
var de_SecretListEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    CreatedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    DeletedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Description: import_smithy_client.expectString,
    KmsKeyId: import_smithy_client.expectString,
    LastAccessedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    LastChangedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    LastRotatedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Name: import_smithy_client.expectString,
    NextRotationDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    OwningService: import_smithy_client.expectString,
    PrimaryRegion: import_smithy_client.expectString,
    RotationEnabled: import_smithy_client.expectBoolean,
    RotationLambdaARN: import_smithy_client.expectString,
    RotationRules: import_smithy_client._json,
    SecretVersionsToStages: import_smithy_client._json,
    Tags: import_smithy_client._json
  });
}, "de_SecretListEntry");
var de_SecretListType = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_SecretListEntry(entry, context);
  });
  return retVal;
}, "de_SecretListType");
var de_SecretValueEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    CreatedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    Name: import_smithy_client.expectString,
    SecretBinary: context.base64Decoder,
    SecretString: import_smithy_client.expectString,
    VersionId: import_smithy_client.expectString,
    VersionStages: import_smithy_client._json
  });
}, "de_SecretValueEntry");
var de_SecretValuesType = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_SecretValueEntry(entry, context);
  });
  return retVal;
}, "de_SecretValuesType");
var de_SecretVersionsListEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    KmsKeyIds: import_smithy_client._json,
    LastAccessedDate: (_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))),
    VersionId: import_smithy_client.expectString,
    VersionStages: import_smithy_client._json
  });
}, "de_SecretVersionsListEntry");
var de_SecretVersionsListType = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_SecretVersionsListEntry(entry, context);
  });
  return retVal;
}, "de_SecretVersionsListType");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(SecretsManagerServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
function sharedHeaders(operation) {
  return {
    "content-type": "application/x-amz-json-1.1",
    "x-amz-target": `secretsmanager.${operation}`
  };
}
__name(sharedHeaders, "sharedHeaders");

// src/commands/BatchGetSecretValueCommand.ts
var _BatchGetSecretValueCommand = class _BatchGetSecretValueCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "BatchGetSecretValue", {}).n("SecretsManagerClient", "BatchGetSecretValueCommand").f(void 0, BatchGetSecretValueResponseFilterSensitiveLog).ser(se_BatchGetSecretValueCommand).de(de_BatchGetSecretValueCommand).build() {
};
__name(_BatchGetSecretValueCommand, "BatchGetSecretValueCommand");
var BatchGetSecretValueCommand = _BatchGetSecretValueCommand;

// src/commands/CancelRotateSecretCommand.ts



var _CancelRotateSecretCommand = class _CancelRotateSecretCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "CancelRotateSecret", {}).n("SecretsManagerClient", "CancelRotateSecretCommand").f(void 0, void 0).ser(se_CancelRotateSecretCommand).de(de_CancelRotateSecretCommand).build() {
};
__name(_CancelRotateSecretCommand, "CancelRotateSecretCommand");
var CancelRotateSecretCommand = _CancelRotateSecretCommand;

// src/commands/CreateSecretCommand.ts



var _CreateSecretCommand = class _CreateSecretCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "CreateSecret", {}).n("SecretsManagerClient", "CreateSecretCommand").f(CreateSecretRequestFilterSensitiveLog, void 0).ser(se_CreateSecretCommand).de(de_CreateSecretCommand).build() {
};
__name(_CreateSecretCommand, "CreateSecretCommand");
var CreateSecretCommand = _CreateSecretCommand;

// src/commands/DeleteResourcePolicyCommand.ts



var _DeleteResourcePolicyCommand = class _DeleteResourcePolicyCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "DeleteResourcePolicy", {}).n("SecretsManagerClient", "DeleteResourcePolicyCommand").f(void 0, void 0).ser(se_DeleteResourcePolicyCommand).de(de_DeleteResourcePolicyCommand).build() {
};
__name(_DeleteResourcePolicyCommand, "DeleteResourcePolicyCommand");
var DeleteResourcePolicyCommand = _DeleteResourcePolicyCommand;

// src/commands/DeleteSecretCommand.ts



var _DeleteSecretCommand = class _DeleteSecretCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "DeleteSecret", {}).n("SecretsManagerClient", "DeleteSecretCommand").f(void 0, void 0).ser(se_DeleteSecretCommand).de(de_DeleteSecretCommand).build() {
};
__name(_DeleteSecretCommand, "DeleteSecretCommand");
var DeleteSecretCommand = _DeleteSecretCommand;

// src/commands/DescribeSecretCommand.ts



var _DescribeSecretCommand = class _DescribeSecretCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "DescribeSecret", {}).n("SecretsManagerClient", "DescribeSecretCommand").f(void 0, void 0).ser(se_DescribeSecretCommand).de(de_DescribeSecretCommand).build() {
};
__name(_DescribeSecretCommand, "DescribeSecretCommand");
var DescribeSecretCommand = _DescribeSecretCommand;

// src/commands/GetRandomPasswordCommand.ts



var _GetRandomPasswordCommand = class _GetRandomPasswordCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "GetRandomPassword", {}).n("SecretsManagerClient", "GetRandomPasswordCommand").f(void 0, GetRandomPasswordResponseFilterSensitiveLog).ser(se_GetRandomPasswordCommand).de(de_GetRandomPasswordCommand).build() {
};
__name(_GetRandomPasswordCommand, "GetRandomPasswordCommand");
var GetRandomPasswordCommand = _GetRandomPasswordCommand;

// src/commands/GetResourcePolicyCommand.ts



var _GetResourcePolicyCommand = class _GetResourcePolicyCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "GetResourcePolicy", {}).n("SecretsManagerClient", "GetResourcePolicyCommand").f(void 0, void 0).ser(se_GetResourcePolicyCommand).de(de_GetResourcePolicyCommand).build() {
};
__name(_GetResourcePolicyCommand, "GetResourcePolicyCommand");
var GetResourcePolicyCommand = _GetResourcePolicyCommand;

// src/commands/GetSecretValueCommand.ts



var _GetSecretValueCommand = class _GetSecretValueCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "GetSecretValue", {}).n("SecretsManagerClient", "GetSecretValueCommand").f(void 0, GetSecretValueResponseFilterSensitiveLog).ser(se_GetSecretValueCommand).de(de_GetSecretValueCommand).build() {
};
__name(_GetSecretValueCommand, "GetSecretValueCommand");
var GetSecretValueCommand = _GetSecretValueCommand;

// src/commands/ListSecretsCommand.ts



var _ListSecretsCommand = class _ListSecretsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "ListSecrets", {}).n("SecretsManagerClient", "ListSecretsCommand").f(void 0, void 0).ser(se_ListSecretsCommand).de(de_ListSecretsCommand).build() {
};
__name(_ListSecretsCommand, "ListSecretsCommand");
var ListSecretsCommand = _ListSecretsCommand;

// src/commands/ListSecretVersionIdsCommand.ts



var _ListSecretVersionIdsCommand = class _ListSecretVersionIdsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "ListSecretVersionIds", {}).n("SecretsManagerClient", "ListSecretVersionIdsCommand").f(void 0, void 0).ser(se_ListSecretVersionIdsCommand).de(de_ListSecretVersionIdsCommand).build() {
};
__name(_ListSecretVersionIdsCommand, "ListSecretVersionIdsCommand");
var ListSecretVersionIdsCommand = _ListSecretVersionIdsCommand;

// src/commands/PutResourcePolicyCommand.ts



var _PutResourcePolicyCommand = class _PutResourcePolicyCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "PutResourcePolicy", {}).n("SecretsManagerClient", "PutResourcePolicyCommand").f(void 0, void 0).ser(se_PutResourcePolicyCommand).de(de_PutResourcePolicyCommand).build() {
};
__name(_PutResourcePolicyCommand, "PutResourcePolicyCommand");
var PutResourcePolicyCommand = _PutResourcePolicyCommand;

// src/commands/PutSecretValueCommand.ts



var _PutSecretValueCommand = class _PutSecretValueCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "PutSecretValue", {}).n("SecretsManagerClient", "PutSecretValueCommand").f(PutSecretValueRequestFilterSensitiveLog, void 0).ser(se_PutSecretValueCommand).de(de_PutSecretValueCommand).build() {
};
__name(_PutSecretValueCommand, "PutSecretValueCommand");
var PutSecretValueCommand = _PutSecretValueCommand;

// src/commands/RemoveRegionsFromReplicationCommand.ts



var _RemoveRegionsFromReplicationCommand = class _RemoveRegionsFromReplicationCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "RemoveRegionsFromReplication", {}).n("SecretsManagerClient", "RemoveRegionsFromReplicationCommand").f(void 0, void 0).ser(se_RemoveRegionsFromReplicationCommand).de(de_RemoveRegionsFromReplicationCommand).build() {
};
__name(_RemoveRegionsFromReplicationCommand, "RemoveRegionsFromReplicationCommand");
var RemoveRegionsFromReplicationCommand = _RemoveRegionsFromReplicationCommand;

// src/commands/ReplicateSecretToRegionsCommand.ts



var _ReplicateSecretToRegionsCommand = class _ReplicateSecretToRegionsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "ReplicateSecretToRegions", {}).n("SecretsManagerClient", "ReplicateSecretToRegionsCommand").f(void 0, void 0).ser(se_ReplicateSecretToRegionsCommand).de(de_ReplicateSecretToRegionsCommand).build() {
};
__name(_ReplicateSecretToRegionsCommand, "ReplicateSecretToRegionsCommand");
var ReplicateSecretToRegionsCommand = _ReplicateSecretToRegionsCommand;

// src/commands/RestoreSecretCommand.ts



var _RestoreSecretCommand = class _RestoreSecretCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "RestoreSecret", {}).n("SecretsManagerClient", "RestoreSecretCommand").f(void 0, void 0).ser(se_RestoreSecretCommand).de(de_RestoreSecretCommand).build() {
};
__name(_RestoreSecretCommand, "RestoreSecretCommand");
var RestoreSecretCommand = _RestoreSecretCommand;

// src/commands/RotateSecretCommand.ts



var _RotateSecretCommand = class _RotateSecretCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "RotateSecret", {}).n("SecretsManagerClient", "RotateSecretCommand").f(void 0, void 0).ser(se_RotateSecretCommand).de(de_RotateSecretCommand).build() {
};
__name(_RotateSecretCommand, "RotateSecretCommand");
var RotateSecretCommand = _RotateSecretCommand;

// src/commands/StopReplicationToReplicaCommand.ts



var _StopReplicationToReplicaCommand = class _StopReplicationToReplicaCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "StopReplicationToReplica", {}).n("SecretsManagerClient", "StopReplicationToReplicaCommand").f(void 0, void 0).ser(se_StopReplicationToReplicaCommand).de(de_StopReplicationToReplicaCommand).build() {
};
__name(_StopReplicationToReplicaCommand, "StopReplicationToReplicaCommand");
var StopReplicationToReplicaCommand = _StopReplicationToReplicaCommand;

// src/commands/TagResourceCommand.ts



var _TagResourceCommand = class _TagResourceCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "TagResource", {}).n("SecretsManagerClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
};
__name(_TagResourceCommand, "TagResourceCommand");
var TagResourceCommand = _TagResourceCommand;

// src/commands/UntagResourceCommand.ts



var _UntagResourceCommand = class _UntagResourceCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "UntagResource", {}).n("SecretsManagerClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
};
__name(_UntagResourceCommand, "UntagResourceCommand");
var UntagResourceCommand = _UntagResourceCommand;

// src/commands/UpdateSecretCommand.ts



var _UpdateSecretCommand = class _UpdateSecretCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "UpdateSecret", {}).n("SecretsManagerClient", "UpdateSecretCommand").f(UpdateSecretRequestFilterSensitiveLog, void 0).ser(se_UpdateSecretCommand).de(de_UpdateSecretCommand).build() {
};
__name(_UpdateSecretCommand, "UpdateSecretCommand");
var UpdateSecretCommand = _UpdateSecretCommand;

// src/commands/UpdateSecretVersionStageCommand.ts



var _UpdateSecretVersionStageCommand = class _UpdateSecretVersionStageCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "UpdateSecretVersionStage", {}).n("SecretsManagerClient", "UpdateSecretVersionStageCommand").f(void 0, void 0).ser(se_UpdateSecretVersionStageCommand).de(de_UpdateSecretVersionStageCommand).build() {
};
__name(_UpdateSecretVersionStageCommand, "UpdateSecretVersionStageCommand");
var UpdateSecretVersionStageCommand = _UpdateSecretVersionStageCommand;

// src/commands/ValidateResourcePolicyCommand.ts



var _ValidateResourcePolicyCommand = class _ValidateResourcePolicyCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("secretsmanager", "ValidateResourcePolicy", {}).n("SecretsManagerClient", "ValidateResourcePolicyCommand").f(void 0, void 0).ser(se_ValidateResourcePolicyCommand).de(de_ValidateResourcePolicyCommand).build() {
};
__name(_ValidateResourcePolicyCommand, "ValidateResourcePolicyCommand");
var ValidateResourcePolicyCommand = _ValidateResourcePolicyCommand;

// src/SecretsManager.ts
var commands = {
  BatchGetSecretValueCommand,
  CancelRotateSecretCommand,
  CreateSecretCommand,
  DeleteResourcePolicyCommand,
  DeleteSecretCommand,
  DescribeSecretCommand,
  GetRandomPasswordCommand,
  GetResourcePolicyCommand,
  GetSecretValueCommand,
  ListSecretsCommand,
  ListSecretVersionIdsCommand,
  PutResourcePolicyCommand,
  PutSecretValueCommand,
  RemoveRegionsFromReplicationCommand,
  ReplicateSecretToRegionsCommand,
  RestoreSecretCommand,
  RotateSecretCommand,
  StopReplicationToReplicaCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateSecretCommand,
  UpdateSecretVersionStageCommand,
  ValidateResourcePolicyCommand
};
var _SecretsManager = class _SecretsManager extends SecretsManagerClient {
};
__name(_SecretsManager, "SecretsManager");
var SecretsManager = _SecretsManager;
(0, import_smithy_client.createAggregatedClient)(commands, SecretsManager);

// src/pagination/BatchGetSecretValuePaginator.ts

var paginateBatchGetSecretValue = (0, import_core.createPaginator)(SecretsManagerClient, BatchGetSecretValueCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListSecretVersionIdsPaginator.ts

var paginateListSecretVersionIds = (0, import_core.createPaginator)(SecretsManagerClient, ListSecretVersionIdsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListSecretsPaginator.ts

var paginateListSecrets = (0, import_core.createPaginator)(SecretsManagerClient, ListSecretsCommand, "NextToken", "NextToken", "MaxResults");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  SecretsManagerServiceException,
  __Client,
  SecretsManagerClient,
  SecretsManager,
  $Command,
  BatchGetSecretValueCommand,
  CancelRotateSecretCommand,
  CreateSecretCommand,
  DeleteResourcePolicyCommand,
  DeleteSecretCommand,
  DescribeSecretCommand,
  GetRandomPasswordCommand,
  GetResourcePolicyCommand,
  GetSecretValueCommand,
  ListSecretVersionIdsCommand,
  ListSecretsCommand,
  PutResourcePolicyCommand,
  PutSecretValueCommand,
  RemoveRegionsFromReplicationCommand,
  ReplicateSecretToRegionsCommand,
  RestoreSecretCommand,
  RotateSecretCommand,
  StopReplicationToReplicaCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateSecretCommand,
  UpdateSecretVersionStageCommand,
  ValidateResourcePolicyCommand,
  paginateBatchGetSecretValue,
  paginateListSecretVersionIds,
  paginateListSecrets,
  FilterNameStringType,
  DecryptionFailure,
  InternalServiceError,
  InvalidNextTokenException,
  InvalidParameterException,
  InvalidRequestException,
  ResourceNotFoundException,
  StatusType,
  EncryptionFailure,
  LimitExceededException,
  MalformedPolicyDocumentException,
  PreconditionNotMetException,
  ResourceExistsException,
  SortOrderType,
  PublicPolicyException,
  SecretValueEntryFilterSensitiveLog,
  BatchGetSecretValueResponseFilterSensitiveLog,
  CreateSecretRequestFilterSensitiveLog,
  GetRandomPasswordResponseFilterSensitiveLog,
  GetSecretValueResponseFilterSensitiveLog,
  PutSecretValueRequestFilterSensitiveLog,
  UpdateSecretRequestFilterSensitiveLog
});

