import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { DynamoDBServiceException as __BaseException } from "./DynamoDBServiceException";
export declare const ApproximateCreationDateTimePrecision: {
  readonly MICROSECOND: "MICROSECOND";
  readonly MILLISECOND: "MILLISECOND";
};
export type ApproximateCreationDateTimePrecision =
  (typeof ApproximateCreationDateTimePrecision)[keyof typeof ApproximateCreationDateTimePrecision];
export interface ArchivalSummary {
  ArchivalDateTime?: Date;
  ArchivalReason?: string;
  ArchivalBackupArn?: string;
}
export declare const AttributeAction: {
  readonly ADD: "ADD";
  readonly DELETE: "DELETE";
  readonly PUT: "PUT";
};
export type AttributeAction =
  (typeof AttributeAction)[keyof typeof AttributeAction];
export declare const ScalarAttributeType: {
  readonly B: "B";
  readonly N: "N";
  readonly S: "S";
};
export type ScalarAttributeType =
  (typeof ScalarAttributeType)[keyof typeof ScalarAttributeType];
export interface AttributeDefinition {
  AttributeName: string | undefined;
  AttributeType: ScalarAttributeType | undefined;
}
export interface AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
  DisableScaleIn?: boolean;
  ScaleInCooldown?: number;
  ScaleOutCooldown?: number;
  TargetValue: number | undefined;
}
export interface AutoScalingPolicyDescription {
  PolicyName?: string;
  TargetTrackingScalingPolicyConfiguration?: AutoScalingTargetTrackingScalingPolicyConfigurationDescription;
}
export interface AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
  DisableScaleIn?: boolean;
  ScaleInCooldown?: number;
  ScaleOutCooldown?: number;
  TargetValue: number | undefined;
}
export interface AutoScalingPolicyUpdate {
  PolicyName?: string;
  TargetTrackingScalingPolicyConfiguration:
    | AutoScalingTargetTrackingScalingPolicyConfigurationUpdate
    | undefined;
}
export interface AutoScalingSettingsDescription {
  MinimumUnits?: number;
  MaximumUnits?: number;
  AutoScalingDisabled?: boolean;
  AutoScalingRoleArn?: string;
  ScalingPolicies?: AutoScalingPolicyDescription[];
}
export interface AutoScalingSettingsUpdate {
  MinimumUnits?: number;
  MaximumUnits?: number;
  AutoScalingDisabled?: boolean;
  AutoScalingRoleArn?: string;
  ScalingPolicyUpdate?: AutoScalingPolicyUpdate;
}
export declare const BackupStatus: {
  readonly AVAILABLE: "AVAILABLE";
  readonly CREATING: "CREATING";
  readonly DELETED: "DELETED";
};
export type BackupStatus = (typeof BackupStatus)[keyof typeof BackupStatus];
export declare const BackupType: {
  readonly AWS_BACKUP: "AWS_BACKUP";
  readonly SYSTEM: "SYSTEM";
  readonly USER: "USER";
};
export type BackupType = (typeof BackupType)[keyof typeof BackupType];
export interface BackupDetails {
  BackupArn: string | undefined;
  BackupName: string | undefined;
  BackupSizeBytes?: number;
  BackupStatus: BackupStatus | undefined;
  BackupType: BackupType | undefined;
  BackupCreationDateTime: Date | undefined;
  BackupExpiryDateTime?: Date;
}
export declare const BillingMode: {
  readonly PAY_PER_REQUEST: "PAY_PER_REQUEST";
  readonly PROVISIONED: "PROVISIONED";
};
export type BillingMode = (typeof BillingMode)[keyof typeof BillingMode];
export declare const KeyType: {
  readonly HASH: "HASH";
  readonly RANGE: "RANGE";
};
export type KeyType = (typeof KeyType)[keyof typeof KeyType];
export interface KeySchemaElement {
  AttributeName: string | undefined;
  KeyType: KeyType | undefined;
}
export interface OnDemandThroughput {
  MaxReadRequestUnits?: number;
  MaxWriteRequestUnits?: number;
}
export interface ProvisionedThroughput {
  ReadCapacityUnits: number | undefined;
  WriteCapacityUnits: number | undefined;
}
export interface SourceTableDetails {
  TableName: string | undefined;
  TableId: string | undefined;
  TableArn?: string;
  TableSizeBytes?: number;
  KeySchema: KeySchemaElement[] | undefined;
  TableCreationDateTime: Date | undefined;
  ProvisionedThroughput: ProvisionedThroughput | undefined;
  OnDemandThroughput?: OnDemandThroughput;
  ItemCount?: number;
  BillingMode?: BillingMode;
}
export declare const ProjectionType: {
  readonly ALL: "ALL";
  readonly INCLUDE: "INCLUDE";
  readonly KEYS_ONLY: "KEYS_ONLY";
};
export type ProjectionType =
  (typeof ProjectionType)[keyof typeof ProjectionType];
export interface Projection {
  ProjectionType?: ProjectionType;
  NonKeyAttributes?: string[];
}
export interface GlobalSecondaryIndexInfo {
  IndexName?: string;
  KeySchema?: KeySchemaElement[];
  Projection?: Projection;
  ProvisionedThroughput?: ProvisionedThroughput;
  OnDemandThroughput?: OnDemandThroughput;
}
export interface LocalSecondaryIndexInfo {
  IndexName?: string;
  KeySchema?: KeySchemaElement[];
  Projection?: Projection;
}
export declare const SSEType: {
  readonly AES256: "AES256";
  readonly KMS: "KMS";
};
export type SSEType = (typeof SSEType)[keyof typeof SSEType];
export declare const SSEStatus: {
  readonly DISABLED: "DISABLED";
  readonly DISABLING: "DISABLING";
  readonly ENABLED: "ENABLED";
  readonly ENABLING: "ENABLING";
  readonly UPDATING: "UPDATING";
};
export type SSEStatus = (typeof SSEStatus)[keyof typeof SSEStatus];
export interface SSEDescription {
  Status?: SSEStatus;
  SSEType?: SSEType;
  KMSMasterKeyArn?: string;
  InaccessibleEncryptionDateTime?: Date;
}
export declare const StreamViewType: {
  readonly KEYS_ONLY: "KEYS_ONLY";
  readonly NEW_AND_OLD_IMAGES: "NEW_AND_OLD_IMAGES";
  readonly NEW_IMAGE: "NEW_IMAGE";
  readonly OLD_IMAGE: "OLD_IMAGE";
};
export type StreamViewType =
  (typeof StreamViewType)[keyof typeof StreamViewType];
export interface StreamSpecification {
  StreamEnabled: boolean | undefined;
  StreamViewType?: StreamViewType;
}
export declare const TimeToLiveStatus: {
  readonly DISABLED: "DISABLED";
  readonly DISABLING: "DISABLING";
  readonly ENABLED: "ENABLED";
  readonly ENABLING: "ENABLING";
};
export type TimeToLiveStatus =
  (typeof TimeToLiveStatus)[keyof typeof TimeToLiveStatus];
export interface TimeToLiveDescription {
  TimeToLiveStatus?: TimeToLiveStatus;
  AttributeName?: string;
}
export interface SourceTableFeatureDetails {
  LocalSecondaryIndexes?: LocalSecondaryIndexInfo[];
  GlobalSecondaryIndexes?: GlobalSecondaryIndexInfo[];
  StreamDescription?: StreamSpecification;
  TimeToLiveDescription?: TimeToLiveDescription;
  SSEDescription?: SSEDescription;
}
export interface BackupDescription {
  BackupDetails?: BackupDetails;
  SourceTableDetails?: SourceTableDetails;
  SourceTableFeatureDetails?: SourceTableFeatureDetails;
}
export declare class BackupInUseException extends __BaseException {
  readonly name: "BackupInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BackupInUseException, __BaseException>
  );
}
export declare class BackupNotFoundException extends __BaseException {
  readonly name: "BackupNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BackupNotFoundException, __BaseException>
  );
}
export interface BackupSummary {
  TableName?: string;
  TableId?: string;
  TableArn?: string;
  BackupArn?: string;
  BackupName?: string;
  BackupCreationDateTime?: Date;
  BackupExpiryDateTime?: Date;
  BackupStatus?: BackupStatus;
  BackupType?: BackupType;
  BackupSizeBytes?: number;
}
export declare const BackupTypeFilter: {
  readonly ALL: "ALL";
  readonly AWS_BACKUP: "AWS_BACKUP";
  readonly SYSTEM: "SYSTEM";
  readonly USER: "USER";
};
export type BackupTypeFilter =
  (typeof BackupTypeFilter)[keyof typeof BackupTypeFilter];
export declare const ReturnConsumedCapacity: {
  readonly INDEXES: "INDEXES";
  readonly NONE: "NONE";
  readonly TOTAL: "TOTAL";
};
export type ReturnConsumedCapacity =
  (typeof ReturnConsumedCapacity)[keyof typeof ReturnConsumedCapacity];
export declare const ReturnValuesOnConditionCheckFailure: {
  readonly ALL_OLD: "ALL_OLD";
  readonly NONE: "NONE";
};
export type ReturnValuesOnConditionCheckFailure =
  (typeof ReturnValuesOnConditionCheckFailure)[keyof typeof ReturnValuesOnConditionCheckFailure];
export interface Capacity {
  ReadCapacityUnits?: number;
  WriteCapacityUnits?: number;
  CapacityUnits?: number;
}
export interface ConsumedCapacity {
  TableName?: string;
  CapacityUnits?: number;
  ReadCapacityUnits?: number;
  WriteCapacityUnits?: number;
  Table?: Capacity;
  LocalSecondaryIndexes?: Record<string, Capacity>;
  GlobalSecondaryIndexes?: Record<string, Capacity>;
}
export declare const BatchStatementErrorCodeEnum: {
  readonly AccessDenied: "AccessDenied";
  readonly ConditionalCheckFailed: "ConditionalCheckFailed";
  readonly DuplicateItem: "DuplicateItem";
  readonly InternalServerError: "InternalServerError";
  readonly ItemCollectionSizeLimitExceeded: "ItemCollectionSizeLimitExceeded";
  readonly ProvisionedThroughputExceeded: "ProvisionedThroughputExceeded";
  readonly RequestLimitExceeded: "RequestLimitExceeded";
  readonly ResourceNotFound: "ResourceNotFound";
  readonly ThrottlingError: "ThrottlingError";
  readonly TransactionConflict: "TransactionConflict";
  readonly ValidationError: "ValidationError";
};
export type BatchStatementErrorCodeEnum =
  (typeof BatchStatementErrorCodeEnum)[keyof typeof BatchStatementErrorCodeEnum];
export declare class InternalServerError extends __BaseException {
  readonly name: "InternalServerError";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<InternalServerError, __BaseException>
  );
}
export declare class RequestLimitExceeded extends __BaseException {
  readonly name: "RequestLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RequestLimitExceeded, __BaseException>
  );
}
export declare class InvalidEndpointException extends __BaseException {
  readonly name: "InvalidEndpointException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidEndpointException, __BaseException>
  );
}
export declare class ProvisionedThroughputExceededException extends __BaseException {
  readonly name: "ProvisionedThroughputExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ProvisionedThroughputExceededException,
      __BaseException
    >
  );
}
export declare class ResourceNotFoundException extends __BaseException {
  readonly name: "ResourceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>
  );
}
export declare const ReturnItemCollectionMetrics: {
  readonly NONE: "NONE";
  readonly SIZE: "SIZE";
};
export type ReturnItemCollectionMetrics =
  (typeof ReturnItemCollectionMetrics)[keyof typeof ReturnItemCollectionMetrics];
export declare class ItemCollectionSizeLimitExceededException extends __BaseException {
  readonly name: "ItemCollectionSizeLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ItemCollectionSizeLimitExceededException,
      __BaseException
    >
  );
}
export interface BillingModeSummary {
  BillingMode?: BillingMode;
  LastUpdateToPayPerRequestDateTime?: Date;
}
export declare const ComparisonOperator: {
  readonly BEGINS_WITH: "BEGINS_WITH";
  readonly BETWEEN: "BETWEEN";
  readonly CONTAINS: "CONTAINS";
  readonly EQ: "EQ";
  readonly GE: "GE";
  readonly GT: "GT";
  readonly IN: "IN";
  readonly LE: "LE";
  readonly LT: "LT";
  readonly NE: "NE";
  readonly NOT_CONTAINS: "NOT_CONTAINS";
  readonly NOT_NULL: "NOT_NULL";
  readonly NULL: "NULL";
};
export type ComparisonOperator =
  (typeof ComparisonOperator)[keyof typeof ComparisonOperator];
export declare const ConditionalOperator: {
  readonly AND: "AND";
  readonly OR: "OR";
};
export type ConditionalOperator =
  (typeof ConditionalOperator)[keyof typeof ConditionalOperator];
export declare const ContinuousBackupsStatus: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type ContinuousBackupsStatus =
  (typeof ContinuousBackupsStatus)[keyof typeof ContinuousBackupsStatus];
export declare const PointInTimeRecoveryStatus: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type PointInTimeRecoveryStatus =
  (typeof PointInTimeRecoveryStatus)[keyof typeof PointInTimeRecoveryStatus];
export interface PointInTimeRecoveryDescription {
  PointInTimeRecoveryStatus?: PointInTimeRecoveryStatus;
  EarliestRestorableDateTime?: Date;
  LatestRestorableDateTime?: Date;
}
export interface ContinuousBackupsDescription {
  ContinuousBackupsStatus: ContinuousBackupsStatus | undefined;
  PointInTimeRecoveryDescription?: PointInTimeRecoveryDescription;
}
export declare class ContinuousBackupsUnavailableException extends __BaseException {
  readonly name: "ContinuousBackupsUnavailableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ContinuousBackupsUnavailableException,
      __BaseException
    >
  );
}
export declare const ContributorInsightsAction: {
  readonly DISABLE: "DISABLE";
  readonly ENABLE: "ENABLE";
};
export type ContributorInsightsAction =
  (typeof ContributorInsightsAction)[keyof typeof ContributorInsightsAction];
export declare const ContributorInsightsStatus: {
  readonly DISABLED: "DISABLED";
  readonly DISABLING: "DISABLING";
  readonly ENABLED: "ENABLED";
  readonly ENABLING: "ENABLING";
  readonly FAILED: "FAILED";
};
export type ContributorInsightsStatus =
  (typeof ContributorInsightsStatus)[keyof typeof ContributorInsightsStatus];
export interface ContributorInsightsSummary {
  TableName?: string;
  IndexName?: string;
  ContributorInsightsStatus?: ContributorInsightsStatus;
}
export interface CreateBackupInput {
  TableName: string | undefined;
  BackupName: string | undefined;
}
export interface CreateBackupOutput {
  BackupDetails?: BackupDetails;
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class TableInUseException extends __BaseException {
  readonly name: "TableInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TableInUseException, __BaseException>
  );
}
export declare class TableNotFoundException extends __BaseException {
  readonly name: "TableNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TableNotFoundException, __BaseException>
  );
}
export interface CreateGlobalSecondaryIndexAction {
  IndexName: string | undefined;
  KeySchema: KeySchemaElement[] | undefined;
  Projection: Projection | undefined;
  ProvisionedThroughput?: ProvisionedThroughput;
  OnDemandThroughput?: OnDemandThroughput;
}
export interface Replica {
  RegionName?: string;
}
export interface CreateGlobalTableInput {
  GlobalTableName: string | undefined;
  ReplicationGroup: Replica[] | undefined;
}
export declare const GlobalTableStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATING: "CREATING";
  readonly DELETING: "DELETING";
  readonly UPDATING: "UPDATING";
};
export type GlobalTableStatus =
  (typeof GlobalTableStatus)[keyof typeof GlobalTableStatus];
export interface OnDemandThroughputOverride {
  MaxReadRequestUnits?: number;
}
export interface ProvisionedThroughputOverride {
  ReadCapacityUnits?: number;
}
export interface ReplicaGlobalSecondaryIndexDescription {
  IndexName?: string;
  ProvisionedThroughputOverride?: ProvisionedThroughputOverride;
  OnDemandThroughputOverride?: OnDemandThroughputOverride;
}
export declare const ReplicaStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATING: "CREATING";
  readonly CREATION_FAILED: "CREATION_FAILED";
  readonly DELETING: "DELETING";
  readonly INACCESSIBLE_ENCRYPTION_CREDENTIALS: "INACCESSIBLE_ENCRYPTION_CREDENTIALS";
  readonly REGION_DISABLED: "REGION_DISABLED";
  readonly UPDATING: "UPDATING";
};
export type ReplicaStatus = (typeof ReplicaStatus)[keyof typeof ReplicaStatus];
export declare const TableClass: {
  readonly STANDARD: "STANDARD";
  readonly STANDARD_INFREQUENT_ACCESS: "STANDARD_INFREQUENT_ACCESS";
};
export type TableClass = (typeof TableClass)[keyof typeof TableClass];
export interface TableClassSummary {
  TableClass?: TableClass;
  LastUpdateDateTime?: Date;
}
export interface ReplicaDescription {
  RegionName?: string;
  ReplicaStatus?: ReplicaStatus;
  ReplicaStatusDescription?: string;
  ReplicaStatusPercentProgress?: string;
  KMSMasterKeyId?: string;
  ProvisionedThroughputOverride?: ProvisionedThroughputOverride;
  OnDemandThroughputOverride?: OnDemandThroughputOverride;
  GlobalSecondaryIndexes?: ReplicaGlobalSecondaryIndexDescription[];
  ReplicaInaccessibleDateTime?: Date;
  ReplicaTableClassSummary?: TableClassSummary;
}
export interface GlobalTableDescription {
  ReplicationGroup?: ReplicaDescription[];
  GlobalTableArn?: string;
  CreationDateTime?: Date;
  GlobalTableStatus?: GlobalTableStatus;
  GlobalTableName?: string;
}
export interface CreateGlobalTableOutput {
  GlobalTableDescription?: GlobalTableDescription;
}
export declare class GlobalTableAlreadyExistsException extends __BaseException {
  readonly name: "GlobalTableAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      GlobalTableAlreadyExistsException,
      __BaseException
    >
  );
}
export interface CreateReplicaAction {
  RegionName: string | undefined;
}
export interface ReplicaGlobalSecondaryIndex {
  IndexName: string | undefined;
  ProvisionedThroughputOverride?: ProvisionedThroughputOverride;
  OnDemandThroughputOverride?: OnDemandThroughputOverride;
}
export interface CreateReplicationGroupMemberAction {
  RegionName: string | undefined;
  KMSMasterKeyId?: string;
  ProvisionedThroughputOverride?: ProvisionedThroughputOverride;
  OnDemandThroughputOverride?: OnDemandThroughputOverride;
  GlobalSecondaryIndexes?: ReplicaGlobalSecondaryIndex[];
  TableClassOverride?: TableClass;
}
export interface GlobalSecondaryIndex {
  IndexName: string | undefined;
  KeySchema: KeySchemaElement[] | undefined;
  Projection: Projection | undefined;
  ProvisionedThroughput?: ProvisionedThroughput;
  OnDemandThroughput?: OnDemandThroughput;
}
export interface LocalSecondaryIndex {
  IndexName: string | undefined;
  KeySchema: KeySchemaElement[] | undefined;
  Projection: Projection | undefined;
}
export interface SSESpecification {
  Enabled?: boolean;
  SSEType?: SSEType;
  KMSMasterKeyId?: string;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateTableInput {
  AttributeDefinitions: AttributeDefinition[] | undefined;
  TableName: string | undefined;
  KeySchema: KeySchemaElement[] | undefined;
  LocalSecondaryIndexes?: LocalSecondaryIndex[];
  GlobalSecondaryIndexes?: GlobalSecondaryIndex[];
  BillingMode?: BillingMode;
  ProvisionedThroughput?: ProvisionedThroughput;
  StreamSpecification?: StreamSpecification;
  SSESpecification?: SSESpecification;
  Tags?: Tag[];
  TableClass?: TableClass;
  DeletionProtectionEnabled?: boolean;
  ResourcePolicy?: string;
  OnDemandThroughput?: OnDemandThroughput;
}
export declare const IndexStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATING: "CREATING";
  readonly DELETING: "DELETING";
  readonly UPDATING: "UPDATING";
};
export type IndexStatus = (typeof IndexStatus)[keyof typeof IndexStatus];
export interface ProvisionedThroughputDescription {
  LastIncreaseDateTime?: Date;
  LastDecreaseDateTime?: Date;
  NumberOfDecreasesToday?: number;
  ReadCapacityUnits?: number;
  WriteCapacityUnits?: number;
}
export interface GlobalSecondaryIndexDescription {
  IndexName?: string;
  KeySchema?: KeySchemaElement[];
  Projection?: Projection;
  IndexStatus?: IndexStatus;
  Backfilling?: boolean;
  ProvisionedThroughput?: ProvisionedThroughputDescription;
  IndexSizeBytes?: number;
  ItemCount?: number;
  IndexArn?: string;
  OnDemandThroughput?: OnDemandThroughput;
}
export interface LocalSecondaryIndexDescription {
  IndexName?: string;
  KeySchema?: KeySchemaElement[];
  Projection?: Projection;
  IndexSizeBytes?: number;
  ItemCount?: number;
  IndexArn?: string;
}
export interface RestoreSummary {
  SourceBackupArn?: string;
  SourceTableArn?: string;
  RestoreDateTime: Date | undefined;
  RestoreInProgress: boolean | undefined;
}
export declare const TableStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly ARCHIVED: "ARCHIVED";
  readonly ARCHIVING: "ARCHIVING";
  readonly CREATING: "CREATING";
  readonly DELETING: "DELETING";
  readonly INACCESSIBLE_ENCRYPTION_CREDENTIALS: "INACCESSIBLE_ENCRYPTION_CREDENTIALS";
  readonly UPDATING: "UPDATING";
};
export type TableStatus = (typeof TableStatus)[keyof typeof TableStatus];
export interface TableDescription {
  AttributeDefinitions?: AttributeDefinition[];
  TableName?: string;
  KeySchema?: KeySchemaElement[];
  TableStatus?: TableStatus;
  CreationDateTime?: Date;
  ProvisionedThroughput?: ProvisionedThroughputDescription;
  TableSizeBytes?: number;
  ItemCount?: number;
  TableArn?: string;
  TableId?: string;
  BillingModeSummary?: BillingModeSummary;
  LocalSecondaryIndexes?: LocalSecondaryIndexDescription[];
  GlobalSecondaryIndexes?: GlobalSecondaryIndexDescription[];
  StreamSpecification?: StreamSpecification;
  LatestStreamLabel?: string;
  LatestStreamArn?: string;
  GlobalTableVersion?: string;
  Replicas?: ReplicaDescription[];
  RestoreSummary?: RestoreSummary;
  SSEDescription?: SSEDescription;
  ArchivalSummary?: ArchivalSummary;
  TableClassSummary?: TableClassSummary;
  DeletionProtectionEnabled?: boolean;
  OnDemandThroughput?: OnDemandThroughput;
}
export interface CreateTableOutput {
  TableDescription?: TableDescription;
}
export declare class ResourceInUseException extends __BaseException {
  readonly name: "ResourceInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceInUseException, __BaseException>
  );
}
export interface CsvOptions {
  Delimiter?: string;
  HeaderList?: string[];
}
export interface DeleteBackupInput {
  BackupArn: string | undefined;
}
export interface DeleteBackupOutput {
  BackupDescription?: BackupDescription;
}
export interface DeleteGlobalSecondaryIndexAction {
  IndexName: string | undefined;
}
export declare const ReturnValue: {
  readonly ALL_NEW: "ALL_NEW";
  readonly ALL_OLD: "ALL_OLD";
  readonly NONE: "NONE";
  readonly UPDATED_NEW: "UPDATED_NEW";
  readonly UPDATED_OLD: "UPDATED_OLD";
};
export type ReturnValue = (typeof ReturnValue)[keyof typeof ReturnValue];
export declare class TransactionConflictException extends __BaseException {
  readonly name: "TransactionConflictException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TransactionConflictException, __BaseException>
  );
}
export interface DeleteReplicaAction {
  RegionName: string | undefined;
}
export interface DeleteReplicationGroupMemberAction {
  RegionName: string | undefined;
}
export interface DeleteResourcePolicyInput {
  ResourceArn: string | undefined;
  ExpectedRevisionId?: string;
}
export interface DeleteResourcePolicyOutput {
  RevisionId?: string;
}
export declare class PolicyNotFoundException extends __BaseException {
  readonly name: "PolicyNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PolicyNotFoundException, __BaseException>
  );
}
export interface DeleteTableInput {
  TableName: string | undefined;
}
export interface DeleteTableOutput {
  TableDescription?: TableDescription;
}
export interface DescribeBackupInput {
  BackupArn: string | undefined;
}
export interface DescribeBackupOutput {
  BackupDescription?: BackupDescription;
}
export interface DescribeContinuousBackupsInput {
  TableName: string | undefined;
}
export interface DescribeContinuousBackupsOutput {
  ContinuousBackupsDescription?: ContinuousBackupsDescription;
}
export interface DescribeContributorInsightsInput {
  TableName: string | undefined;
  IndexName?: string;
}
export interface FailureException {
  ExceptionName?: string;
  ExceptionDescription?: string;
}
export interface DescribeContributorInsightsOutput {
  TableName?: string;
  IndexName?: string;
  ContributorInsightsRuleList?: string[];
  ContributorInsightsStatus?: ContributorInsightsStatus;
  LastUpdateDateTime?: Date;
  FailureException?: FailureException;
}
export interface DescribeEndpointsRequest {}
export interface Endpoint {
  Address: string | undefined;
  CachePeriodInMinutes: number | undefined;
}
export interface DescribeEndpointsResponse {
  Endpoints: Endpoint[] | undefined;
}
export interface DescribeExportInput {
  ExportArn: string | undefined;
}
export declare const ExportFormat: {
  readonly DYNAMODB_JSON: "DYNAMODB_JSON";
  readonly ION: "ION";
};
export type ExportFormat = (typeof ExportFormat)[keyof typeof ExportFormat];
export declare const ExportStatus: {
  readonly COMPLETED: "COMPLETED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type ExportStatus = (typeof ExportStatus)[keyof typeof ExportStatus];
export declare const ExportType: {
  readonly FULL_EXPORT: "FULL_EXPORT";
  readonly INCREMENTAL_EXPORT: "INCREMENTAL_EXPORT";
};
export type ExportType = (typeof ExportType)[keyof typeof ExportType];
export declare const ExportViewType: {
  readonly NEW_AND_OLD_IMAGES: "NEW_AND_OLD_IMAGES";
  readonly NEW_IMAGE: "NEW_IMAGE";
};
export type ExportViewType =
  (typeof ExportViewType)[keyof typeof ExportViewType];
export interface IncrementalExportSpecification {
  ExportFromTime?: Date;
  ExportToTime?: Date;
  ExportViewType?: ExportViewType;
}
export declare const S3SseAlgorithm: {
  readonly AES256: "AES256";
  readonly KMS: "KMS";
};
export type S3SseAlgorithm =
  (typeof S3SseAlgorithm)[keyof typeof S3SseAlgorithm];
export interface ExportDescription {
  ExportArn?: string;
  ExportStatus?: ExportStatus;
  StartTime?: Date;
  EndTime?: Date;
  ExportManifest?: string;
  TableArn?: string;
  TableId?: string;
  ExportTime?: Date;
  ClientToken?: string;
  S3Bucket?: string;
  S3BucketOwner?: string;
  S3Prefix?: string;
  S3SseAlgorithm?: S3SseAlgorithm;
  S3SseKmsKeyId?: string;
  FailureCode?: string;
  FailureMessage?: string;
  ExportFormat?: ExportFormat;
  BilledSizeBytes?: number;
  ItemCount?: number;
  ExportType?: ExportType;
  IncrementalExportSpecification?: IncrementalExportSpecification;
}
export interface DescribeExportOutput {
  ExportDescription?: ExportDescription;
}
export declare class ExportNotFoundException extends __BaseException {
  readonly name: "ExportNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExportNotFoundException, __BaseException>
  );
}
export interface DescribeGlobalTableInput {
  GlobalTableName: string | undefined;
}
export interface DescribeGlobalTableOutput {
  GlobalTableDescription?: GlobalTableDescription;
}
export declare class GlobalTableNotFoundException extends __BaseException {
  readonly name: "GlobalTableNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<GlobalTableNotFoundException, __BaseException>
  );
}
export interface DescribeGlobalTableSettingsInput {
  GlobalTableName: string | undefined;
}
export interface ReplicaGlobalSecondaryIndexSettingsDescription {
  IndexName: string | undefined;
  IndexStatus?: IndexStatus;
  ProvisionedReadCapacityUnits?: number;
  ProvisionedReadCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
  ProvisionedWriteCapacityUnits?: number;
  ProvisionedWriteCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
}
export interface ReplicaSettingsDescription {
  RegionName: string | undefined;
  ReplicaStatus?: ReplicaStatus;
  ReplicaBillingModeSummary?: BillingModeSummary;
  ReplicaProvisionedReadCapacityUnits?: number;
  ReplicaProvisionedReadCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
  ReplicaProvisionedWriteCapacityUnits?: number;
  ReplicaProvisionedWriteCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
  ReplicaGlobalSecondaryIndexSettings?: ReplicaGlobalSecondaryIndexSettingsDescription[];
  ReplicaTableClassSummary?: TableClassSummary;
}
export interface DescribeGlobalTableSettingsOutput {
  GlobalTableName?: string;
  ReplicaSettings?: ReplicaSettingsDescription[];
}
export interface DescribeImportInput {
  ImportArn: string | undefined;
}
export declare const ImportStatus: {
  readonly CANCELLED: "CANCELLED";
  readonly CANCELLING: "CANCELLING";
  readonly COMPLETED: "COMPLETED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type ImportStatus = (typeof ImportStatus)[keyof typeof ImportStatus];
export declare const InputCompressionType: {
  readonly GZIP: "GZIP";
  readonly NONE: "NONE";
  readonly ZSTD: "ZSTD";
};
export type InputCompressionType =
  (typeof InputCompressionType)[keyof typeof InputCompressionType];
export declare const InputFormat: {
  readonly CSV: "CSV";
  readonly DYNAMODB_JSON: "DYNAMODB_JSON";
  readonly ION: "ION";
};
export type InputFormat = (typeof InputFormat)[keyof typeof InputFormat];
export interface InputFormatOptions {
  Csv?: CsvOptions;
}
export interface S3BucketSource {
  S3BucketOwner?: string;
  S3Bucket: string | undefined;
  S3KeyPrefix?: string;
}
export interface TableCreationParameters {
  TableName: string | undefined;
  AttributeDefinitions: AttributeDefinition[] | undefined;
  KeySchema: KeySchemaElement[] | undefined;
  BillingMode?: BillingMode;
  ProvisionedThroughput?: ProvisionedThroughput;
  OnDemandThroughput?: OnDemandThroughput;
  SSESpecification?: SSESpecification;
  GlobalSecondaryIndexes?: GlobalSecondaryIndex[];
}
export interface ImportTableDescription {
  ImportArn?: string;
  ImportStatus?: ImportStatus;
  TableArn?: string;
  TableId?: string;
  ClientToken?: string;
  S3BucketSource?: S3BucketSource;
  ErrorCount?: number;
  CloudWatchLogGroupArn?: string;
  InputFormat?: InputFormat;
  InputFormatOptions?: InputFormatOptions;
  InputCompressionType?: InputCompressionType;
  TableCreationParameters?: TableCreationParameters;
  StartTime?: Date;
  EndTime?: Date;
  ProcessedSizeBytes?: number;
  ProcessedItemCount?: number;
  ImportedItemCount?: number;
  FailureCode?: string;
  FailureMessage?: string;
}
export interface DescribeImportOutput {
  ImportTableDescription: ImportTableDescription | undefined;
}
export declare class ImportNotFoundException extends __BaseException {
  readonly name: "ImportNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ImportNotFoundException, __BaseException>
  );
}
export interface DescribeKinesisStreamingDestinationInput {
  TableName: string | undefined;
}
export declare const DestinationStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly DISABLED: "DISABLED";
  readonly DISABLING: "DISABLING";
  readonly ENABLE_FAILED: "ENABLE_FAILED";
  readonly ENABLING: "ENABLING";
  readonly UPDATING: "UPDATING";
};
export type DestinationStatus =
  (typeof DestinationStatus)[keyof typeof DestinationStatus];
export interface KinesisDataStreamDestination {
  StreamArn?: string;
  DestinationStatus?: DestinationStatus;
  DestinationStatusDescription?: string;
  ApproximateCreationDateTimePrecision?: ApproximateCreationDateTimePrecision;
}
export interface DescribeKinesisStreamingDestinationOutput {
  TableName?: string;
  KinesisDataStreamDestinations?: KinesisDataStreamDestination[];
}
export interface DescribeLimitsInput {}
export interface DescribeLimitsOutput {
  AccountMaxReadCapacityUnits?: number;
  AccountMaxWriteCapacityUnits?: number;
  TableMaxReadCapacityUnits?: number;
  TableMaxWriteCapacityUnits?: number;
}
export interface DescribeTableInput {
  TableName: string | undefined;
}
export interface DescribeTableOutput {
  Table?: TableDescription;
}
export interface DescribeTableReplicaAutoScalingInput {
  TableName: string | undefined;
}
export interface ReplicaGlobalSecondaryIndexAutoScalingDescription {
  IndexName?: string;
  IndexStatus?: IndexStatus;
  ProvisionedReadCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
  ProvisionedWriteCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
}
export interface ReplicaAutoScalingDescription {
  RegionName?: string;
  GlobalSecondaryIndexes?: ReplicaGlobalSecondaryIndexAutoScalingDescription[];
  ReplicaProvisionedReadCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
  ReplicaProvisionedWriteCapacityAutoScalingSettings?: AutoScalingSettingsDescription;
  ReplicaStatus?: ReplicaStatus;
}
export interface TableAutoScalingDescription {
  TableName?: string;
  TableStatus?: TableStatus;
  Replicas?: ReplicaAutoScalingDescription[];
}
export interface DescribeTableReplicaAutoScalingOutput {
  TableAutoScalingDescription?: TableAutoScalingDescription;
}
export interface DescribeTimeToLiveInput {
  TableName: string | undefined;
}
export interface DescribeTimeToLiveOutput {
  TimeToLiveDescription?: TimeToLiveDescription;
}
export interface EnableKinesisStreamingConfiguration {
  ApproximateCreationDateTimePrecision?: ApproximateCreationDateTimePrecision;
}
export interface KinesisStreamingDestinationInput {
  TableName: string | undefined;
  StreamArn: string | undefined;
  EnableKinesisStreamingConfiguration?: EnableKinesisStreamingConfiguration;
}
export interface KinesisStreamingDestinationOutput {
  TableName?: string;
  StreamArn?: string;
  DestinationStatus?: DestinationStatus;
  EnableKinesisStreamingConfiguration?: EnableKinesisStreamingConfiguration;
}
export declare class DuplicateItemException extends __BaseException {
  readonly name: "DuplicateItemException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DuplicateItemException, __BaseException>
  );
}
export declare class IdempotentParameterMismatchException extends __BaseException {
  readonly name: "IdempotentParameterMismatchException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      IdempotentParameterMismatchException,
      __BaseException
    >
  );
}
export declare class TransactionInProgressException extends __BaseException {
  readonly name: "TransactionInProgressException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<TransactionInProgressException, __BaseException>
  );
}
export declare class ExportConflictException extends __BaseException {
  readonly name: "ExportConflictException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExportConflictException, __BaseException>
  );
}
export interface ExportTableToPointInTimeInput {
  TableArn: string | undefined;
  ExportTime?: Date;
  ClientToken?: string;
  S3Bucket: string | undefined;
  S3BucketOwner?: string;
  S3Prefix?: string;
  S3SseAlgorithm?: S3SseAlgorithm;
  S3SseKmsKeyId?: string;
  ExportFormat?: ExportFormat;
  ExportType?: ExportType;
  IncrementalExportSpecification?: IncrementalExportSpecification;
}
export interface ExportTableToPointInTimeOutput {
  ExportDescription?: ExportDescription;
}
export declare class InvalidExportTimeException extends __BaseException {
  readonly name: "InvalidExportTimeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidExportTimeException, __BaseException>
  );
}
export declare class PointInTimeRecoveryUnavailableException extends __BaseException {
  readonly name: "PointInTimeRecoveryUnavailableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PointInTimeRecoveryUnavailableException,
      __BaseException
    >
  );
}
export interface GetResourcePolicyInput {
  ResourceArn: string | undefined;
}
export interface GetResourcePolicyOutput {
  Policy?: string;
  RevisionId?: string;
}
export declare class ImportConflictException extends __BaseException {
  readonly name: "ImportConflictException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ImportConflictException, __BaseException>
  );
}
export interface ImportTableInput {
  ClientToken?: string;
  S3BucketSource: S3BucketSource | undefined;
  InputFormat: InputFormat | undefined;
  InputFormatOptions?: InputFormatOptions;
  InputCompressionType?: InputCompressionType;
  TableCreationParameters: TableCreationParameters | undefined;
}
export interface ImportTableOutput {
  ImportTableDescription: ImportTableDescription | undefined;
}
export interface ListBackupsInput {
  TableName?: string;
  Limit?: number;
  TimeRangeLowerBound?: Date;
  TimeRangeUpperBound?: Date;
  ExclusiveStartBackupArn?: string;
  BackupType?: BackupTypeFilter;
}
export interface ListBackupsOutput {
  BackupSummaries?: BackupSummary[];
  LastEvaluatedBackupArn?: string;
}
export interface ListContributorInsightsInput {
  TableName?: string;
  NextToken?: string;
  MaxResults?: number;
}
export interface ListContributorInsightsOutput {
  ContributorInsightsSummaries?: ContributorInsightsSummary[];
  NextToken?: string;
}
export interface ListExportsInput {
  TableArn?: string;
  MaxResults?: number;
  NextToken?: string;
}
export interface ExportSummary {
  ExportArn?: string;
  ExportStatus?: ExportStatus;
  ExportType?: ExportType;
}
export interface ListExportsOutput {
  ExportSummaries?: ExportSummary[];
  NextToken?: string;
}
export interface ListGlobalTablesInput {
  ExclusiveStartGlobalTableName?: string;
  Limit?: number;
  RegionName?: string;
}
export interface GlobalTable {
  GlobalTableName?: string;
  ReplicationGroup?: Replica[];
}
export interface ListGlobalTablesOutput {
  GlobalTables?: GlobalTable[];
  LastEvaluatedGlobalTableName?: string;
}
export interface ListImportsInput {
  TableArn?: string;
  PageSize?: number;
  NextToken?: string;
}
export interface ImportSummary {
  ImportArn?: string;
  ImportStatus?: ImportStatus;
  TableArn?: string;
  S3BucketSource?: S3BucketSource;
  CloudWatchLogGroupArn?: string;
  InputFormat?: InputFormat;
  StartTime?: Date;
  EndTime?: Date;
}
export interface ListImportsOutput {
  ImportSummaryList?: ImportSummary[];
  NextToken?: string;
}
export interface ListTablesInput {
  ExclusiveStartTableName?: string;
  Limit?: number;
}
export interface ListTablesOutput {
  TableNames?: string[];
  LastEvaluatedTableName?: string;
}
export interface ListTagsOfResourceInput {
  ResourceArn: string | undefined;
  NextToken?: string;
}
export interface ListTagsOfResourceOutput {
  Tags?: Tag[];
  NextToken?: string;
}
export interface PutResourcePolicyInput {
  ResourceArn: string | undefined;
  Policy: string | undefined;
  ExpectedRevisionId?: string;
  ConfirmRemoveSelfResourceAccess?: boolean;
}
export interface PutResourcePolicyOutput {
  RevisionId?: string;
}
export declare const Select: {
  readonly ALL_ATTRIBUTES: "ALL_ATTRIBUTES";
  readonly ALL_PROJECTED_ATTRIBUTES: "ALL_PROJECTED_ATTRIBUTES";
  readonly COUNT: "COUNT";
  readonly SPECIFIC_ATTRIBUTES: "SPECIFIC_ATTRIBUTES";
};
export type Select = (typeof Select)[keyof typeof Select];
export interface RestoreTableFromBackupInput {
  TargetTableName: string | undefined;
  BackupArn: string | undefined;
  BillingModeOverride?: BillingMode;
  GlobalSecondaryIndexOverride?: GlobalSecondaryIndex[];
  LocalSecondaryIndexOverride?: LocalSecondaryIndex[];
  ProvisionedThroughputOverride?: ProvisionedThroughput;
  OnDemandThroughputOverride?: OnDemandThroughput;
  SSESpecificationOverride?: SSESpecification;
}
export interface RestoreTableFromBackupOutput {
  TableDescription?: TableDescription;
}
export declare class TableAlreadyExistsException extends __BaseException {
  readonly name: "TableAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TableAlreadyExistsException, __BaseException>
  );
}
export declare class InvalidRestoreTimeException extends __BaseException {
  readonly name: "InvalidRestoreTimeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRestoreTimeException, __BaseException>
  );
}
export interface RestoreTableToPointInTimeInput {
  SourceTableArn?: string;
  SourceTableName?: string;
  TargetTableName: string | undefined;
  UseLatestRestorableTime?: boolean;
  RestoreDateTime?: Date;
  BillingModeOverride?: BillingMode;
  GlobalSecondaryIndexOverride?: GlobalSecondaryIndex[];
  LocalSecondaryIndexOverride?: LocalSecondaryIndex[];
  ProvisionedThroughputOverride?: ProvisionedThroughput;
  OnDemandThroughputOverride?: OnDemandThroughput;
  SSESpecificationOverride?: SSESpecification;
}
export interface RestoreTableToPointInTimeOutput {
  TableDescription?: TableDescription;
}
export interface TagResourceInput {
  ResourceArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagResourceInput {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface PointInTimeRecoverySpecification {
  PointInTimeRecoveryEnabled: boolean | undefined;
}
export interface UpdateContinuousBackupsInput {
  TableName: string | undefined;
  PointInTimeRecoverySpecification:
    | PointInTimeRecoverySpecification
    | undefined;
}
export interface UpdateContinuousBackupsOutput {
  ContinuousBackupsDescription?: ContinuousBackupsDescription;
}
export interface UpdateContributorInsightsInput {
  TableName: string | undefined;
  IndexName?: string;
  ContributorInsightsAction: ContributorInsightsAction | undefined;
}
export interface UpdateContributorInsightsOutput {
  TableName?: string;
  IndexName?: string;
  ContributorInsightsStatus?: ContributorInsightsStatus;
}
export declare class ReplicaAlreadyExistsException extends __BaseException {
  readonly name: "ReplicaAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ReplicaAlreadyExistsException, __BaseException>
  );
}
export declare class ReplicaNotFoundException extends __BaseException {
  readonly name: "ReplicaNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ReplicaNotFoundException, __BaseException>
  );
}
export interface ReplicaUpdate {
  Create?: CreateReplicaAction;
  Delete?: DeleteReplicaAction;
}
export interface UpdateGlobalTableInput {
  GlobalTableName: string | undefined;
  ReplicaUpdates: ReplicaUpdate[] | undefined;
}
export interface UpdateGlobalTableOutput {
  GlobalTableDescription?: GlobalTableDescription;
}
export declare class IndexNotFoundException extends __BaseException {
  readonly name: "IndexNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IndexNotFoundException, __BaseException>
  );
}
export interface GlobalTableGlobalSecondaryIndexSettingsUpdate {
  IndexName: string | undefined;
  ProvisionedWriteCapacityUnits?: number;
  ProvisionedWriteCapacityAutoScalingSettingsUpdate?: AutoScalingSettingsUpdate;
}
export interface ReplicaGlobalSecondaryIndexSettingsUpdate {
  IndexName: string | undefined;
  ProvisionedReadCapacityUnits?: number;
  ProvisionedReadCapacityAutoScalingSettingsUpdate?: AutoScalingSettingsUpdate;
}
export interface ReplicaSettingsUpdate {
  RegionName: string | undefined;
  ReplicaProvisionedReadCapacityUnits?: number;
  ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate?: AutoScalingSettingsUpdate;
  ReplicaGlobalSecondaryIndexSettingsUpdate?: ReplicaGlobalSecondaryIndexSettingsUpdate[];
  ReplicaTableClass?: TableClass;
}
export interface UpdateGlobalTableSettingsInput {
  GlobalTableName: string | undefined;
  GlobalTableBillingMode?: BillingMode;
  GlobalTableProvisionedWriteCapacityUnits?: number;
  GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate?: AutoScalingSettingsUpdate;
  GlobalTableGlobalSecondaryIndexSettingsUpdate?: GlobalTableGlobalSecondaryIndexSettingsUpdate[];
  ReplicaSettingsUpdate?: ReplicaSettingsUpdate[];
}
export interface UpdateGlobalTableSettingsOutput {
  GlobalTableName?: string;
  ReplicaSettings?: ReplicaSettingsDescription[];
}
export interface UpdateKinesisStreamingConfiguration {
  ApproximateCreationDateTimePrecision?: ApproximateCreationDateTimePrecision;
}
export interface UpdateKinesisStreamingDestinationInput {
  TableName: string | undefined;
  StreamArn: string | undefined;
  UpdateKinesisStreamingConfiguration?: UpdateKinesisStreamingConfiguration;
}
export interface UpdateKinesisStreamingDestinationOutput {
  TableName?: string;
  StreamArn?: string;
  DestinationStatus?: DestinationStatus;
  UpdateKinesisStreamingConfiguration?: UpdateKinesisStreamingConfiguration;
}
export interface UpdateGlobalSecondaryIndexAction {
  IndexName: string | undefined;
  ProvisionedThroughput?: ProvisionedThroughput;
  OnDemandThroughput?: OnDemandThroughput;
}
export interface GlobalSecondaryIndexUpdate {
  Update?: UpdateGlobalSecondaryIndexAction;
  Create?: CreateGlobalSecondaryIndexAction;
  Delete?: DeleteGlobalSecondaryIndexAction;
}
export interface UpdateReplicationGroupMemberAction {
  RegionName: string | undefined;
  KMSMasterKeyId?: string;
  ProvisionedThroughputOverride?: ProvisionedThroughputOverride;
  OnDemandThroughputOverride?: OnDemandThroughputOverride;
  GlobalSecondaryIndexes?: ReplicaGlobalSecondaryIndex[];
  TableClassOverride?: TableClass;
}
export interface ReplicationGroupUpdate {
  Create?: CreateReplicationGroupMemberAction;
  Update?: UpdateReplicationGroupMemberAction;
  Delete?: DeleteReplicationGroupMemberAction;
}
export interface UpdateTableInput {
  AttributeDefinitions?: AttributeDefinition[];
  TableName: string | undefined;
  BillingMode?: BillingMode;
  ProvisionedThroughput?: ProvisionedThroughput;
  GlobalSecondaryIndexUpdates?: GlobalSecondaryIndexUpdate[];
  StreamSpecification?: StreamSpecification;
  SSESpecification?: SSESpecification;
  ReplicaUpdates?: ReplicationGroupUpdate[];
  TableClass?: TableClass;
  DeletionProtectionEnabled?: boolean;
  OnDemandThroughput?: OnDemandThroughput;
}
export interface UpdateTableOutput {
  TableDescription?: TableDescription;
}
export interface GlobalSecondaryIndexAutoScalingUpdate {
  IndexName?: string;
  ProvisionedWriteCapacityAutoScalingUpdate?: AutoScalingSettingsUpdate;
}
export interface ReplicaGlobalSecondaryIndexAutoScalingUpdate {
  IndexName?: string;
  ProvisionedReadCapacityAutoScalingUpdate?: AutoScalingSettingsUpdate;
}
export interface ReplicaAutoScalingUpdate {
  RegionName: string | undefined;
  ReplicaGlobalSecondaryIndexUpdates?: ReplicaGlobalSecondaryIndexAutoScalingUpdate[];
  ReplicaProvisionedReadCapacityAutoScalingUpdate?: AutoScalingSettingsUpdate;
}
export interface UpdateTableReplicaAutoScalingInput {
  GlobalSecondaryIndexUpdates?: GlobalSecondaryIndexAutoScalingUpdate[];
  TableName: string | undefined;
  ProvisionedWriteCapacityAutoScalingUpdate?: AutoScalingSettingsUpdate;
  ReplicaUpdates?: ReplicaAutoScalingUpdate[];
}
export interface UpdateTableReplicaAutoScalingOutput {
  TableAutoScalingDescription?: TableAutoScalingDescription;
}
export interface TimeToLiveSpecification {
  Enabled: boolean | undefined;
  AttributeName: string | undefined;
}
export interface UpdateTimeToLiveInput {
  TableName: string | undefined;
  TimeToLiveSpecification: TimeToLiveSpecification | undefined;
}
export interface UpdateTimeToLiveOutput {
  TimeToLiveSpecification?: TimeToLiveSpecification;
}
export type AttributeValue =
  | AttributeValue.BMember
  | AttributeValue.BOOLMember
  | AttributeValue.BSMember
  | AttributeValue.LMember
  | AttributeValue.MMember
  | AttributeValue.NMember
  | AttributeValue.NSMember
  | AttributeValue.NULLMember
  | AttributeValue.SMember
  | AttributeValue.SSMember
  | AttributeValue.$UnknownMember;
export declare namespace AttributeValue {
  interface SMember {
    S: string;
    N?: never;
    B?: never;
    SS?: never;
    NS?: never;
    BS?: never;
    M?: never;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface NMember {
    S?: never;
    N: string;
    B?: never;
    SS?: never;
    NS?: never;
    BS?: never;
    M?: never;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface BMember {
    S?: never;
    N?: never;
    B: Uint8Array;
    SS?: never;
    NS?: never;
    BS?: never;
    M?: never;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface SSMember {
    S?: never;
    N?: never;
    B?: never;
    SS: string[];
    NS?: never;
    BS?: never;
    M?: never;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface NSMember {
    S?: never;
    N?: never;
    B?: never;
    SS?: never;
    NS: string[];
    BS?: never;
    M?: never;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface BSMember {
    S?: never;
    N?: never;
    B?: never;
    SS?: never;
    NS?: never;
    BS: Uint8Array[];
    M?: never;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface MMember {
    S?: never;
    N?: never;
    B?: never;
    SS?: never;
    NS?: never;
    BS?: never;
    M: Record<string, AttributeValue>;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface LMember {
    S?: never;
    N?: never;
    B?: never;
    SS?: never;
    NS?: never;
    BS?: never;
    M?: never;
    L: AttributeValue[];
    NULL?: never;
    BOOL?: never;
    $unknown?: never;
  }
  interface NULLMember {
    S?: never;
    N?: never;
    B?: never;
    SS?: never;
    NS?: never;
    BS?: never;
    M?: never;
    L?: never;
    NULL: boolean;
    BOOL?: never;
    $unknown?: never;
  }
  interface BOOLMember {
    S?: never;
    N?: never;
    B?: never;
    SS?: never;
    NS?: never;
    BS?: never;
    M?: never;
    L?: never;
    NULL?: never;
    BOOL: boolean;
    $unknown?: never;
  }
  interface $UnknownMember {
    S?: never;
    N?: never;
    B?: never;
    SS?: never;
    NS?: never;
    BS?: never;
    M?: never;
    L?: never;
    NULL?: never;
    BOOL?: never;
    $unknown: [string, any];
  }
  interface Visitor<T> {
    S: (value: string) => T;
    N: (value: string) => T;
    B: (value: Uint8Array) => T;
    SS: (value: string[]) => T;
    NS: (value: string[]) => T;
    BS: (value: Uint8Array[]) => T;
    M: (value: Record<string, AttributeValue>) => T;
    L: (value: AttributeValue[]) => T;
    NULL: (value: boolean) => T;
    BOOL: (value: boolean) => T;
    _: (name: string, value: any) => T;
  }
  const visit: <T>(value: AttributeValue, visitor: Visitor<T>) => T;
}
export interface AttributeValueUpdate {
  Value?: AttributeValue;
  Action?: AttributeAction;
}
export interface BatchStatementError {
  Code?: BatchStatementErrorCodeEnum;
  Message?: string;
  Item?: Record<string, AttributeValue>;
}
export interface BatchStatementRequest {
  Statement: string | undefined;
  Parameters?: AttributeValue[];
  ConsistentRead?: boolean;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface CancellationReason {
  Item?: Record<string, AttributeValue>;
  Code?: string;
  Message?: string;
}
export interface Condition {
  AttributeValueList?: AttributeValue[];
  ComparisonOperator: ComparisonOperator | undefined;
}
export declare class ConditionalCheckFailedException extends __BaseException {
  readonly name: "ConditionalCheckFailedException";
  readonly $fault: "client";
  Item?: Record<string, AttributeValue>;
  constructor(
    opts: __ExceptionOptionType<
      ConditionalCheckFailedException,
      __BaseException
    >
  );
}
export interface DeleteRequest {
  Key: Record<string, AttributeValue> | undefined;
}
export interface ExecuteStatementInput {
  Statement: string | undefined;
  Parameters?: AttributeValue[];
  ConsistentRead?: boolean;
  NextToken?: string;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  Limit?: number;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface Get {
  Key: Record<string, AttributeValue> | undefined;
  TableName: string | undefined;
  ProjectionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
}
export interface GetItemInput {
  TableName: string | undefined;
  Key: Record<string, AttributeValue> | undefined;
  AttributesToGet?: string[];
  ConsistentRead?: boolean;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  ProjectionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
}
export interface GetItemOutput {
  Item?: Record<string, AttributeValue>;
  ConsumedCapacity?: ConsumedCapacity;
}
export interface ItemCollectionMetrics {
  ItemCollectionKey?: Record<string, AttributeValue>;
  SizeEstimateRangeGB?: number[];
}
export interface ItemResponse {
  Item?: Record<string, AttributeValue>;
}
export interface ParameterizedStatement {
  Statement: string | undefined;
  Parameters?: AttributeValue[];
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface PutRequest {
  Item: Record<string, AttributeValue> | undefined;
}
export interface KeysAndAttributes {
  Keys: Record<string, AttributeValue>[] | undefined;
  AttributesToGet?: string[];
  ConsistentRead?: boolean;
  ProjectionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
}
export interface TransactGetItem {
  Get: Get | undefined;
}
export interface BatchExecuteStatementInput {
  Statements: BatchStatementRequest[] | undefined;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
}
export interface ExecuteTransactionInput {
  TransactStatements: ParameterizedStatement[] | undefined;
  ClientRequestToken?: string;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
}
export interface ExecuteTransactionOutput {
  Responses?: ItemResponse[];
  ConsumedCapacity?: ConsumedCapacity[];
}
export interface TransactGetItemsOutput {
  ConsumedCapacity?: ConsumedCapacity[];
  Responses?: ItemResponse[];
}
export declare class TransactionCanceledException extends __BaseException {
  readonly name: "TransactionCanceledException";
  readonly $fault: "client";
  Message?: string;
  CancellationReasons?: CancellationReason[];
  constructor(
    opts: __ExceptionOptionType<TransactionCanceledException, __BaseException>
  );
}
export interface BatchGetItemInput {
  RequestItems: Record<string, KeysAndAttributes> | undefined;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
}
export interface ExpectedAttributeValue {
  Value?: AttributeValue;
  Exists?: boolean;
  ComparisonOperator?: ComparisonOperator;
  AttributeValueList?: AttributeValue[];
}
export interface TransactGetItemsInput {
  TransactItems: TransactGetItem[] | undefined;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
}
export interface TransactWriteItemsOutput {
  ConsumedCapacity?: ConsumedCapacity[];
  ItemCollectionMetrics?: Record<string, ItemCollectionMetrics[]>;
}
export interface ConditionCheck {
  Key: Record<string, AttributeValue> | undefined;
  TableName: string | undefined;
  ConditionExpression: string | undefined;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface Delete {
  Key: Record<string, AttributeValue> | undefined;
  TableName: string | undefined;
  ConditionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface Put {
  Item: Record<string, AttributeValue> | undefined;
  TableName: string | undefined;
  ConditionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface Update {
  Key: Record<string, AttributeValue> | undefined;
  UpdateExpression: string | undefined;
  TableName: string | undefined;
  ConditionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface BatchStatementResponse {
  Error?: BatchStatementError;
  TableName?: string;
  Item?: Record<string, AttributeValue>;
}
export interface DeleteItemOutput {
  Attributes?: Record<string, AttributeValue>;
  ConsumedCapacity?: ConsumedCapacity;
  ItemCollectionMetrics?: ItemCollectionMetrics;
}
export interface ExecuteStatementOutput {
  Items?: Record<string, AttributeValue>[];
  NextToken?: string;
  ConsumedCapacity?: ConsumedCapacity;
  LastEvaluatedKey?: Record<string, AttributeValue>;
}
export interface PutItemOutput {
  Attributes?: Record<string, AttributeValue>;
  ConsumedCapacity?: ConsumedCapacity;
  ItemCollectionMetrics?: ItemCollectionMetrics;
}
export interface QueryOutput {
  Items?: Record<string, AttributeValue>[];
  Count?: number;
  ScannedCount?: number;
  LastEvaluatedKey?: Record<string, AttributeValue>;
  ConsumedCapacity?: ConsumedCapacity;
}
export interface ScanOutput {
  Items?: Record<string, AttributeValue>[];
  Count?: number;
  ScannedCount?: number;
  LastEvaluatedKey?: Record<string, AttributeValue>;
  ConsumedCapacity?: ConsumedCapacity;
}
export interface UpdateItemOutput {
  Attributes?: Record<string, AttributeValue>;
  ConsumedCapacity?: ConsumedCapacity;
  ItemCollectionMetrics?: ItemCollectionMetrics;
}
export interface WriteRequest {
  PutRequest?: PutRequest;
  DeleteRequest?: DeleteRequest;
}
export interface BatchExecuteStatementOutput {
  Responses?: BatchStatementResponse[];
  ConsumedCapacity?: ConsumedCapacity[];
}
export interface BatchGetItemOutput {
  Responses?: Record<string, Record<string, AttributeValue>[]>;
  UnprocessedKeys?: Record<string, KeysAndAttributes>;
  ConsumedCapacity?: ConsumedCapacity[];
}
export interface ScanInput {
  TableName: string | undefined;
  IndexName?: string;
  AttributesToGet?: string[];
  Limit?: number;
  Select?: Select;
  ScanFilter?: Record<string, Condition>;
  ConditionalOperator?: ConditionalOperator;
  ExclusiveStartKey?: Record<string, AttributeValue>;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  TotalSegments?: number;
  Segment?: number;
  ProjectionExpression?: string;
  FilterExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ConsistentRead?: boolean;
}
export interface BatchWriteItemInput {
  RequestItems: Record<string, WriteRequest[]> | undefined;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  ReturnItemCollectionMetrics?: ReturnItemCollectionMetrics;
}
export interface DeleteItemInput {
  TableName: string | undefined;
  Key: Record<string, AttributeValue> | undefined;
  Expected?: Record<string, ExpectedAttributeValue>;
  ConditionalOperator?: ConditionalOperator;
  ReturnValues?: ReturnValue;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  ReturnItemCollectionMetrics?: ReturnItemCollectionMetrics;
  ConditionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface PutItemInput {
  TableName: string | undefined;
  Item: Record<string, AttributeValue> | undefined;
  Expected?: Record<string, ExpectedAttributeValue>;
  ReturnValues?: ReturnValue;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  ReturnItemCollectionMetrics?: ReturnItemCollectionMetrics;
  ConditionalOperator?: ConditionalOperator;
  ConditionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface QueryInput {
  TableName: string | undefined;
  IndexName?: string;
  Select?: Select;
  AttributesToGet?: string[];
  Limit?: number;
  ConsistentRead?: boolean;
  KeyConditions?: Record<string, Condition>;
  QueryFilter?: Record<string, Condition>;
  ConditionalOperator?: ConditionalOperator;
  ScanIndexForward?: boolean;
  ExclusiveStartKey?: Record<string, AttributeValue>;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  ProjectionExpression?: string;
  FilterExpression?: string;
  KeyConditionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
}
export interface BatchWriteItemOutput {
  UnprocessedItems?: Record<string, WriteRequest[]>;
  ItemCollectionMetrics?: Record<string, ItemCollectionMetrics[]>;
  ConsumedCapacity?: ConsumedCapacity[];
}
export interface UpdateItemInput {
  TableName: string | undefined;
  Key: Record<string, AttributeValue> | undefined;
  AttributeUpdates?: Record<string, AttributeValueUpdate>;
  Expected?: Record<string, ExpectedAttributeValue>;
  ConditionalOperator?: ConditionalOperator;
  ReturnValues?: ReturnValue;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  ReturnItemCollectionMetrics?: ReturnItemCollectionMetrics;
  UpdateExpression?: string;
  ConditionExpression?: string;
  ExpressionAttributeNames?: Record<string, string>;
  ExpressionAttributeValues?: Record<string, AttributeValue>;
  ReturnValuesOnConditionCheckFailure?: ReturnValuesOnConditionCheckFailure;
}
export interface TransactWriteItem {
  ConditionCheck?: ConditionCheck;
  Put?: Put;
  Delete?: Delete;
  Update?: Update;
}
export interface TransactWriteItemsInput {
  TransactItems: TransactWriteItem[] | undefined;
  ReturnConsumedCapacity?: ReturnConsumedCapacity;
  ReturnItemCollectionMetrics?: ReturnItemCollectionMetrics;
  ClientRequestToken?: string;
}
