import { AwsSdkSigV4AuthInputConfig, AwsSdkSigV4AuthResolvedConfig, AwsSdkSigV4PreviouslyResolved } from "@aws-sdk/core";
import { HandlerExecutionContext, HttpAuthScheme, HttpAuthSchemeParameters, HttpAuthSchemeParametersProvider, HttpAuthSchemeProvider } from "@smithy/types";
import { DynamoDBClientResolvedConfig } from "../DynamoDBClient";
/**
 * @internal
 */
export interface DynamoDBHttpAuthSchemeParameters extends HttpAuthSchemeParameters {
    region?: string;
}
/**
 * @internal
 */
export interface DynamoDBHttpAuthSchemeParametersProvider extends HttpAuthSchemeParametersProvider<DynamoDBClientResolvedConfig, HandlerExecutionContext, DynamoDBHttpAuthSchemeParameters, object> {
}
/**
 * @internal
 */
export declare const defaultDynamoDBHttpAuthSchemeParametersProvider: (config: DynamoDBClientResolvedConfig, context: HandlerExecutionContext, input: object) => Promise<DynamoDBHttpAuthSchemeParameters>;
/**
 * @internal
 */
export interface DynamoDBHttpAuthSchemeProvider extends HttpAuthSchemeProvider<DynamoDBHttpAuthSchemeParameters> {
}
/**
 * @internal
 */
export declare const defaultDynamoDBHttpAuthSchemeProvider: DynamoDBHttpAuthSchemeProvider;
/**
 * @internal
 */
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
    /**
     * Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    httpAuthSchemes?: HttpAuthScheme[];
    /**
     * Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    httpAuthSchemeProvider?: DynamoDBHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export interface HttpAuthSchemeResolvedConfig extends AwsSdkSigV4AuthResolvedConfig {
    /**
     * Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    readonly httpAuthSchemes: HttpAuthScheme[];
    /**
     * Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    readonly httpAuthSchemeProvider: DynamoDBHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export declare const resolveHttpAuthSchemeConfig: <T>(config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved) => T & HttpAuthSchemeResolvedConfig;
