import { DynamoDBServiceException as __BaseException } from "./DynamoDBServiceException";
export const ApproximateCreationDateTimePrecision = {
    MICROSECOND: "MICROSECOND",
    MILLISECOND: "MILLISECOND",
};
export const AttributeAction = {
    ADD: "ADD",
    DELETE: "DELETE",
    PUT: "PUT",
};
export const ScalarAttributeType = {
    B: "B",
    N: "N",
    S: "S",
};
export const BackupStatus = {
    AVAILABLE: "AVAILABLE",
    CREATING: "CREATING",
    DELETED: "DELETED",
};
export const BackupType = {
    AWS_BACKUP: "AWS_BACKUP",
    SYSTEM: "SYSTEM",
    USER: "USER",
};
export const BillingMode = {
    PAY_PER_REQUEST: "PAY_PER_REQUEST",
    PROVISIONED: "PROVISIONED",
};
export const KeyType = {
    HASH: "HASH",
    RANGE: "RANGE",
};
export const ProjectionType = {
    ALL: "ALL",
    INCLUDE: "INCLUDE",
    KEYS_ONLY: "KEYS_ONLY",
};
export const SSEType = {
    AES256: "AES256",
    KMS: "KMS",
};
export const SSEStatus = {
    DISABLED: "DISABLED",
    DISABLING: "DISABLING",
    ENABLED: "ENABLED",
    ENABLING: "ENABLING",
    UPDATING: "UPDATING",
};
export const StreamViewType = {
    KEYS_ONLY: "KEYS_ONLY",
    NEW_AND_OLD_IMAGES: "NEW_AND_OLD_IMAGES",
    NEW_IMAGE: "NEW_IMAGE",
    OLD_IMAGE: "OLD_IMAGE",
};
export const TimeToLiveStatus = {
    DISABLED: "DISABLED",
    DISABLING: "DISABLING",
    ENABLED: "ENABLED",
    ENABLING: "ENABLING",
};
export class BackupInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "BackupInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "BackupInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BackupInUseException.prototype);
    }
}
export class BackupNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "BackupNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "BackupNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BackupNotFoundException.prototype);
    }
}
export const BackupTypeFilter = {
    ALL: "ALL",
    AWS_BACKUP: "AWS_BACKUP",
    SYSTEM: "SYSTEM",
    USER: "USER",
};
export const ReturnConsumedCapacity = {
    INDEXES: "INDEXES",
    NONE: "NONE",
    TOTAL: "TOTAL",
};
export const ReturnValuesOnConditionCheckFailure = {
    ALL_OLD: "ALL_OLD",
    NONE: "NONE",
};
export const BatchStatementErrorCodeEnum = {
    AccessDenied: "AccessDenied",
    ConditionalCheckFailed: "ConditionalCheckFailed",
    DuplicateItem: "DuplicateItem",
    InternalServerError: "InternalServerError",
    ItemCollectionSizeLimitExceeded: "ItemCollectionSizeLimitExceeded",
    ProvisionedThroughputExceeded: "ProvisionedThroughputExceeded",
    RequestLimitExceeded: "RequestLimitExceeded",
    ResourceNotFound: "ResourceNotFound",
    ThrottlingError: "ThrottlingError",
    TransactionConflict: "TransactionConflict",
    ValidationError: "ValidationError",
};
export class InternalServerError extends __BaseException {
    constructor(opts) {
        super({
            name: "InternalServerError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServerError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServerError.prototype);
    }
}
export class RequestLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "RequestLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "RequestLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, RequestLimitExceeded.prototype);
    }
}
export class InvalidEndpointException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidEndpointException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidEndpointException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidEndpointException.prototype);
        this.Message = opts.Message;
    }
}
export class ProvisionedThroughputExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ProvisionedThroughputExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ProvisionedThroughputExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ProvisionedThroughputExceededException.prototype);
    }
}
export class ResourceNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
    }
}
export const ReturnItemCollectionMetrics = {
    NONE: "NONE",
    SIZE: "SIZE",
};
export class ItemCollectionSizeLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ItemCollectionSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ItemCollectionSizeLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ItemCollectionSizeLimitExceededException.prototype);
    }
}
export const ComparisonOperator = {
    BEGINS_WITH: "BEGINS_WITH",
    BETWEEN: "BETWEEN",
    CONTAINS: "CONTAINS",
    EQ: "EQ",
    GE: "GE",
    GT: "GT",
    IN: "IN",
    LE: "LE",
    LT: "LT",
    NE: "NE",
    NOT_CONTAINS: "NOT_CONTAINS",
    NOT_NULL: "NOT_NULL",
    NULL: "NULL",
};
export const ConditionalOperator = {
    AND: "AND",
    OR: "OR",
};
export const ContinuousBackupsStatus = {
    DISABLED: "DISABLED",
    ENABLED: "ENABLED",
};
export const PointInTimeRecoveryStatus = {
    DISABLED: "DISABLED",
    ENABLED: "ENABLED",
};
export class ContinuousBackupsUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "ContinuousBackupsUnavailableException",
            $fault: "client",
            ...opts,
        });
        this.name = "ContinuousBackupsUnavailableException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ContinuousBackupsUnavailableException.prototype);
    }
}
export const ContributorInsightsAction = {
    DISABLE: "DISABLE",
    ENABLE: "ENABLE",
};
export const ContributorInsightsStatus = {
    DISABLED: "DISABLED",
    DISABLING: "DISABLING",
    ENABLED: "ENABLED",
    ENABLING: "ENABLING",
    FAILED: "FAILED",
};
export class LimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
    }
}
export class TableInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "TableInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "TableInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TableInUseException.prototype);
    }
}
export class TableNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "TableNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "TableNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TableNotFoundException.prototype);
    }
}
export const GlobalTableStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    UPDATING: "UPDATING",
};
export const ReplicaStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    CREATION_FAILED: "CREATION_FAILED",
    DELETING: "DELETING",
    INACCESSIBLE_ENCRYPTION_CREDENTIALS: "INACCESSIBLE_ENCRYPTION_CREDENTIALS",
    REGION_DISABLED: "REGION_DISABLED",
    UPDATING: "UPDATING",
};
export const TableClass = {
    STANDARD: "STANDARD",
    STANDARD_INFREQUENT_ACCESS: "STANDARD_INFREQUENT_ACCESS",
};
export class GlobalTableAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "GlobalTableAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "GlobalTableAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, GlobalTableAlreadyExistsException.prototype);
    }
}
export const IndexStatus = {
    ACTIVE: "ACTIVE",
    CREATING: "CREATING",
    DELETING: "DELETING",
    UPDATING: "UPDATING",
};
export const TableStatus = {
    ACTIVE: "ACTIVE",
    ARCHIVED: "ARCHIVED",
    ARCHIVING: "ARCHIVING",
    CREATING: "CREATING",
    DELETING: "DELETING",
    INACCESSIBLE_ENCRYPTION_CREDENTIALS: "INACCESSIBLE_ENCRYPTION_CREDENTIALS",
    UPDATING: "UPDATING",
};
export class ResourceInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
    }
}
export const ReturnValue = {
    ALL_NEW: "ALL_NEW",
    ALL_OLD: "ALL_OLD",
    NONE: "NONE",
    UPDATED_NEW: "UPDATED_NEW",
    UPDATED_OLD: "UPDATED_OLD",
};
export class TransactionConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "TransactionConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "TransactionConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TransactionConflictException.prototype);
    }
}
export class PolicyNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "PolicyNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "PolicyNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PolicyNotFoundException.prototype);
    }
}
export const ExportFormat = {
    DYNAMODB_JSON: "DYNAMODB_JSON",
    ION: "ION",
};
export const ExportStatus = {
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
export const ExportType = {
    FULL_EXPORT: "FULL_EXPORT",
    INCREMENTAL_EXPORT: "INCREMENTAL_EXPORT",
};
export const ExportViewType = {
    NEW_AND_OLD_IMAGES: "NEW_AND_OLD_IMAGES",
    NEW_IMAGE: "NEW_IMAGE",
};
export const S3SseAlgorithm = {
    AES256: "AES256",
    KMS: "KMS",
};
export class ExportNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ExportNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ExportNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ExportNotFoundException.prototype);
    }
}
export class GlobalTableNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "GlobalTableNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "GlobalTableNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, GlobalTableNotFoundException.prototype);
    }
}
export const ImportStatus = {
    CANCELLED: "CANCELLED",
    CANCELLING: "CANCELLING",
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
export const InputCompressionType = {
    GZIP: "GZIP",
    NONE: "NONE",
    ZSTD: "ZSTD",
};
export const InputFormat = {
    CSV: "CSV",
    DYNAMODB_JSON: "DYNAMODB_JSON",
    ION: "ION",
};
export class ImportNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ImportNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ImportNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ImportNotFoundException.prototype);
    }
}
export const DestinationStatus = {
    ACTIVE: "ACTIVE",
    DISABLED: "DISABLED",
    DISABLING: "DISABLING",
    ENABLE_FAILED: "ENABLE_FAILED",
    ENABLING: "ENABLING",
    UPDATING: "UPDATING",
};
export class DuplicateItemException extends __BaseException {
    constructor(opts) {
        super({
            name: "DuplicateItemException",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateItemException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateItemException.prototype);
    }
}
export class IdempotentParameterMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "IdempotentParameterMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "IdempotentParameterMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IdempotentParameterMismatchException.prototype);
        this.Message = opts.Message;
    }
}
export class TransactionInProgressException extends __BaseException {
    constructor(opts) {
        super({
            name: "TransactionInProgressException",
            $fault: "client",
            ...opts,
        });
        this.name = "TransactionInProgressException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TransactionInProgressException.prototype);
        this.Message = opts.Message;
    }
}
export class ExportConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ExportConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ExportConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ExportConflictException.prototype);
    }
}
export class InvalidExportTimeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidExportTimeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidExportTimeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidExportTimeException.prototype);
    }
}
export class PointInTimeRecoveryUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "PointInTimeRecoveryUnavailableException",
            $fault: "client",
            ...opts,
        });
        this.name = "PointInTimeRecoveryUnavailableException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PointInTimeRecoveryUnavailableException.prototype);
    }
}
export class ImportConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ImportConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ImportConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ImportConflictException.prototype);
    }
}
export const Select = {
    ALL_ATTRIBUTES: "ALL_ATTRIBUTES",
    ALL_PROJECTED_ATTRIBUTES: "ALL_PROJECTED_ATTRIBUTES",
    COUNT: "COUNT",
    SPECIFIC_ATTRIBUTES: "SPECIFIC_ATTRIBUTES",
};
export class TableAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "TableAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "TableAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TableAlreadyExistsException.prototype);
    }
}
export class InvalidRestoreTimeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRestoreTimeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRestoreTimeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRestoreTimeException.prototype);
    }
}
export class ReplicaAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "ReplicaAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ReplicaAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ReplicaAlreadyExistsException.prototype);
    }
}
export class ReplicaNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ReplicaNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ReplicaNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ReplicaNotFoundException.prototype);
    }
}
export class IndexNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "IndexNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "IndexNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IndexNotFoundException.prototype);
    }
}
export var AttributeValue;
(function (AttributeValue) {
    AttributeValue.visit = (value, visitor) => {
        if (value.S !== undefined)
            return visitor.S(value.S);
        if (value.N !== undefined)
            return visitor.N(value.N);
        if (value.B !== undefined)
            return visitor.B(value.B);
        if (value.SS !== undefined)
            return visitor.SS(value.SS);
        if (value.NS !== undefined)
            return visitor.NS(value.NS);
        if (value.BS !== undefined)
            return visitor.BS(value.BS);
        if (value.M !== undefined)
            return visitor.M(value.M);
        if (value.L !== undefined)
            return visitor.L(value.L);
        if (value.NULL !== undefined)
            return visitor.NULL(value.NULL);
        if (value.BOOL !== undefined)
            return visitor.BOOL(value.BOOL);
        return visitor._(value.$unknown[0], value.$unknown[1]);
    };
})(AttributeValue || (AttributeValue = {}));
export class ConditionalCheckFailedException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConditionalCheckFailedException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConditionalCheckFailedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConditionalCheckFailedException.prototype);
        this.Item = opts.Item;
    }
}
export class TransactionCanceledException extends __BaseException {
    constructor(opts) {
        super({
            name: "TransactionCanceledException",
            $fault: "client",
            ...opts,
        });
        this.name = "TransactionCanceledException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TransactionCanceledException.prototype);
        this.Message = opts.Message;
        this.CancellationReasons = opts.CancellationReasons;
    }
}
