import type { BeanCollection, ComponentSelector, DragAndDropIcon, DragItem, DragSourceType, DropTarget } from '@ag-grid-community/core';
import { Component } from '@ag-grid-community/core';
export type PillDragCompEvent = 'columnRemove';
export declare abstract class PillDragComp<TItem> extends Component<PillDragCompEvent> {
    private dragSourceDropTarget;
    private ghost;
    private horizontal;
    private template?;
    private agComponents?;
    private dragAndDropService;
    wireBeans(beans: BeanCollection): void;
    private readonly eText;
    private readonly eDragHandle;
    private readonly eButton;
    abstract getItem(): TItem;
    protected abstract getDisplayName(): string;
    protected abstract getAriaDisplayName(): string;
    protected abstract getTooltip(): string | null | undefined;
    protected abstract createGetDragItem(): () => DragItem<TItem>;
    protected abstract getDragSourceType(): DragSourceType;
    constructor(dragSourceDropTarget: DropTarget, ghost: boolean, horizontal: boolean, template?: string | undefined, agComponents?: ComponentSelector[] | undefined);
    postConstruct(): void;
    protected isDraggable(): boolean;
    protected refreshDraggable(): void;
    protected setupAria(): void;
    protected addAdditionalAriaInstructions(ariaInstructions: string[], translate: (key: string, defaultValue: string) => string): void;
    private setupTooltip;
    protected getDragSourceId(): string | undefined;
    protected getDefaultIconName(): DragAndDropIcon;
    private addDragSource;
    protected setupComponents(): void;
    protected isRemovable(): boolean;
    protected refreshRemove(): void;
    private setupRemove;
    protected onKeyDown(e: KeyboardEvent): void;
    protected getDisplayValue(): string;
    private setTextValue;
    private addElementClasses;
    destroy(): void;
}
