![AG Grid HTML5 Grid trusted by the community, built for enterprise](./github-banner.png 'AG Grid')

[![CDNJS](https://img.shields.io/cdnjs/v/ag-grid)](https://cdnjs.com/libraries/ag-grid) [![Github Stars](https://img.shields.io/github/stars/ag-grid/ag-grid?style=social)](https://github.com/ag-grid/ag-grid) [![Twitter](https://img.shields.io/twitter/follow/ag_grid?style=social)](https://twitter.com/ag_grid)

| Module                   |                                                                                                                                                                                                                                                                                                           Info |
| ------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| @ag-grid-enterprise/core | [![npm](https://img.shields.io/npm/dm/@ag-grid-enterprise/core)](https://www.npmjs.com/package/@ag-grid-enterprise/core) <br> [![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=ag-grid-enterprise&metric=alert_status)](https://sonarcloud.io/dashboard?id=ag-grid-enterprise) |

# AG Grid Enterprise

---

AG Grid is a fully-featured and highly customizable JavaScript data grid.
It delivers [outstanding performance](https://www.ag-grid.com/example?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github), has no third-party dependencies and [integrates smoothly with all major JavaScript frameworks](https://www.ag-grid.com/javascript-data-grid/?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github).

This is not free software, this software is covered by copyright and to use you need a commercial license.

![Image of AG Grid showing filtering and grouping enabled.](./github-grid-demo.jpg 'AG Grid demo')

## Features

Besides the standard set of features you'd expect from any grid:

-   Column Interactions (resize, reorder, and pin columns)
-   Pagination
-   Sorting
-   Row Selection

Here are some of the features that make AG Grid stand out:

-   Grouping / Aggregation \*
-   Accessibility support
-   Custom Filtering
-   In-place Cell Editing
-   Records Lazy Loading \*
-   Server-Side Records Operations \*
-   Live Stream Updates
-   Hierarchical Data Support & Tree View \*
-   Customizable Appearance
-   Customizable Cell Contents
-   State Persistence
-   Keyboard Navigation
-   Data Export to CSV
-   Data Export to Excel \*
-   Excel-like Pivoting \*
-   Row Reordering
-   Copy / Paste
-   Column Spanning
-   Pinned Rows
-   Full Width Rows
-   Integrated Charting
-   Sparklines

-   The features marked with an asterisk are available in the [enterprise version](https://www.ag-grid.com/license-pricing?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github) only.

Check out [developers documentation](https://www.ag-grid.com/javascript-data-grid?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github) for a complete list of features or visit [our official docs](https://www.ag-grid.com/features-overview?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github) for tutorials and feature demos.

-   [Get Started with JavaScript](https://www.ag-grid.com/javascript-grid?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github)
-   [Get Started with Angular](https://www.ag-grid.com/angular-grid?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github)
-   [Get Started with React](https://www.ag-grid.com/react-grid?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github)
-   [Get Started with Vue](https://www.ag-grid.com/vue-getting-started?utm_source=ag-grid-readme&utm_medium=repository&utm_campaign=github)

## Issue Reporting

If you are an Enterprise customer (or are evaluating AG Grid Enterprise) and wish to report a Bug or raise a new Feature Request please do so on our [Support Portal](https://ag-grid.zendesk.com/).

To Sign Up:
Send an email to accounts@ag-grid.com with your license key

## Asking Questions

Look for similar problems on [StackOverflow](https://stackoverflow.com/questions/tagged/ag-grid) using the `ag-grid` tag, or refer to our [Support Portal](https://ag-grid.zendesk.com/). If nothing seems related, post a new message there. Do not use GitHub issues to ask questions.

## Contributing

AG Grid is developed by a team of co-located developers in London. If you want to join the team send your application to info@ag-grid.com.

## License

Please refer to the [LICENSE](LICENSE.md) and [SUPPORT_AND_MAINTENANCE](SUPPORT_AND_MAINTENANCE.md).
