import { BeanStub } from '../../context/beanStub';
import type { BeanCollection } from '../../context/context';
import type { DragAndDropIcon, DraggingEvent } from '../../dragAndDrop/dragAndDropService';
import type { AgColumn } from '../../entities/agColumn';
import type { ColumnEventType } from '../../events';
import type { ColumnPinnedType } from '../../interfaces/iColumn';
import type { DropListener } from './bodyDropTarget';
export declare class MoveColumnFeature extends BeanStub implements DropListener {
    private columnModel;
    private visibleColsService;
    private columnMoveService;
    private dragAndDropService;
    private ctrlsService;
    wireBeans(beans: BeanCollection): void;
    private gridBodyCon;
    private needToMoveLeft;
    private needToMoveRight;
    private movingIntervalId;
    private intervalCount;
    private pinned;
    private isCenterContainer;
    private lastDraggingEvent;
    private lastMovedInfo;
    private failedMoveAttempts;
    constructor(pinned: ColumnPinnedType);
    postConstruct(): void;
    getIconName(): DragAndDropIcon;
    onDragEnter(draggingEvent: DraggingEvent): void;
    onDragLeave(): void;
    setColumnsVisible(columns: AgColumn[] | null | undefined, visible: boolean, source: ColumnEventType): void;
    setColumnsPinned(columns: AgColumn[] | null | undefined, pinned: ColumnPinnedType, source: ColumnEventType): void;
    onDragStop(): void;
    private checkCenterForScrolling;
    onDragging(draggingEvent?: DraggingEvent, fromEnter?: boolean, fakeEvent?: boolean, finished?: boolean): void;
    private normaliseDirection;
    private ensureIntervalStarted;
    private ensureIntervalCleared;
    private moveInterval;
}
