/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.Pack;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import com.sage.izpack.ModifyInstallationUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreValidatePacksPanelAction
implements PanelAction {
    private static final Logger logger = Logger.getLogger(PreValidatePacksPanelAction.class.getName());
    private static final String prefixLabel = "PreValidatePacksPanelAction - ";
    private Map<String, Pack> installedpacks = null;

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler uiHandler) {
        boolean modifyinstallation = ModifyInstallationUtil.get(installData);
        this.installedpacks = new HashMap<String, Pack>();
        HashMap<String, Serializable> installedpacksBis = new HashMap<String, Serializable>();
        if (modifyinstallation) {
            logger.log(Level.FINE, "PreValidatePacksPanelAction - Update mode, loading installed packs ...");
            try {
                File file = new File(installData.getInstallPath() + File.separator + ".installationinformation");
                if (file.exists()) {
                    FileInputStream fin = new FileInputStream(file);
                    ObjectInputStream oin = new ObjectInputStream(fin);
                    List packsinstalled = (List)oin.readObject();
                    for (Object aPacksinstalled : packsinstalled) {
                        Serializable installedpack;
                        if (aPacksinstalled instanceof Pack) {
                            installedpack = (Pack)aPacksinstalled;
                            ((Pack)installedpack).setHidden(false);
                            this.installedpacks.put(((Pack)installedpack).name, (Pack)installedpack);
                            logger.log(Level.FINE, "PreValidatePacksPanelAction - found pack " + ((Pack)installedpack).name);
                        }
                        if (!(aPacksinstalled instanceof com.izforge.izpack.api.data.Pack)) continue;
                        installedpack = (com.izforge.izpack.api.data.Pack)aPacksinstalled;
                        ((com.izforge.izpack.api.data.Pack)installedpack).setPreselected(true);
                        if (installedpacksBis.get(((com.izforge.izpack.api.data.Pack)installedpack).getName()) == null) {
                            installedpacksBis.put(((com.izforge.izpack.api.data.Pack)installedpack).getName(), installedpack);
                        }
                        logger.log(Level.FINE, "PreValidatePacksPanelAction - found " + ((com.izforge.izpack.api.data.Pack)installedpack).getName());
                    }
                    ArrayList<com.izforge.izpack.api.data.Pack> packages = new ArrayList<com.izforge.izpack.api.data.Pack>();
                    for (com.izforge.izpack.api.data.Pack aPack : installData.getAvailablePacks()) {
                        if (!this.installedpacks.containsKey(aPack.getName()) && !installedpacksBis.containsKey(aPack.getName())) continue;
                        aPack.setPreselected(true);
                        if (packages.contains(aPack.getName())) continue;
                        logger.log(Level.FINE, "PreValidatePacksPanelAction - Add package '" + aPack.getName() + "' as selected");
                        packages.add(aPack);
                    }
                    installData.setSelectedPacks(packages);
                    logger.log(Level.FINE, "PreValidatePacksPanelAction - Found " + packsinstalled.size() + " packs in informationInstallation. " + packages.size() + " selected packages.");
                    logger.log(Level.FINE, "PreValidatePacksPanelAction - Loading properties ...");
                    Properties variables = (Properties)oin.readObject();
                    for (String string : variables.keySet()) {
                        if (!string.equals("UNINSTALL_NAME")) continue;
                        installData.setVariable(string, (String)variables.get(string));
                        logger.log(Level.FINE, prefixLabel + string + "=" + (String)variables.get(string));
                    }
                    fin.close();
                } else {
                    logger.log(Level.FINE, "PreValidatePacksPanelAction - File " + file.getAbsolutePath() + " doesn't exist.");
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.WARNING, e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    private void removeAlreadyInstalledPacks(List<com.izforge.izpack.api.data.Pack> selectedpacks) {
        ArrayList<com.izforge.izpack.api.data.Pack> removepacks = new ArrayList<com.izforge.izpack.api.data.Pack>();
        for (com.izforge.izpack.api.data.Pack selectedpack : selectedpacks) {
            String key = selectedpack.getName();
            if (!this.installedpacks.containsKey(key)) continue;
            removepacks.add(selectedpack);
        }
        for (com.izforge.izpack.api.data.Pack removepack : removepacks) {
            selectedpacks.remove(removepack);
        }
    }
}

