/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.packs.PacksModel;
import com.izforge.izpack.panels.packs.PacksPanel;
import com.izforge.izpack.panels.packs.PacksPanelBase;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.PacksNewPanelAutomationHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PacksNewPanel
extends PacksPanel {
    private static final long serialVersionUID = 2809544763635023846L;
    private static final Logger logger = Logger.getLogger(PacksNewPanel.class.getName());
    private static final String prefixLabel = "PacksNewPanel - ";

    public PacksNewPanel(Panel panel, InstallerFrame frame, GUIInstallData installData, Resources resources, ObjectFactory factory) {
        super(panel, frame, installData, resources, factory);
    }

    @Override
    protected JTable createPacksTable(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        logger.log(Level.FINE, "PacksNewPanel - createPacksTable");
        PacksNewPanelAutomationHelper.preselectRequired(this.installData);
        JTable table = super.createPacksTable(width, scroller, layout, constraints);
        logger.log(Level.FINE, "PacksNewPanel - createPacksTable constraints: " + constraints + " ");
        return table;
    }

    @Override
    public void panelActivate() {
        LinkedList<Pack> selectedPacks;
        logger.log(Level.FINE, "PacksNewPanel - panelActivate");
        PacksNewPanelAutomationHelper.readInstallationInformation(this.installData);
        if (this.installData.getSelectedPacks().isEmpty()) {
            logger.log(Level.FINE, "PacksNewPanel - panelActivate : getSelectedPacks().isEmpty()");
            selectedPacks = new LinkedList<Pack>();
            for (Pack p : this.installData.getAvailablePacks()) {
                if (!p.isRequired() || selectedPacks.contains(p)) continue;
                selectedPacks.add(p);
                logger.log(Level.FINE, "PacksNewPanel - panelActivate : add selectedPacks:" + p.getName());
            }
            logger.log(Level.FINE, "PacksNewPanel - panelActivate : selectedPacks:" + selectedPacks);
            this.installData.setSelectedPacks(selectedPacks);
        } else {
            logger.log(Level.FINE, "PacksNewPanel - panelActivate : getSelectedPacks() : " + this.installData.getSelectedPacks());
            this.parent.unlockNextButton();
        }
        super.panelActivate();
        if (this.installData.getSelectedPacks().isEmpty()) {
            logger.log(Level.FINE, "PacksNewPanel - panelActivate2 : getSelectedPacks().isEmpty()");
            selectedPacks = new LinkedList();
            for (Pack p : this.installData.getAvailablePacks()) {
                if (!p.isRequired() || selectedPacks.contains(p)) continue;
                selectedPacks.add(p);
                logger.log(Level.FINE, "PacksNewPanel - panelActivate2 : add selectedPacks:" + p.getName());
            }
            logger.log(Level.FINE, "PacksNewPanel - panelActivate2 : selectedPacks:" + selectedPacks);
            this.installData.setSelectedPacks(selectedPacks);
            if (!this.installData.getSelectedPacks().isEmpty()) {
                this.parent.unlockNextButton();
            }
        } else {
            logger.log(Level.FINE, "PacksNewPanel - panelActivate2 : getSelectedPacks() : " + this.installData.getSelectedPacks());
            this.parent.unlockNextButton();
        }
        Map<String, Pack> installedpacks = this.packsModel.getInstalledPacks();
        CheckBoxNewRenderer packSelectedRenderer = new CheckBoxNewRenderer();
        this.packsTable.getColumnModel().getColumn(0).setCellRenderer(packSelectedRenderer);
        logger.log(Level.FINE, "PacksNewPanel - panelActivate2 : installedpacks : " + installedpacks);
    }

    @Override
    public boolean isValidated() {
        logger.log(Level.FINE, "PacksNewPanel - isValidated : ");
        boolean isValidated = super.isValidated();
        logger.log(Level.FINE, "PacksNewPanel - isValidated : " + isValidated);
        return isValidated;
    }

    static class CheckBoxNewRenderer
    implements TableCellRenderer {
        JCheckBox checkbox = new JCheckBox();

        CheckBoxNewRenderer() {
            if (OsVersion.IS_UNIX && !OsVersion.IS_OSX) {
                this.checkbox.setIcon(new PacksPanelBase.LFIndependentIcon());
                this.checkbox.setDisabledIcon(new PacksPanelBase.LFIndependentIcon());
                this.checkbox.setSelectedIcon(new PacksPanelBase.LFIndependentIcon());
                this.checkbox.setDisabledSelectedIcon(new PacksPanelBase.LFIndependentIcon());
            }
            this.checkbox.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            logger.log(Level.FINE, "PacksNewPanel - CheckBoxNewRenderer : " + value + " isSelected: " + isSelected);
            if (isSelected) {
                this.checkbox.setForeground(table.getSelectionForeground());
                this.checkbox.setBackground(table.getSelectionBackground());
            } else {
                this.checkbox.setForeground(table.getForeground());
                this.checkbox.setBackground(table.getBackground());
            }
            PacksModel.CbSelectionState state = (PacksModel.CbSelectionState)((Object)value);
            logger.log(Level.FINE, "PacksNewPanel - CheckBoxNewRenderer : state: " + (Object)((Object)state) + " state.isSelectedOrRequiredSelected() : " + state.isSelectedOrRequiredSelected() + "  state.isChecked() : " + state.isChecked() + "  value: " + value);
            if (state == PacksModel.CbSelectionState.DEPENDENT_DESELECTED) {
                this.checkbox.setForeground(Color.GRAY);
                logger.log(Level.FINE, "PacksNewPanel - CheckBoxNewRenderer :  condition not fulfilled");
            }
            if (state == PacksModel.CbSelectionState.REQUIRED_PARTIAL_SELECTED) {
                logger.log(Level.FINE, "PacksNewPanel - CheckBoxNewRenderer :  setSelected");
                this.checkbox.setForeground(Color.RED);
                this.checkbox.setSelected(true);
            }
            if (state != null) {
                logger.log(Level.FINE, "PacksNewPanel - CheckBoxNewRenderer :  setSelected? : " + (value != null && state.isChecked()));
                this.checkbox.setEnabled(state.isSelectable());
                this.checkbox.setSelected(value != null && state.isChecked());
            }
            return this.checkbox;
        }
    }
}

