/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.internal.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyPairGeneratorHelper {
    private static final Logger logger = Logger.getLogger(KeyPairGeneratorHelper.class.getName());
    private static final String prefixLabel = "KeyPairGeneratorHelper - ";

    public static void writePrivateKey(String filename, KeyPair key, char[] passphrase) throws IOException {
        logger.log(Level.FINE, "KeyPairGeneratorHelper - writePrivateKey");
        Security.addProvider((Provider)new BouncyCastleProvider());
        try (FileWriter writer = new FileWriter(filename);
             JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);){
            JcePEMEncryptorBuilder jeb = new JcePEMEncryptorBuilder("DES-EDE3-CBC");
            jeb.setProvider("BC");
            if (passphrase != null && passphrase.length > 0) {
                PEMEncryptor pemEncryptor = jeb.build(passphrase);
                pemWriter.writeObject((Object)key, pemEncryptor);
            } else {
                pemWriter.writeObject((Object)key);
            }
            pemWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(File[] files, File mergedFile) throws IOException {
        logger.log(Level.FINE, "KeyPairGeneratorHelper - mergeFiles");
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(mergedFile);
            for (File f : files) {
                int c;
                in = new FileInputStream(f);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static X500NameBuilder buildX500Name(String country, String organization, String organizationalUnit, String state, String locality, String name, String email) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        if (!StringUtil.isNullOrBlank(country)) {
            builder.addRDN(BCStyle.C, country);
        }
        if (!StringUtil.isNullOrBlank(organization)) {
            builder.addRDN(BCStyle.O, organization);
        }
        if (!StringUtil.isNullOrBlank(organizationalUnit)) {
            builder.addRDN(BCStyle.OU, organizationalUnit);
        }
        if (!StringUtil.isNullOrBlank(state)) {
            builder.addRDN(BCStyle.ST, state);
        }
        if (!StringUtil.isNullOrBlank(locality)) {
            builder.addRDN(BCStyle.L, locality);
        }
        if (!StringUtil.isNullOrBlank(name)) {
            builder.addRDN(BCStyle.CN, name);
        }
        if (!StringUtil.isNullOrBlank(email)) {
            builder.addRDN(BCStyle.E, email);
        }
        return builder;
    }

    public static X509Certificate generateClientV3Certificate(KeyPair pair, String country, String organization, String organizationalUnit, String state, String locality, String name, String email, int validity, X509Certificate certCA, KeyPair pairCA) throws Exception {
        logger.log(Level.FINE, "KeyPairGeneratorHelper - generateClientV3Certificate");
        Security.addProvider((Provider)new BouncyCastleProvider());
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        if (!StringUtil.isNullOrBlank(country)) {
            builder.addRDN(BCStyle.C, country);
        }
        if (!StringUtil.isNullOrBlank(organization)) {
            builder.addRDN(BCStyle.O, organization);
        }
        if (!StringUtil.isNullOrBlank(organizationalUnit)) {
            builder.addRDN(BCStyle.OU, organizationalUnit);
        }
        if (!StringUtil.isNullOrBlank(state)) {
            builder.addRDN(BCStyle.ST, state);
        }
        if (!StringUtil.isNullOrBlank(locality)) {
            builder.addRDN(BCStyle.L, locality);
        }
        builder.addRDN(BCStyle.CN, "client");
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(6, validity);
        Date notAfter = cal.getTime();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(certCA, serial, notBefore, notAfter, builder.build(), pair.getPublic());
        certGen.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        certGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(152));
        certGen.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(pairCA.getPrivate());
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certGen.build(sigGen));
        cert.checkValidity(new Date());
        cert.verify(pairCA.getPublic());
        return cert;
    }

    public static X509Certificate generateCAV3Certificate(KeyPair pair, String country, String organization, String organizationalUnit, String state, String locality, String name, String email, int validity) throws Exception {
        logger.log(Level.FINE, "KeyPairGeneratorHelper - generateCAV3Certificate");
        Security.addProvider((Provider)new BouncyCastleProvider());
        X500NameBuilder builder = KeyPairGeneratorHelper.buildX500Name(country, organization, organizationalUnit, state, locality, name, email);
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(6, validity);
        Date notAfter = cal.getTime();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(builder.build(), serial, notBefore, notAfter, builder.build(), pair.getPublic());
        certGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        certGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(6));
        String dummy = BSIObjectIdentifiers.class.getName();
        dummy = MiscObjectIdentifiers.class.getName();
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(pair.getPrivate());
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certGen.build(sigGen));
        cert.checkValidity(new Date());
        cert.verify(pair.getPublic());
        return cert;
    }

    public static X509Certificate generateServerV3Certificate(KeyPair pair, String country, String organization, String organizationalUnit, String state, String locality, String name, String dnsName, String email, int validity, X509Certificate certCA, KeyPair pairCA) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        X500NameBuilder builder = KeyPairGeneratorHelper.buildX500Name(country, organization, organizationalUnit, state, locality, name, email);
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(6, validity);
        Date notAfter = cal.getTime();
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(certCA, serial, notBefore, notAfter, builder.build(), pair.getPublic());
        certGen.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        certGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(184));
        ArrayList<GeneralName> subjectNames = new ArrayList<GeneralName>();
        subjectNames.add(new GeneralName(2, dnsName));
        certGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(subjectNames.toArray(new GeneralName[0])));
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider((Provider)new BouncyCastleProvider()).build(pairCA.getPrivate());
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certGen.build(sigGen));
        cert.checkValidity(new Date());
        cert.verify(pairCA.getPublic());
        return cert;
    }

    public static KeyPair generateRSAKeyPair(int nSize) throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(nSize, new SecureRandom());
        return kpGen.generateKeyPair();
    }
}

