/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.CheckSyracuseCertManagerDataValidator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class CheckMongoDbCertificateP12Validator
implements DataValidator {
    private static Logger logger = Logger.getLogger(CheckMongoDbCertificateP12Validator.class.getName());
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(InstallData adata) {
        try {
            String serverpassphrase = adata.getVariable("mongodb.ssl.serverpassphrase");
            if (serverpassphrase == null || serverpassphrase.isEmpty()) {
                serverpassphrase = adata.getVariable("mongodb.ssl.pemkeypassword");
            }
            CheckMongoDbCertificateP12Validator.writeP12File(serverpassphrase, adata);
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    static void writeP12File(String passphrase, InstallData adata) throws Exception {
        KeyPair pairServer;
        InputStreamReader keyStreamReader;
        InputStream inCertFile;
        BouncyCastleProvider bcprovider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcprovider);
        String strCertPath = adata.getVariable("mongodb.dir.certs");
        String hostname = adata.getVariable("mongodb.ssl.certificate.hostname");
        String pemKeyFile = strCertPath + File.separator + hostname + ".pem";
        String certFile = strCertPath + File.separator + hostname + ".crt";
        String privKeyFile = strCertPath + File.separator + hostname + ".key";
        String p12File = strCertPath + File.separator + hostname + ".p12";
        String serverpassphrase = passphrase;
        if (!new File(privKeyFile).exists()) {
            byte[] certAndKey = Files.readAllBytes(Paths.get(pemKeyFile, new String[0]));
            String delimiter = "-----END CERTIFICATE-----";
            String[] tokens = new String(certAndKey).split(delimiter);
            byte[] certBytes = tokens[0].concat(delimiter).getBytes();
            byte[] keyBytes = tokens[1].getBytes();
            inCertFile = new ByteArrayInputStream(certBytes);
            keyStreamReader = new InputStreamReader(new ByteArrayInputStream(keyBytes));
        } else {
            FileInputStream inPrivKeyFile = new FileInputStream(privKeyFile);
            keyStreamReader = new InputStreamReader(inPrivKeyFile);
            inCertFile = new FileInputStream(certFile);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate servercert = (X509Certificate)factory.generateCertificate(inCertFile);
        X500Principal x500Principal = servercert.getSubjectX500Principal();
        String name = x500Principal.getName();
        String cname = CheckSyracuseCertManagerDataValidator.extractCommonName(name);
        adata.setVariable("mongodb.ssl.certificate.cname", cname);
        logger.log(Level.FINE, "Set certificate cname " + cname);
        String thumbPrint = CheckMongoDbCertificateP12Validator.getThumbprint(servercert);
        adata.setVariable("mongodb.ssl.certificate.thumbprint", thumbPrint);
        logger.log(Level.FINE, "Set certificate thumbPrint " + thumbPrint);
        PEMParser pemParser = new PEMParser((Reader)keyStreamReader);
        Object object = pemParser.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)bcprovider);
        if (object instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(serverpassphrase.toCharArray());
            pairServer = converter.getKeyPair(ckp.decryptKeyPair(decProv));
        } else {
            PEMKeyPair ukp = (PEMKeyPair)object;
            pairServer = converter.getKeyPair(ukp);
        }
        pemParser.close();
        KeyStore keyStore = KeyStore.getInstance("PKCS12", (Provider)bcprovider);
        keyStore.load(null, null);
        keyStore.setKeyEntry(cname, pairServer.getPrivate(), null, new Certificate[]{servercert});
        FileOutputStream foStream = new FileOutputStream(strCertPath + File.separator + hostname + ".p12");
        keyStore.store(foStream, serverpassphrase.toCharArray());
        foStream.close();
    }

    public static String getThumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CheckMongoDbCertificateP12Validator.bytesToHex(digest);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte element : hash) {
            String hex = Integer.toHexString(0xFF & element);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString().toLowerCase();
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

