/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.helper.SpecHelper;
import com.sage.izpack.CLoggerUtils;
import com.sage.izpack.CReport;
import com.sage.izpack.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CAbstractOsInfosfinder {
    private static Logger logger = Logger.getLogger(CAbstractOsInfosfinder.class.getName());
    private static final String PREREQUISITES_SCRIPT = "PrerequisitesControlScript";
    protected static final String PLATFORM = OsVersion.IS_UNIX ? "unix" : "windows";
    protected final CReport aReport;
    protected InstallData aData;
    protected Resources resources;

    public CAbstractOsInfosfinder(CReport pReport, InstallData pData, Resources resources) {
        this.aReport = pReport;
        this.aData = pData;
        this.resources = resources;
    }

    public String getResourceName() {
        return PREREQUISITES_SCRIPT;
    }

    public String execute() throws Exception {
        CLoggerUtils.logInfo("begin");
        String wShellScriptName = this.getResourceName();
        logger.log(Level.FINE, "execute " + wShellScriptName);
        this.aReport.appendStep("Exec ScriptName=[%s]", wShellScriptName);
        String wOutput = this.loadPredefinedFunctions(this.getResourceName(), this.resources);
        this.aReport.appendOutput(wOutput);
        return wOutput;
    }

    private String loadPredefinedFunctions(String resource, Resources resources) throws Exception {
        String result = "";
        SpecHelper spechelper = new SpecHelper(resources);
        String ext = OsVersion.IS_UNIX ? ".sh" : ".cmd";
        InputStream stream = spechelper.getResource(resource);
        if (stream != null) {
            File tempFile = File.createTempFile(resource, ext);
            FileOutputStream fos = null;
            tempFile.deleteOnExit();
            fos = new FileOutputStream(tempFile);
            VariableSubstitutorImpl substitutor = new VariableSubstitutorImpl(this.aData.getVariables());
            substitutor.substitute(stream, fos, SubstitutionType.TYPE_PLAIN, "UTF-8");
            this.aReport.append("ScriptLocation=[%s]", tempFile.getPath());
            fos.close();
            ProcessBuilder procBuilder = null;
            procBuilder = OsVersion.IS_UNIX ? new ProcessBuilder(System.getenv("SHELL"), tempFile.getAbsolutePath()) : new ProcessBuilder("cmd.exe", "/C", tempFile.getAbsolutePath());
            logger.log(Level.FINE, "Launching " + tempFile.getAbsolutePath());
            Process p = procBuilder.start();
            BufferedInputStream errorOutput = new BufferedInputStream(p.getErrorStream(), 10000);
            BufferedInputStream consoleOutput = new BufferedInputStream(p.getInputStream(), 10000);
            logger.log(Level.FINE, "ErrorOutput:");
            BufferedReader br = new BufferedReader(new InputStreamReader(errorOutput));
            String readErrorOutput = br.readLine();
            while (readErrorOutput != null) {
                logger.log(Level.FINE, readErrorOutput);
                readErrorOutput = br.readLine();
                result = result + readErrorOutput + "\r\n";
            }
            logger.log(Level.FINE, "ConsoleOutput:");
            BufferedReader readerOutput = new BufferedReader(new InputStreamReader(consoleOutput));
            String readOutput = readerOutput.readLine();
            while (readOutput != null) {
                logger.log(Level.FINE, readOutput);
                readOutput = readerOutput.readLine();
                result = result + readOutput + "\r\n";
            }
            int exitCode = p.waitFor();
            logger.log(Level.FINE, "ExitCode: " + exitCode);
            this.aReport.append("exitCode: ", exitCode);
            if (exitCode != 0) {
                logger.log(Level.FINE, "Command failed: " + procBuilder.command());
                if (!StringUtil.isNullOrBlank(result) && result.indexOf("Permission denied") >= 0) {
                    logger.log(Level.WARNING, "Error detected: Be sure you execute the setup with suffisant privileges (sudo or root user).");
                }
                throw new InstallerException(resource + " return code is " + exitCode + " !");
            }
        }
        return result;
    }
}

