/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.file;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.file.AbstractFileField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import com.izforge.izpack.panels.userinput.gui.file.FileInputField;
import java.io.File;
import javax.swing.JComponent;

public abstract class AbstractGUIFileField
extends GUIField {
    private FileInputField fileInput;

    public AbstractGUIFileField(AbstractFileField field) {
        super(field);
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        boolean result = false;
        if (skipValidation) {
            this.getField().setValue(this.fileInput.filetxt.getText());
            result = true;
        } else if (this.fileInput.validateField()) {
            File selectedFile = this.fileInput.getSelectedFile();
            if (selectedFile == null) {
                this.getField().setValue("");
            } else {
                this.getField().setValue(selectedFile.getAbsolutePath());
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean updateView() {
        boolean result = super.updateView();
        Field field = this.getField();
        String value = field.getInitialValue();
        if (value != null) {
            this.fileInput.setFile(value);
            result = true;
        }
        return result;
    }

    protected void init(FileInputField inputField) {
        this.fileInput = inputField;
        if (this.getField().getDescription() != null) {
            this.addDescription();
        }
        if (this.getField().getLabel() != null) {
            this.addLabel();
            this.addComponent(inputField, new TwoColumnConstraints(26));
        } else {
            this.addComponent(inputField, new TwoColumnConstraints(29));
        }
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.fileInput.filetxt;
    }
}

