/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console.search;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.search.SearchField;
import com.izforge.izpack.util.Console;
import java.util.List;
import java.util.logging.Logger;

public class ConsoleSearchField
extends ConsoleField {
    private static final Logger logger = Logger.getLogger(ConsoleSearchField.class.getName());

    public ConsoleSearchField(SearchField field, Console console, Prompt prompt) {
        super(field, console, prompt);
    }

    @Override
    public boolean display() {
        SearchField field = (SearchField)this.getField();
        this.printDescription();
        List<String> choices = field.getChoices();
        int selectedIndex = field.getSelectedIndex();
        this.listChoices(choices, selectedIndex);
        if (this.isReadonly()) {
            field.setValue(choices.get(selectedIndex == -1 ? 0 : selectedIndex));
            return true;
        }
        int selected = this.getConsole().prompt("input selection: ", 0, choices.size() - 1, selectedIndex, -1);
        if (selected == -1) {
            return false;
        }
        field.setValue(field.getResult(choices.get(selected)));
        return true;
    }

    protected void listChoices(List<String> choices, int selected) {
        for (int i = 0; i < choices.size(); ++i) {
            String choice = choices.get(i);
            this.println(i + "  [" + (i == selected ? "x" : " ") + "] " + choice);
        }
    }
}

