export type LogLevel = 'off' | 'error' | 'warn' | 'info' | 'verbose' | 'debug';
export interface ProfilerCallback {
    success: (message?: string) => void;
    fail: (message?: string) => void;
}
export interface LoggerInterface {
    /**
     * Logs a message with the provided log level
     * @param logLevel
     * @param messageProvider
     */
    log(logLevel: LogLevel, messageProvider: () => string): ProfilerCallback;
    /**
     * Logs a message with the 'info' level
     * @param messageOrCallback
     */
    info(messageOrCallback: string | (() => string)): ProfilerCallback;
    /**
     * Logs a message with the 'warn' level
     * @param messageOrCallback
     */
    warn(messageOrCallback: string | (() => string)): ProfilerCallback;
    /**
     * Logs a message with the 'verbose' level
     * @param messageProvider
     */
    verbose(messageProvider: () => string): ProfilerCallback;
    /**
     * Logs a message with the 'debug' level
     * @param messageProvider
     */
    debug(messageProvider: () => string): ProfilerCallback;
    /**
     * Logs a message with the 'error' level
     * @param messageOrCallback
     */
    error(messageOrCallback: string | (() => string)): ProfilerCallback;
    /**
     * result = do(fn, onError);
     *
     * Executes `fn()` silently.
     * But if `fn()` fails, logs the stacktrace and rethrows.
     *
     * `onError(err)` is an optional callback which will be invoked if `fn()` fails.
     * By default, `onError` rethrows the error, but you can rethrow a different error, typically
     * to mask low level details, or add some context to the error.
     * You can also use `onError` to stop the error propagation and return a special value.
     */
    do<T>(fn: () => T): T;
}
