"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetXtremDeploymentConfig = exports.getXtremDeploymentConfig = exports.XtremDeploymentConfig = void 0;
const emptyConfig = {
    dynamoDBTableNames: {
        asyncContext: "",
        activeConnections: "",
        deploymentCore: "",
        intacctCallback: "",
        invalidatedToken: ""
    },
    fileStorageBucket: "",
    fileStorageUseLocal: false,
    fileStorageLocalBasePath: "",
    maxListFiles: 1000,
    clusterId: "",
    app: "",
    xtremEnv: "",
    secretCacheTimeoutInMinutes: 5,
    websocketQueueUrl: "",
    sumoLogicInfrequent: true
};
class XtremDeploymentConfig {
    constructor(overrides) {
        this.config = Object.assign(Object.assign({}, emptyConfig), overrides);
        if (!this.config.maxListFiles) {
            this.config.maxListFiles = 1000;
        }
        if (!this.config.secretCacheTimeoutInMinutes) {
            this.config.secretCacheTimeoutInMinutes = 5;
        }
    }
    get asyncContextTableName() {
        return this.config.dynamoDBTableNames.asyncContext;
    }
    set asyncContextTableName(value) {
        this.config.dynamoDBTableNames.asyncContext = value;
    }
    get activeConnectionsTableName() {
        return this.config.dynamoDBTableNames.activeConnections;
    }
    set activeConnectionsTableName(value) {
        this.config.dynamoDBTableNames.activeConnections = value;
    }
    get deploymentCoreTableName() {
        return this.config.dynamoDBTableNames.deploymentCore;
    }
    set deploymentCoreTableName(value) {
        this.config.dynamoDBTableNames.deploymentCore = value;
    }
    get intacctCallbackTableName() {
        return this.config.dynamoDBTableNames.intacctCallback;
    }
    set intacctCallbackTableName(value) {
        this.config.dynamoDBTableNames.intacctCallback = value;
    }
    get invalidatedTokenTableName() {
        return this.config.dynamoDBTableNames.invalidatedToken;
    }
    set invalidatedTokenTableName(value) {
        this.config.dynamoDBTableNames.invalidatedToken = value;
    }
    get AWSRegion() {
        var _a;
        return (_a = this.config.awsConfigOverride) === null || _a === void 0 ? void 0 : _a.region;
    }
    set AWSRegion(value) {
        this.config.awsConfigOverride = {
            region: value
        };
    }
    get awsConfigOverride() {
        return this.config.awsConfigOverride;
    }
    set awsConfigOverride(value) {
        this.config.awsConfigOverride = value;
    }
    get fileStorageBucket() {
        return this.config.fileStorageBucket;
    }
    set fileStorageBucket(value) {
        this.config.fileStorageBucket = value;
    }
    get maxListFiles() {
        return this.config.maxListFiles;
    }
    set maxListFiles(value) {
        this.config.maxListFiles = value;
    }
    get fileStorageUseLocal() {
        return this.config.fileStorageUseLocal;
    }
    set fileStorageUseLocal(value) {
        this.config.fileStorageUseLocal = value;
    }
    get fileStorageLocalBasePath() {
        return this.config.fileStorageLocalBasePath;
    }
    set fileStorageLocalBasePath(value) {
        this.config.fileStorageLocalBasePath = value;
    }
    get clusterId() {
        return this.config.clusterId;
    }
    set clusterId(value) {
        this.config.clusterId = value;
    }
    get app() {
        return this.config.app;
    }
    set app(value) {
        this.config.app = value;
    }
    get xtremEnv() {
        return this.config.xtremEnv;
    }
    set xtremEnv(value) {
        this.config.xtremEnv = value;
    }
    get secretCacheTimeoutInMinutes() {
        return this.config.secretCacheTimeoutInMinutes;
    }
    set secretCacheTimeoutInMinutes(value) {
        this.config.secretCacheTimeoutInMinutes = value;
    }
    get webSocketQueueUrl() {
        return this.config.websocketQueueUrl;
    }
    set webSocketQueueUrl(value) {
        this.config.websocketQueueUrl = value;
    }
    get webSocketSource() {
        return this.config.websocketSource;
    }
    set webSocketSource(value) {
        this.config.websocketSource = value;
    }
    get invalidatedTokenFrequencyInSec() {
        return this.config.invalidatedTokenFrequencyInSec;
    }
    set invalidatedTokenFrequencyInSec(value) {
        this.config.invalidatedTokenFrequencyInSec = value;
    }
    get invalidatedTokenLogger() {
        return this.config.invalidatedTokenLogger;
    }
    set invalidatedTokenLogger(value) {
        this.config.invalidatedTokenLogger = value;
    }
    get sumoLogicInfrequent() {
        return this.config.sumoLogicInfrequent;
    }
    set sumoLogicInfrequent(value) {
        this.config.sumoLogicInfrequent = value;
    }
    getAsyncContextConfig() {
        return {
            dynamoDBTableName: this.config.dynamoDBTableNames.asyncContext,
            awsConfigOverride: this.config.awsConfigOverride,
            tracer: this.config.tracer,
            AWSOverrideForUnitTesting: this.config.AWSOverrideForUnitTesting
        };
    }
    getFileStorageConfig() {
        return {
            bucket: this.config.fileStorageBucket,
            maxListFiles: this.config.maxListFiles,
            awsConfigOverride: this.config.awsConfigOverride,
            app: this.config.app,
            useLocal: this.config.fileStorageUseLocal,
            localBasePath: this.config.fileStorageLocalBasePath,
            logger: this.config.tracer
        };
    }
    getIntacctControlIdProviderConfig() {
        return {
            clusterId: this.config.clusterId,
            app: this.config.app,
            dynamoDBTableName: this.config.dynamoDBTableNames.intacctCallback,
            awsConfigOverride: this.config.awsConfigOverride,
            tracer: this.config.tracer,
            AWSOverrideForUnitTesting: this.config.AWSOverrideForUnitTesting
        };
    }
    getSecretConfig() {
        return {
            clusterId: this.config.clusterId,
            xtremEnv: this.config.xtremEnv,
            secretCacheTimeoutInMinutes: this.config.secretCacheTimeoutInMinutes
        };
    }
    getWebSocketConfig() {
        // TODO Add source and tracer config
        return {
            clusterId: this.config.clusterId,
            app: this.config.app,
            websocketQueueUrl: this.config.websocketQueueUrl,
            dynamoDBTableName: this.config.dynamoDBTableNames.activeConnections,
            source: this.config.websocketSource,
            awsConfigOverride: this.config.awsConfigOverride,
            tracer: this.config.tracer,
            AWSOverrideForUnitTesting: this.config.AWSOverrideForUnitTesting
        };
    }
    getInvalidatedTokenConfig() {
        return {
            cluster: this.config.clusterId,
            frequencyInSec: this.config.invalidatedTokenFrequencyInSec,
            tableName: this.config.dynamoDBTableNames.invalidatedToken,
            awsConfig: this.config.awsConfigOverride,
            logger: this.config.invalidatedTokenLogger
        };
    }
    getSumoLogicConfig() {
        return {
            envName: this.config.xtremEnv,
            cluster: this.config.clusterId,
            app: this.config.app,
            infrequent: this.config.sumoLogicInfrequent
        };
    }
}
exports.XtremDeploymentConfig = XtremDeploymentConfig;
let config;
const getXtremDeploymentConfig = (defaults) => {
    if (!config) {
        config = new XtremDeploymentConfig(defaults);
    }
    return config;
};
exports.getXtremDeploymentConfig = getXtremDeploymentConfig;
const resetXtremDeploymentConfig = (defaults) => {
    config = new XtremDeploymentConfig(defaults);
    return config;
};
exports.resetXtremDeploymentConfig = resetXtremDeploymentConfig;
