import { LoggerInterface, LogLevel, ProfilerCallback } from "./loggerInterface";
export { LoggerInterface, LogLevel, ProfilerCallback };
export interface DynamoDBTableNames {
    asyncContext: string;
    activeConnections: string;
    deploymentCore: string;
    intacctCallback: string;
    invalidatedToken: string;
}
export interface DeploymentConfig {
    dynamoDBTableNames: {
        asyncContext?: string;
        activeConnections?: string;
        deploymentCore?: string;
        intacctCallback?: string;
        invalidatedToken?: string;
    };
    awsConfigOverride?: {
        region: string;
    };
    clusterId: string;
    app: string;
    xtremEnv: string;
    fileStorageBucket: string;
    maxListFiles: number;
    fileStorageUseLocal: boolean;
    fileStorageLocalBasePath: string;
    secretCacheTimeoutInMinutes: number;
    sumoLogicInfrequent: boolean;
    websocketQueueUrl: string;
    websocketSource?: string;
    invalidatedTokenFrequencyInSec?: number;
    invalidatedTokenLogger?: LoggerInterface;
    tracer?: (msg: string) => void;
    AWSOverrideForUnitTesting?: any;
}
export declare class XtremDeploymentConfig {
    private readonly config;
    constructor(overrides?: Partial<DeploymentConfig>);
    get asyncContextTableName(): string;
    set asyncContextTableName(value: string);
    get activeConnectionsTableName(): string;
    set activeConnectionsTableName(value: string);
    get deploymentCoreTableName(): string;
    set deploymentCoreTableName(value: string);
    get intacctCallbackTableName(): string;
    set intacctCallbackTableName(value: string);
    get invalidatedTokenTableName(): string;
    set invalidatedTokenTableName(value: string);
    get AWSRegion(): string | undefined;
    set AWSRegion(value: string);
    get awsConfigOverride(): any;
    set awsConfigOverride(value: any);
    get fileStorageBucket(): string;
    set fileStorageBucket(value: string);
    get maxListFiles(): number;
    set maxListFiles(value: number);
    get fileStorageUseLocal(): boolean;
    set fileStorageUseLocal(value: boolean);
    get fileStorageLocalBasePath(): string;
    set fileStorageLocalBasePath(value: string);
    get clusterId(): string;
    set clusterId(value: string);
    get app(): string;
    set app(value: string);
    get xtremEnv(): string;
    set xtremEnv(value: string);
    get secretCacheTimeoutInMinutes(): number;
    set secretCacheTimeoutInMinutes(value: number);
    get webSocketQueueUrl(): string;
    set webSocketQueueUrl(value: string);
    get webSocketSource(): string | undefined;
    set webSocketSource(value: string);
    get invalidatedTokenFrequencyInSec(): number | undefined;
    set invalidatedTokenFrequencyInSec(value: number);
    get invalidatedTokenLogger(): LoggerInterface | undefined;
    set invalidatedTokenLogger(value: LoggerInterface);
    get sumoLogicInfrequent(): boolean;
    set sumoLogicInfrequent(value: boolean);
    getAsyncContextConfig(): {
        dynamoDBTableName: string;
        awsConfigOverride: {
            region: string;
        } | undefined;
        tracer: ((msg: string) => void) | undefined;
        AWSOverrideForUnitTesting: any;
    };
    getFileStorageConfig(): {
        bucket: string;
        maxListFiles: number;
        awsConfigOverride: {
            region: string;
        } | undefined;
        app: string;
        useLocal: boolean;
        localBasePath: string;
        logger: ((msg: string) => void) | undefined;
    };
    getIntacctControlIdProviderConfig(): {
        clusterId: string;
        app: string;
        dynamoDBTableName: string;
        awsConfigOverride: {
            region: string;
        } | undefined;
        tracer: ((msg: string) => void) | undefined;
        AWSOverrideForUnitTesting: any;
    };
    getSecretConfig(): {
        clusterId: string;
        xtremEnv: string;
        secretCacheTimeoutInMinutes: number;
    };
    getWebSocketConfig(): {
        clusterId: string;
        app: string;
        websocketQueueUrl: string;
        dynamoDBTableName: string;
        source: string | undefined;
        awsConfigOverride: {
            region: string;
        } | undefined;
        tracer: ((msg: string) => void) | undefined;
        AWSOverrideForUnitTesting: any;
    };
    getInvalidatedTokenConfig(): {
        cluster: string;
        frequencyInSec: number;
        tableName: string;
        awsConfig: {
            region: string;
        } | undefined;
        logger: LoggerInterface | undefined;
    };
    getSumoLogicConfig(): {
        envName: string;
        cluster: string;
        app: string;
        infrequent: boolean;
    };
}
export declare const getXtremDeploymentConfig: (defaults?: Partial<DeploymentConfig>) => XtremDeploymentConfig;
export declare const resetXtremDeploymentConfig: (defaults: Partial<DeploymentConfig>) => XtremDeploymentConfig;
