// From file: @sage/xtrem-i18n/build/index.d.ts
declare module '@sage/xtrem-i18n/index' {
	export * from '@sage/xtrem-i18n/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-i18n/build/lib/utils.d.ts
declare module '@sage/xtrem-i18n/lib/utils' {
	import { LocalizeLocale } from '@sage/xtrem-shared';
	import { IncomingHttpHeaders } from 'http';
	export interface ClientArtifactUsedLiterals {
	    strings: string[];
	    enums: string[];
	}
	/**
	 * Gets the name of the current package
	 * @param dir the starting directory
	 * @returns the name of the package (closest ancestor)
	 */
	export function getPackageNameAndRoot(start: string): {
	    name: string;
	    root: string;
	};
	export const getLocaleFromHeader: (headers?: IncomingHttpHeaders) => LocalizeLocale;
	export const menuItemIdToStringKey: (menuItemId: string) => string;
	export const artifactReferenceToTitleStringKey: (artifactReference: string, artifactType: "stickers" | "pages") => string;
	export const enumNameToStringKey: (enumName: string, memberName: string) => string;
	//# sourceMappingURL=utils.d.ts.map
}
// From file: @sage/xtrem-i18n/build/lib/resolver.d.ts
declare module '@sage/xtrem-i18n/lib/resolver' {
	import { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	export interface LocalizedLiteral {
	    key: string;
	    content: string;
	}
	export function getKey(param: {
	    isExtension?: boolean;
	    packageName: string;
	    nodeName: string;
	    operation?: {
	        kind: string;
	        name: string;
	    };
	}): string;
	export function resetDictionary(): void;
	export function getLocaleFromString(stringLocale?: string): LocalizeLocale;
	/**
	 * Reads all i18n JSON files of the current Etna application and puts them to the memory.
	 * */
	export function initializeLocalizationResolver(loadedPackages: {
	    dir: string;
	    name: string;
	}[], dir: string): void;
	export function addBundleLocalizationKeys(bundleStrings: Dict<Dict<string>>): void;
	/**
	 * Resolves a single key to a string literal
	 *
	 * @param key key to lookup, requires exact match
	 * @param locale optional, if not provided it will use f-stream's context
	 */
	export function getLiteral(key: string, locale: LocalizeLocale): LocalizedLiteral;
	/**
	 * Resolves a set of to a string literals
	 *
	 * @param keyStartsWith used to match
	 * @param locale optional, if not provided it will use f-stream's context
	 */
	export function getLiterals(keyStartsWith: string, locale: LocalizeLocale): LocalizedLiteral[];
	/**
	 * Resolves a set of to a string literals
	 *
	 * @param keyStartsWith used to match
	 * @param locale locale used to collect lirarals
	 * @param literals array to push literals
	 */
	export function appendLiterals(keyStartsWith: string, locale: LocalizeLocale, literals: LocalizedLiteral[]): LocalizedLiteral[];
	//# sourceMappingURL=resolver.d.ts.map
}
// From file: @sage/xtrem-i18n/build/lib/localize.d.ts
declare module '@sage/xtrem-i18n/lib/localize' {
	import { LocalizeFunction, LocalizeLocale } from '@sage/xtrem-shared';
	/**
	 * Localize a message for the user.
	 *
	 * @param key The key which will be extracted to the translation files, must be unique in the package
	 * @param template The template value which will be translated and proof-read
	 * @param data Data to be used to populate the translated messages
	 */
	export const localizedText: LocalizeFunction;
	export function localizeEnumMember(enumName: string, memberName: string, locale?: LocalizeLocale): string;
	export const localize: LocalizeFunction;
	//# sourceMappingURL=localize.d.ts.map
}
// From file: @sage/xtrem-i18n/build/lib/index.d.ts
declare module '@sage/xtrem-i18n/lib/index' {
	export * from '@sage/xtrem-i18n/lib/localize';
	export * from '@sage/xtrem-i18n/lib/resolver';
	export { ClientArtifactUsedLiterals, artifactReferenceToTitleStringKey, enumNameToStringKey, getLocaleFromHeader, getPackageNameAndRoot, menuItemIdToStringKey, } from '@sage/xtrem-i18n/lib/utils';
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/xtrem-i18n' {
	export * from '@sage/xtrem-i18n/index';
}
