"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.localize = exports.localizedText = void 0;
exports.localizeEnumMember = localizeEnumMember;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const resolver_1 = require("./resolver");
const utils_1 = require("./utils");
/**
 * Localize a message for the user.
 *
 * @param key The key which will be extracted to the translation files, must be unique in the package
 * @param template The template value which will be translated and proof-read
 * @param data Data to be used to populate the translated messages
 */
const localizedText = (key, _template, data = {}, locale = 'base') => {
    const literal = (0, resolver_1.getLiteral)(key, locale).content;
    return (0, xtrem_shared_1.format)(literal, locale, data);
};
exports.localizedText = localizedText;
function localizeEnumMember(enumName, memberName, locale = 'base') {
    const key = (0, utils_1.enumNameToStringKey)(enumName, memberName);
    // Hack to prevent visiting this call during localization transpiling
    return (0, exports.localizedText)(key, memberName, {}, locale);
}
exports.localize = exports.localizedText;
//# sourceMappingURL=localize.js.map