// From file: @sage/xtrem-cli-dev/build/index.d.ts
declare module '@sage/xtrem-cli-dev/index' {
	export * from '@sage/xtrem-cli-dev/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/index' {
	import type { Argv } from 'yargs';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export const plugin: (yargs: Argv) => Argv;
	export const builder: {
	    start: (yargs: Argv) => Argv;
	};
	export const handler: {
	    start: (argv: any, commandContext?: any) => Promise<import("@sage/xtrem-cli-lib").PluggableHandlerResult>;
	};
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/extensions/start/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/extensions/start/index' {
	export * from '@sage/xtrem-cli-dev/lib/extensions/start/handler';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/extensions/start/handler.d.ts
declare module '@sage/xtrem-cli-dev/lib/extensions/start/handler' {
	import { PluggableHandlerResult } from '@sage/xtrem-cli-lib';
	import { StartContext, StartOptions } from '@sage/xtrem-cli-main';
	export interface StartDevOptions extends StartOptions {
	    watchAll?: boolean;
	    watchServer?: boolean;
	    watchClient?: boolean;
	    socketKey?: string;
	    prodUi?: boolean;
	}
	export const startHandler: (options: StartDevOptions, startContext: StartContext) => Promise<PluggableHandlerResult>;
	//# sourceMappingURL=handler.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/test.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/test' {
	import type { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Executes tests";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: (argv: object) => Promise<any>;
	//# sourceMappingURL=test.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/lint.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/lint' {
	import type { Argv } from 'yargs';
	import { LintOptions } from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export const command: string[];
	export const desc = "Lints the source-code with ts-lint and prettier";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: (argv: LintOptions) => Promise<void>;
	//# sourceMappingURL=lint.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/init.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/init' {
	import type { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Creates an empty xtrem package. It prompts for installation details";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: () => any;
	//# sourceMappingURL=init.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/compile.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/compile' {
	import type { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Creates a ready-to-use Xtrem package";
	export const builder: (yargs: Argv) => Argv<{
	    "skip-client": unknown;
	} & {
	    "skip-cop": unknown;
	} & {
	    "skip-server": unknown;
	} & {
	    "skip-dts": unknown;
	} & {
	    "skip-api-client": unknown;
	} & {
	    "only-api-client": boolean | undefined;
	} & {
	    "only-changed": boolean | undefined;
	} & {
	    "skip-table-schema": unknown;
	} & {
	    "skip-clean": unknown;
	} & {
	    force: unknown;
	} & {
	    references: boolean | undefined;
	} & {
	    binary: boolean | undefined;
	} & {
	    instrumented: boolean | undefined;
	} & {
	    prod: boolean | undefined;
	} & {
	    fast: unknown;
	}>;
	export const handler: (argv: any) => Promise<void>;
	//# sourceMappingURL=compile.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/compile-plugin.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/compile-plugin' {
	import type { Argv } from 'yargs';
	export const command: string[];
	export const desc = "Compiles an Xtrem UI Plugin";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: () => void;
	//# sourceMappingURL=compile-plugin.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/workflow-tests-entry-point.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/workflow-tests-entry-point' {
	import { Dict, TestOptions, WorkflowMockOptions, WorkflowResult, WorkflowStartEvent } from '@sage/xtrem-core';
	type ExecutionModeType = 'only' | 'skip' | 'normal';
	export interface ScenarioOptions {
	    executionMode?: ExecutionModeType;
	    envConfigs?: TestOptions;
	    mocks?: WorkflowMockOptions[];
	}
	export interface Scenario extends ScenarioOptions {
	    name: string;
	    startEvent: WorkflowStartEvent;
	    expectedResult: WorkflowResult;
	}
	export interface Suite extends ScenarioOptions {
	    scenarios: Dict<Scenario>;
	}
	export function validateScenario(file: string, scenario: Scenario): void;
	/** Runs a test scenario */
	export function runScenario({ file, scenario, scenarioOptions, }: {
	    file: string;
	    scenario: Scenario;
	    scenarioOptions: ScenarioOptions;
	}): Promise<void>;
	export {};
	//# sourceMappingURL=workflow-tests-entry-point.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/unit-tests-entry-point.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/unit-tests-entry-point' {
	export {};
	//# sourceMappingURL=unit-tests-entry-point.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/options.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/options' {
	export interface TestOptions {
	    unit: boolean;
	    integration: boolean;
	    graphql: boolean;
	    workflow: boolean;
	    ci: boolean;
	    browser: boolean;
	    serviceOptions?: string;
	    pattern?: string;
	    skipServerCompile?: boolean;
	    noTimeout?: boolean;
	    timeout?: number;
	}
	export interface LintOptions {
	    fix: boolean;
	    path: string;
	}
	//# sourceMappingURL=options.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/mocha.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/mocha' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import * as Mocha from 'mocha';
	export let mochaErrors: {
	    [key: string]: string[];
	};
	export const setupTestSuite: () => Promise<void>;
	export const createMochaRunner: (executionMode: ExecutionMode, dir: string, isCi: boolean) => any;
	export function runMochaTests(mocha: Mocha, isEsm: boolean): Promise<boolean>;
	//# sourceMappingURL=mocha.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/mocha-reporter.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/mocha-reporter' {
	import * as Mocha from 'mocha';
	/**
	 * Constructs a new `Spec` reporter instance.
	 *
	 * @public
	 * @class
	 * @memberof Mocha.reporters
	 * @extends Mocha.reporters.Base
	 * @param {Runner} runner - Instance triggers reporter actions.
	 * @param {Object} [options] - runner options
	 */
	export function MochaTestReporter(this: any, runner: Mocha.Runner): void;
	//# sourceMappingURL=mocha-reporter.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/index' {
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/application';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/config';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/mocha';
	export * from '@sage/xtrem-cli-dev/lib/commands/utils/options';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/graphql-tests-entry-point.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/graphql-tests-entry-point' {
	import { AnyValue, Dict, TestOptions } from '@sage/xtrem-core';
	import { GraphQLSchema } from 'graphql';
	type ExecutionModeType = 'only' | 'skip' | 'normal';
	interface Parameters {
	    [key: string]: {
	        input?: object;
	        output: object;
	        variables?: Dict<AnyValue>;
	        envConfigs?: TestOptions;
	        layers: string[];
	        mocks?: string[];
	        executionMode?: ExecutionModeType;
	    };
	}
	interface TestScenarioInput {
	    parameters: Parameters;
	    scenario: string;
	    requestHbs: string;
	    schema: GraphQLSchema;
	    responseHbs: string;
	    directory: string;
	}
	/**
	 * Runs a test scenario, i.e. any key defined in 'parameters.json'.
	 *
	 * @export
	 * @param {TestScenarioInput} {
	 *     parameters,
	 *     scenario,
	 *     applicationDir,
	 *     requestHbs,
	 *     schema,
	 *     responseHbs,
	 *     directory,
	 * }
	 */
	export function runScenario({ parameters, scenario, requestHbs, schema, responseHbs, directory, }: TestScenarioInput): Promise<void>;
	export {};
	//# sourceMappingURL=graphql-tests-entry-point.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/file.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/file' {
	export const getResourcesDir: () => string;
	//# sourceMappingURL=file.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/config.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/config' {
	export const targetUrlOrigin: string | undefined;
	export const targetBaseUrl: string | undefined;
	export const isLocalTargetUrl: () => boolean;
	export const isRemoteTargetUrl: () => boolean | "" | undefined;
	//# sourceMappingURL=config.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/utils/application.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/utils/application' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	import { Application } from '@sage/xtrem-core';
	export { activatesContainerHeartbeatMonitor } from '@sage/xtrem-cli-lib';
	export function loadTestDatabase(executionMode: ExecutionMode, application: Application, source: string, options?: {
	    layersAsString?: string;
	    serviceOptionsAsString?: string;
	    /**
	     * Should the schema be reset before loading data ?
	     */
	    noSchemaReset?: boolean;
	}): Promise<void>;
	//# sourceMappingURL=application.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/test/xtrem-interface.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/xtrem-interface' {
	export {};
	//# sourceMappingURL=xtrem-interface.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/test/workflow-tests.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/workflow-tests' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	/**
	 * Execute Workflow unit tests
	 *
	 * @param executionMode STANDALONE or INTEGRATED
	 * @param dir the em-core package directory
	 * @param isCi wether tests are meant to be executed in ci mode or not
	 * @param pattern a string that matches a single folder under <em-core-package>/test/workflow
	 *              and temporary <em-core-package>/test/fixtures/workflow
	 */
	export const executeWorkflowTests: (executionMode: ExecutionMode, dir: string, isCi: boolean, pattern?: string) => Promise<void>;
	//# sourceMappingURL=workflow-tests.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/test/unit-tests.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/unit-tests' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export const resolvePackageBin: (packageName: string) => string;
	/**
	 * Execute Mocha unit tests
	 *
	 * TODO:
	 * - Code instrumentation and coverage collection (Probably with an `after` transformer)
	 *
	 * @param executionMode
	 * @param dir
	 * @param isCi
	 * @param pattern
	 */
	export const executeUnitTest: (executionMode: ExecutionMode, dir: string) => Promise<void>;
	//# sourceMappingURL=unit-tests.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/test/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/index' {
	import { TestOptions } from '@sage/xtrem-cli-dev/lib/commands/utils/index';
	export { executeGraphqlTests } from '@sage/xtrem-cli-dev/lib/commands/handlers/test/graphql-tests';
	export const test: (options: TestOptions) => Promise<void>;
	export const getHelp: () => string;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/test/graphql-tests.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/test/graphql-tests' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	/**
	 * Execute Graphql unit tests
	 *
	 * @param executionMode STANDALONE or INTEGRATED
	 * @param dir the em-core package directory
	 * @param isCi wether tests are meant to be executed in ci mode or not
	 * @param pattern a string that matches a single folder under <em-core-package>/test/graphql
	 *              and temporary <em-core-package>/test/fixtures/graphql
	 */
	export const executeGraphqlTests: (executionMode: ExecutionMode, dir: string, isCi: boolean, pattern?: string) => Promise<void>;
	//# sourceMappingURL=graphql-tests.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/prod-ui/start-prod-ui.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/prod-ui/start-prod-ui' {
	/**
	 * Start the application in prodUi mode.
	 */
	export function startInProdUiMode(): void;
	//# sourceMappingURL=start-prod-ui.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/lint/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/lint/index' {
	export const lint: (fix?: boolean, providedPath?: string) => Promise<void>;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/init/search-packages.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/init/search-packages' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export interface PackageInfo {
	    name: string;
	    description: string;
	    maintainers: string;
	    version: string;
	    date: string;
	}
	export const searchX3Dependencies: (executionMode: ExecutionMode) => Promise<any[]>;
	export const getLatestVersion: (packageName: string) => Promise<string>;
	//# sourceMappingURL=search-packages.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/init/index.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/init/index' {
	import { bootstrapPackage } from '@sage/xtrem-cli-dev/lib/commands/handlers/init/bootstrap-package';
	import { PackageInfo, searchX3Dependencies } from '@sage/xtrem-cli-dev/lib/commands/handlers/init/search-packages';
	export { bootstrapPackage, PackageInfo, searchX3Dependencies };
	export const init: () => void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-dev/build/lib/commands/handlers/init/bootstrap-package.d.ts
declare module '@sage/xtrem-cli-dev/lib/commands/handlers/init/bootstrap-package' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib';
	export interface DependencyWithVersion {
	    name: string;
	    version: string;
	}
	export const bootstrapPackage: (executionMode: ExecutionMode, dir: string, vendorName: string, name: string, dependencies: DependencyWithVersion[]) => Promise<void>;
	//# sourceMappingURL=bootstrap-package.d.ts.map
}
declare module '@sage/xtrem-cli-dev' {
	export * from '@sage/xtrem-cli-dev/index';
}
