/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.validateScenario=validateScenario,exports.runScenario=runScenario;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),chai_1=require("chai"),fs=require("fs"),glob=require("glob"),js_yaml_1=require("js-yaml"),lodash_1=require("lodash"),fsp=require("path"),mocha_1=require("./mocha");if(xtrem_core_1.ConfigManager.load(process.cwd(),"test"),xtrem_core_1.ConfigManager.current?.logs?.disabledForTests)xtrem_core_1.Logger.disable();const logger=xtrem_core_1.Logger.getLogger(__filename,"workflow-tests");before(mocha_1.setupTestSuite);const helpMessage="See https://confluence.sage.com/display/XTREEM/4+Workflow+unit+tests for a detailed documentation.";function fixTestActiveServiceOptions(e){if(e.testActiveServiceOptions)e.testActiveServiceOptions=e.testActiveServiceOptions.map(e=>xtrem_core_1.Test.application.findServiceOption(e))}const parseFile=(e,t)=>{try{return(e.endsWith(".json")?JSON.parse:js_yaml_1.load)(t)}catch(t){return chai_1.assert.fail(`Cannot parse ${e}: ${t.message}.`)}};function validateScenario(e,t){const{startEvent:r,expectedResult:s,name:o}=t;chai_1.assert.exists(r,`${e}: You need to specify 'startEvent' for scenario '${o}'. ${helpMessage}`),chai_1.assert.exists(r.topic,`${e}: You need to specify 'topic' for startEvent of scenario '${o}'. ${helpMessage}`),chai_1.assert.exists(r.payload,`${e}: You need to specify 'payload' for startEvent of scenario '${o}'. ${helpMessage}`),chai_1.assert.exists(s,`${e}: You need to specify 'expectedResult' for scenario '${o}'. ${helpMessage}`),chai_1.assert.exists(s.status,`${e}: You need to specify expected status for 'expectedResult' of scenario '${o}'. ${helpMessage}`)}const omitSystemProperties=e=>(0,lodash_1.mapValues)((0,lodash_1.omit)(e,"_id","_updateTick"),e=>{if(Array.isArray(e))return e.map(omitSystemProperties);if((0,lodash_1.isObject)(e))return omitSystemProperties(e);return e});async function runScenario({file:e,scenario:t,scenarioOptions:r}){validateScenario(e,t);const{startEvent:s,expectedResult:o,mocks:i}=t,a={...r.envConfigs??{}};fixTestActiveServiceOptions(a);const n={tenantId:a.tenantId||xtrem_core_1.Test.defaultTenantId,userEmail:a.user?.email||xtrem_core_1.Test.defaultEmail,loginEmail:a.user?.email||xtrem_core_1.Test.defaultEmail,locale:a.locale},run=async e=>{const t=r.envConfigs;if(t&&(t.today||t.now)){if(t.now&&t.today)throw new xtrem_shared_1.LogicError("specify 'now' or 'today' in envConfigs but not both");if(t.now)xtrem_date_time_1.datetime.overrideNow(t.now);else xtrem_date_time_1.datetime.overrideNow(`${t.today}T12:00:00Z`);try{return await e()}finally{xtrem_date_time_1.datetime.overrideNow(null)}}return e()},c=await run(()=>xtrem_core_1.WorkflowMock.run(i,()=>xtrem_core_1.Test.application.workflowManager.runTest(s,n))),l=omitSystemProperties(c);logger.debug(()=>`Actual workflow result : \n ${JSON.stringify(l,null,4)}`),(0,xtrem_core_1.assertDeepPartialMatch)(l,o)}const getItOverride=e=>{switch(e){case"only":return it.only;case"skip":return it.skip;default:return it}},runWorkflowTest=e=>{const t=parseFile(e,fs.readFileSync(e,"utf8"));Object.entries(t.scenarios).forEach(([r,s])=>{s.name=r;const o={...(0,lodash_1.pick)(t,["executionMode","envConfigs","mocks"]),...(0,lodash_1.pick)(s,["executionMode","envConfigs","mocks"])};getItOverride(o.executionMode)(r,()=>runScenario({file:e,scenario:s,scenarioOptions:o}))})},describeWorkflowTests=(e,t="")=>{const r=fsp.join(e,"test/workflow");if(fs.existsSync(r))before(()=>xtrem_core_1.Test.application.workflowManager.start()),describe("Workflow tests",()=>{glob.sync(`./test/workflow/${t}*.{json,yml}`,{cwd:e,absolute:true,realpath:true}).sort(xtrem_shared_1.defaultStringCompare).forEach(t=>{const r=t.substring(e.length+1).replace(/\.(ts|yml)$/,"");describe(r,()=>runWorkflowTest(t))})});else console.warn(`${r} is missing!`)};describeWorkflowTests(process.env.APPLICATION_DIR??process.cwd(),process.env.WORKFLOW_TEST_PATTERN);
//# sourceMappingURL=workflow-tests-entry-point.js.map