/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.createMochaRunner=exports.setupTestSuite=exports.mochaErrors=void 0,exports.runMochaTests=runMochaTests;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),chaiAsPromised=require("chai-as-promised"),fs=require("fs"),Mocha=require("mocha"),path=require("path"),mocha_reporter_1=require("./mocha-reporter");(0,chai_1.use)(chaiAsPromised);const setupTestSuite=async()=>{if(null!=xtrem_core_1.Test.application)return void(0,xtrem_cli_lib_1.printWarning)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,"Test application already set");const e=process.env.APPLICATION_DIR??process.cwd();xtrem_core_1.ConfigManager.load(e,"test");const t={api:await(0,xtrem_cli_lib_1.withTiming)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,{body:()=>(0,xtrem_core_1.dynamicImport)(path.join(e,"build/index.js")),success:()=>`Required modules from ${e}`}),buildDir:path.join(path.join(e,"build"))};process.env.XTREM_USE_TEST_APPLICATION="1",xtrem_core_1.Test.application=await(0,xtrem_cli_lib_1.withTiming)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,{body:()=>xtrem_core_1.Test.createTestApplication(t),success:()=>"application created"});const r=path.join(e,"build/test/fixtures/before-test.js");if(fs.existsSync(r)){const e=await(0,xtrem_core_1.dynamicImport)(r);if(e.beforeTest)await(0,xtrem_cli_lib_1.withTiming)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,{body:()=>e.beforeTest(),success:()=>`running beforeTest from ${r}`})}const i=process.env.XTREM_TEST_OPTIONS?JSON.parse(process.env.XTREM_TEST_OPTIONS):xtrem_cli_lib_1.cliContext.options;if(i.allServiceOptions)xtrem_core_1.Test.cliActiveServiceOptions=Object.values(xtrem_core_1.Test.application.serviceOptionsByName);else if(i.serviceOptions)xtrem_core_1.Test.cliActiveServiceOptions=i.serviceOptions.split(",").map(e=>xtrem_core_1.Test.application.findServiceOption(e))};exports.setupTestSuite=setupTestSuite;const createMochaRunner=(e,t,r)=>{exports.mochaErrors={};const i=JSON.parse(fs.readFileSync(path.resolve(t,"package.json"),"utf-8"));let o;if(r)o="mocha-junit-reporter";else o="spec";if("custom"===process.env.REPORTER)o=mocha_reporter_1.MochaTestReporter;const s=process.env.XTREM_TEST_OPTIONS?JSON.parse(process.env.XTREM_TEST_OPTIONS):xtrem_cli_lib_1.cliContext.options,getTimeout=()=>{if(s.noTimeout)return(0,xtrem_cli_lib_1.printWarning)(e,"--noTimeout set : timeout is disabled."),false;if(s.timeout)return(0,xtrem_cli_lib_1.printWarning)(e,`timeout forced to ${s.timeout} ms`),s.timeout;return false};return new Mocha({color:true,ui:"",ignoreLeaks:false,timeout:xtrem_cli_lib_1.isDebugging?false:getTimeout(),reporter:o,fullStackTrace:true,reporterOptions:r?{junit_report_name:i.description,junit_report_path:path.resolve(t,`junit-report-${i.name.replace("/","-").replace("@","")}.xml`)}:void 0})};async function runMochaTests(e,t){return!await new Promise(r=>{if(t)e.loadFilesAsync().then(()=>e.run(r)).catch(()=>r(1));else e.run(r)})}exports.createMochaRunner=createMochaRunner;
//# sourceMappingURL=mocha.js.map