/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MochaTestReporter=MochaTestReporter;const Base=require("mocha/lib/reporters/base"),mocha_1=require("./mocha");function MochaTestReporter(e){Base.call(this,e);const o=this;o.indents=0,o.indent=function indent(){return Array(o.indents).join("  ")},e.on("start",()=>{console.log("Runner on start")}),e.on("suite",e=>{o.indents+=1,console.log(Base.color("suite","%s%s"),o.indent(),e.title)}),e.on("suite end",()=>{if(o.indents-=1,1===o.indents)console.log()}),e.on("pending",e=>{const s=o.indent()+Base.color("pending","  - %s");console.log(s,e.title)}),e.on("pass",e=>{let s;if("fast"===e.speed)s=o.indent()+Base.color("checkmark",`  ${Base.symbols.ok}`)+Base.color("pass"," %s"),console.log(s,e.title);else s=o.indent()+Base.color("checkmark",`  ${Base.symbols.ok}`)+Base.color("pass"," %s")+Base.color(e.speed," (%dms)"),console.log(s,e.title,e.duration)}),e.on("fail",(e,o)=>{const s=getErrorKey(e.fullTitle()),n=o.message;if(mocha_1.mochaErrors[s])mocha_1.mochaErrors[s].push(n);else mocha_1.mochaErrors[s]=[n]}),e.once("end",()=>{if(o.stats.failures)o.failures.forEach(e=>{const{title:s,err:{message:n,stack:t}}=e,r=o.indent()+Base.color("fail","  FAILED - %s");console.log(r,`${s}: ${n}\n ${t} \n`)})})}function getErrorKey(e){const o="Graphql test fixtures ";if(!e.startsWith(o))throw new Error(`Invalid error key: prefix not found: ${e}`);const s=e.indexOf(" ",o.length);if(s<0)throw new Error(`Invalid error key: space not found: ${e}`);return e.substring(o.length,s)}
//# sourceMappingURL=mocha-reporter.js.map