/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.executeUnitTest=exports.resolvePackageBin=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),childProcess=require("child_process"),fs=require("fs"),glob_1=require("glob"),path=require("path"),mocha_1=require("../../utils/mocha"),resolvePackageBin=e=>{const t=require.resolve(`${e}/package.json`,{paths:[__dirname]}),r=path.dirname(t),i=require(t),s=i.bin[e]||i.bin;return path.resolve(r,s)};exports.resolvePackageBin=resolvePackageBin;const executeUnitTest=async(e,t)=>{(0,xtrem_cli_lib_1.printInfo)(e,"Running unit tests...");const{ci:r,pattern:i,serviceOptions:s}=xtrem_cli_lib_1.cliContext.options,n=require(path.resolve(t,"package.json")),o=r||!i?"build/test/mocha/**/*":`build/test/mocha/**/${i}*`,l=glob_1.glob.sync(`./test/graphql/${i}*/`,{cwd:t,absolute:true,realpath:true}).sort(xtrem_shared_1.defaultStringCompare),c=glob_1.glob.sync(`${t}/${o}`).filter(e=>e.endsWith(".js")).filter(e=>!e.endsWith("sample-test.js")).filter(e=>fs.readFileSync(e,"utf8").includes("describe")).sort(xtrem_shared_1.defaultStringCompare);if(!(c&&0!==c.length||l&&0!==l.length))return void(0,xtrem_cli_lib_1.printWarning)(e,"No unit test files were found.");if(r){const r=path.join(__dirname,"../../utils/graphql-tests-entry-point");try{if(await new Promise(e=>{let i=[(0,exports.resolvePackageBin)("c8"),"--include","build/lib/**/*.js","--extension",".js","--extension",".ts"];["build/lib/{client-functions,pages,page-extensions,page-fragments,stickers,upgrades,widgets}/**/*.js",...n?.c8?.exclude||[]].forEach(e=>{i.push("--exclude"),i.push(e)}),i=[...i,"--exclude-after-remap","false","--reporter","html","--reporter","text","--reporter","json","--reporter","cobertura",(0,exports.resolvePackageBin)("mocha"),"--max-old-space-size=3000","--exit","--ui",require.resolve("./xtrem-interface"),"--timeout","1200000","--require","source-map-support/register","--reporter","mocha-multi","--reporter-options","spec=-,mocha-junit-reporter=-","--recursive",`${r}.js`,`${o}.js`,""+(s?`--service-options=${s}`:"")];const l={...process.env,MOCHA_FILE:path.resolve(t,`junit-report-${n.name.replace("/","-").replace("@","")}.xml`),XTREM_TEST_OPTIONS:JSON.stringify(xtrem_cli_lib_1.cliContext.options)};if("undefined"===l.NODE_ENV)delete l.NODE_ENV;childProcess.spawn("node",i,{env:l,cwd:t,stdio:"inherit"}).on("close",t=>{e(0===t)})}))(0,xtrem_cli_lib_1.printSuccess)(e,"Unit tests passed.");else(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}catch(t){console.log(t),(0,xtrem_cli_lib_1.printWarning)(e,t),(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}}else{if(xtrem_cli_lib_1.isDebugging)(0,xtrem_cli_lib_1.printWarning)(e,"Running in debug mode, timeout is disabled.");try{const i=(0,mocha_1.createMochaRunner)(e,t,r),s=path.join(__dirname,"../../utils/unit-tests-entry-point");if(i.addFile(s),c.forEach(e=>{i.addFile(e)}),!xtrem_core_1.ConfigManager.current.logs?.disabled){const r=`The following unit test files will be executed:\n${[...l,...c].map(e=>` - ${e.replace(t+path.sep,"")}`).join("\n")}`;(0,xtrem_cli_lib_1.printInfo)(e,r)}if(await(0,mocha_1.runMochaTests)(i,"module"===n.type))(0,xtrem_cli_lib_1.printSuccess)(e,"Unit tests passed.");else(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}catch(t){console.log(t),(0,xtrem_cli_lib_1.printWarning)(e,t),(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}}};exports.executeUnitTest=executeUnitTest;
//# sourceMappingURL=unit-tests.js.map