/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getHelp=exports.test=exports.executeGraphqlTests=void 0;const xtrem_cli_compile_1=require("@sage/xtrem-cli-compile"),xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),chalk=require("chalk"),path=require("path"),utils_1=require("../../utils"),graphql_tests_1=require("./graphql-tests"),unit_tests_1=require("./unit-tests"),workflow_tests_1=require("./workflow-tests");var graphql_tests_2=require("./graphql-tests");Object.defineProperty(exports,"executeGraphqlTests",{enumerable:true,get:function(){return graphql_tests_2.executeGraphqlTests}});const test=async e=>{const{executionMode:t,dir:r}=xtrem_cli_lib_1.cliContext;try{const{unit:i,integration:s,graphql:o,workflow:a,ci:n,pattern:c,skipServerCompile:l}=e;let p;if(p=xtrem_core_1.Test.getDirectory(r,"package.json"),""===p)p=xtrem_core_1.Test.getDirectory(path.join(r,"../"),"package.json");if(""===p)p=xtrem_core_1.Test.getDirectory(path.join(r,"../../"),"package.json");const u=path.resolve(p);if(!(i||s||o||a))(0,xtrem_cli_lib_1.quitWithError)(t,"Please use at least one of the --unit, --integration, --graphql or --workflow test switches.");if(!xtrem_core_1.ConfigManager.current.storage?.managedExternal&&!(0,utils_1.isRemoteTargetUrl)()){const e=xtrem_core_1.Test.getTestSchemaName(u);await xtrem_core_1.Application.dropDbSchema(e),await xtrem_core_1.Application.createDbSchema(e)}if(!e.integration&&!n&&!l)(0,xtrem_cli_compile_1.compileServer)(t,p,{skipQueueFileGeneration:true});if(i)await(0,unit_tests_1.executeUnitTest)(t,p);if(o)await(0,graphql_tests_1.executeGraphqlTests)(t,p,n,c);if(a)await(0,workflow_tests_1.executeWorkflowTests)(t,p,n,c);if(t===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit()}catch(e){(0,xtrem_cli_lib_1.quitWithError)(t,e)}};exports.test=test;const getHelp=()=>`${chalk.bold.blue("test [pattern] [--unit] [--integration] [--ci] [--graphql] [--browser]")}\n    Executes tests.\n        pattern:            Optional. Pattern which is used to filter the test files.\n        --integration:      Executes the BDD Cucumber integration tests of the current package.\n        --unit:             Executes the Mocha unit tests of the package in an f-stream context.\n        --ci:               Provides CI context functionality: JUnit reports and code coverage support\n        --graphql:          Executes the Graphql tests.\n        --workflow:         Executes the Workflow tests.\n        --browser:          Makes the browser visible when running the integration tests (not consider when using --ci flag).\n        --service-options:  service options that should be active for unit and integration tests.\n`;exports.getHelp=getHelp;
//# sourceMappingURL=index.js.map