/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.startInProdUiMode=startInProdUiMode;const child_process_1=require("child_process"),fs=require("fs"),js_yaml_1=require("js-yaml"),os=require("os"),fsp=require("path");let configFullFilename,securityFullFilename;function logSuccess(e){console.log(`✅ ${e}`)}function exitWithFailure(e){console.log(`❌ ${e}`),process.exit(1)}function logWarning(e){console.log(`⚠️ ${e}`)}function startAuthenticationContainer(e){const n="xtrem_auth";if((0,child_process_1.execSync)(`docker ps --filter "name=${n}" --format "{{.Names}}"`).toString().trim()===n)return void logSuccess("Authentication service container is running.");console.log("[0;33m"),console.log("****************************************************************************************"),console.log("***"),console.log("***"),console.log("*** The authentication service container has been started ..."),console.log(`*** Please open a new console and re-run 'pnpm ${process.argv.slice(2).join(" ")}' to start the application.`),console.log("***"),console.log("***"),console.log("****************************************************************************************"),console.log("[0m");try{(0,child_process_1.execSync)(`${getSourceDirname()}/start-authentication-container.sh`,{stdio:"inherit",env:{...process.env,CLIENT_ID:e.authenticationContainer?.clientId,CLIENT_SECRET:e.authenticationContainer?.clientSecret}})}catch(e){if("SIGINT"===e.signal)logSuccess("The authentication service container has been stopped"),console.log(`\n*******************************************************************************************************************************************\n\n\n        If you no longer need to run in prod-Ui mode, simply:\n\n        \t- remove the 'prodUi: true' line from your configuration file (${configFullFilename})\n\n        \t- delete the file ${securityFullFilename}\n\n\n*******************************************************************************************************************************************\n        `),process.exit(0);else throw e}}function loadConfigurationFile(e,n,t=true){const i=fsp.join(n,e);if(!fs.existsSync(i)){if(!t)return;const i=fsp.join(n,"..");if(i===n)return;return loadConfigurationFile(e,i)}return{filename:i,content:fs.readFileSync(i,"utf8")}}function getSourceDirname(){return __dirname.replace("/build/lib/","/lib/")}function createSecurityFile(e){const n=fsp.join(e,"xtrem-security.yml");return fs.copyFileSync(fsp.join(getSourceDirname(),"xtrem-security.yml.template"),n),logWarning(`Security file created at ${n}.`),{filename:n,content:fs.readFileSync(n,"utf8")}}function getLocalIpAddressForWsl(){const e=os.networkInterfaces().eth0;if(null==e)exitWithFailure("No network interface found named 'eth0'");const n=e.find(e=>"IPv4"===e.family&&!e.internal);if(null==n)exitWithFailure("No IPv4 address found for 'eth0'");return n.address}function checkHostFileForWsl(e){const n="/mnt/c/Windows/System32/drivers/etc",t=loadConfigurationFile("hosts",n,false);if(null==t)exitWithFailure(`No hosts file found in ${n}`);const i=getLocalIpAddressForWsl();if(!/^\d{1,3}(\.\d{1,3}){3}$/.test(i))exitWithFailure(`Invalid IP address retrieved: ${i}`);const checkRedirection=e=>{const n=new RegExp(`^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}) ${e}$`,"m"),o=t.content.replace(/\r/g,"").match(n);if(!o)exitWithFailure(`In Windows, edit the file 'C:\\Windows\\System32\\drivers\\etc\\hosts' and add the following line:\n\t${i} ${e}.`);if(o[1]===i)return void logSuccess(`Redirection for ${e} is already set to ${i}.`);exitWithFailure(`In Windows, edit the file 'C:\\Windows\\System32\\drivers\\etc\\hosts' and replace the following line:\n\t${o[1]} ${e}\nwith:\n\t${i} ${e}.`)};checkRedirection("login.localhost.dev-sagextrem.com"),checkRedirection("websocket.localhost.dev-sagextrem.com"),checkRedirection("connect.localhost.dev-sagextrem.com"),checkRedirection(`${e}xtrem.localhost.dev-sagextrem.com`)}function checkConfiguration(){const e=loadConfigurationFile("xtrem-config.yml",process.cwd());if(!e)exitWithFailure(`Configuration file not found (starting from ${process.cwd()}).`);logSuccess(`Configuration file found at ${e.filename}.`),configFullFilename=e.filename;const n=(0,js_yaml_1.load)(e.content);if(!n)exitWithFailure("Configuration file is not valid YAML.");if(true!==n.prodUi)exitWithFailure(`You must add 'prodUi: true' to your configuration file ${e.filename}.`);if(logSuccess("prodUi is enabled in the configuration file"),null==n.authenticationContainer||null==n.authenticationContainer.clientId||null==n.authenticationContainer.clientSecret)exitWithFailure(`Your configuration file ${e.filename} must have a 'authenticationContainer' section with this format:\nauthenticationContainer:\n  clientId: <clientId>\n  clientSecret: <clientSecret>\n\nThe values for <clientId> and <clientSecret> can be found in Keeper (Global XTreem/Authentication service/Authentication service)`);let t=loadConfigurationFile("xtrem-security.yml",process.cwd());if(!t)t=createSecurityFile(fsp.dirname(e.filename));return logSuccess(`Security file found at ${t.filename}.`),securityFullFilename=t.filename,n}function startInProdUiMode(){const e=checkConfiguration(),n=null==e.app?"":`${e.app}-`;startAuthenticationContainer(e),checkHostFileForWsl(n),console.log("[0;33m"),console.log(`\n*******************************************************************************************************************************************\n\n\n        The application will now start in prod-Ui mode, you will be able to navigate to http://${n}xtrem.localhost.dev-sagextrem.com:8240/\n\n\n\n        If you no longer need to run in prod-Ui mode, simply:\n\n        \t- remove the 'prodUi: true' line from your configuration file (${configFullFilename})\n\n        \t- delete the file ${securityFullFilename}\n\n\n*******************************************************************************************************************************************\n        `),console.log("[0m")}
//# sourceMappingURL=start-prod-ui.js.map