/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.lint=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),chalk=require("chalk"),eslint_1=require("eslint"),fs=require("fs"),glob_1=require("glob"),path=require("path"),file_1=require("../../utils/file"),getFiles=(e,t,i,r)=>{const s={cwd:t,absolute:true,realpath:true};if(r){const i=path.isAbsolute(r)?r:path.resolve(t,r);if(fs.statSync(i).isFile()){if(i.endsWith(".ts")){if(fs.existsSync(i))return[i];return void(0,xtrem_cli_lib_1.quitWithError)(e,"File is not found.")}return void(0,xtrem_cli_lib_1.quitWithError)(e,`${i} is not a TypeScript file.`)}}else return glob_1.glob.sync(["./lib/**/*.ts","./test/**/*.ts","./test/graphql/**/parameters.json"],{...s,ignore:i?void 0:["./lib/{pages,page-extensions,page-fragments,stickers,client-functions}/**/*.{c,m,}ts"]});return glob_1.glob.sync(["./lib/**/*.ts","./lib-generated/**/*.ts","./test/**/*.ts","./test/graphql/**/parameters.json"],s)};async function getEslintBaseConfig(e,t){const{executionMode:i}=xtrem_cli_lib_1.cliContext;let r;try{r=await(0,xtrem_core_1.dynamicImport)(`${e}/${t}.mjs`)}catch(s){if((0,xtrem_cli_lib_1.printWarning)(i,`Failed to load ${t}.mjs, falling back to '${t}.js'. Error: ${s.message}`),"ERR_MODULE_NOT_FOUND"!==s.code)throw s;r=await(0,xtrem_core_1.dynamicImport)(`${e}/${t}.js`)}return r.default??r}function getProjectsFromEslintConfig(e){if(!Array.isArray(e))return[];return e.filter(e=>"string"==typeof e.languageOptions?.parserOptions?.project).map(e=>e.languageOptions?.parserOptions?.project)}const lint=async(e=false,t)=>{const{executionMode:i,dir:r}=xtrem_cli_lib_1.cliContext,s=getProjectsFromEslintConfig(await getEslintBaseConfig(r,"eslint.config")).includes("tsconfig-artifacts.json"),l=getFiles(i,r,s,t),n=[];if(!l||0===l.length){if((0,xtrem_cli_lib_1.printSuccess)(i,"Nothing to lint."),i===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit(0);return}const o=new eslint_1.ESLint({fix:e}),a=await o.lintFiles(l);if(e)(0,xtrem_cli_lib_1.printInfo)(i,"Output fixes to disk"),await eslint_1.ESLint.outputFixes(a);const c=new eslint_1.ESLint({overrideConfigFile:path.resolve(r,"eslint-filename.config.mjs"),fix:e}),f=await c.lintFiles(l),_=require("prettier"),u=path.resolve((0,file_1.getResourcesDir)(),".prettierrc"),m=JSON.parse(fs.readFileSync(u,"utf-8"));await Promise.all(l.filter(e=>!/\.json$/.test(e)).map(async t=>{const r=await fs.promises.readFile(t,"utf-8"),s=await _.format(r,{...m,filepath:t}),l=s!==r;if(e&&l)(0,xtrem_cli_lib_1.printInfo)(i,`${t} has been reformatted.`),await fs.promises.writeFile(t,s,"utf-8");else if(l)n.push(t)}));const p=[...a,...f];if(p.some(e=>e.messages.some(e=>2===e.severity))||n.length>0){if(p.forEach(e=>{e.messages.filter(e=>1===e.severity&&e.ruleId).forEach(t=>{(0,xtrem_cli_lib_1.printWarning)(i,`${e.filePath}:${t.line}:${t.column}: ${t.message} (${t.ruleId})`)}),e.messages.filter(e=>2===e.severity).forEach(t=>{(0,xtrem_cli_lib_1.printError)(i,`${e.filePath}:${t.line}:${t.column}: ${t.message} (${t.ruleId})`)})}),n.forEach(e=>{(0,xtrem_cli_lib_1.printError)(i,`prettier (${e})`)}),!e)(0,xtrem_cli_lib_1.printInfo)(i,`Run again with ${chalk.bold("--fix")} to try to fix the issues above.`);(0,xtrem_cli_lib_1.quitWithError)(i,"Some files didn't pass the linter.")}else if(p.forEach(e=>{e.messages.filter(e=>1===e.severity&&e.ruleId).forEach(t=>{(0,xtrem_cli_lib_1.printWarning)(i,`${e.filePath}:${t.line}:${t.column}: ${t.message} (${t.ruleId})`)})}),(0,xtrem_cli_lib_1.printSuccess)(i,"All good!"),i===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit(0)};exports.lint=lint;
//# sourceMappingURL=index.js.map