/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.handler=exports.builder=exports.desc=exports.command=void 0,exports.command=["compile","c","build","prepare"],exports.desc="Creates a ready-to-use Xtrem package";const builder=e=>e.version(false).option("skip-client",{desc:"Skips the compilation of client side artifacts"}).option("skip-cop",{desc:"Skips code verification"}).option("skip-server",{desc:"Skips the compilation of server side artifacts"}).option("skip-dts",{desc:"Skips the creation of a single package TS declaration file"}).option("skip-api-client",{desc:"Skips the generation of a single package API reference TS declaration package"}).option("only-api-client",{desc:"Generations a single package API reference TS declaration package without building the rest",type:"boolean"}).option("only-changed",{desc:"Compiles only changed client artifacts, prevents the build folder from being cleared",type:"boolean"}).option("skip-table-schema",{desc:"Skips the generation of table schema declaration JSON files"}).option("skip-clean",{desc:"Skips removal of existing build output"}).option("force",{desc:"Force a full build"}).option("references",{desc:"Compiles all project's references",type:"boolean"}).option("binary",{desc:"Compiles the server side artifacts into a closed-source binary format",type:"boolean"}).option("instrumented",{desc:"Instruments the compiled codebase",type:"boolean"}).option("prod",{desc:"TBA",type:"boolean"}).option("fast",{desc:"Faster build of client artifacts, it can be useful for large packages"}).middleware(e=>(e.isOnlyApi=e.onlyApiClient,e.isOnlyChanged=e.onlyChanged,e.isUsingReferences=e.references,e.isBinary=e.binary,e.isInstrumented=e.instrumented,e.isProd=e.prod,e)).example("$0 compile","Compile the current package");exports.builder=builder;const handler=e=>require("@sage/xtrem-cli-compile").compile(e);exports.handler=handler;
//# sourceMappingURL=compile.js.map