export type InternalItemPath = string | {
    [K: string]: InternalItemPath[];
};
export interface DependingItem<This = any, ValT = any> {
    name: string;
    fullName?: string;
    dependsOn?: InternalItemPath[];
    /**
     * The **optional** object bound to this item. name should be the name of this object
     */
    object?: any;
    updatedValue?: ValT | ((this: This, cx: any) => ValT);
}
export declare const getDependencyNames: (dependsOn: InternalItemPath[] | undefined) => string[];
export declare function topoSort<T extends DependingItem>(items: T[]): T[];
//# sourceMappingURL=toposort.d.ts.map