// From file: @sage/xtrem-decimal/build/index.d.ts
declare module '@sage/xtrem-decimal/index' {
	export * from '@sage/xtrem-decimal/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-decimal/build/lib/types-lib.d.ts
declare module '@sage/xtrem-decimal/lib/types-lib' {
	/**
	Use http://mikemcl.github.io/decimal.js/
	https://github.com/MikeMcl/decimal.js
	*/
	import { Decimal } from '@sage/xtrem-decimal/lib/decimal-class';
	export type Value = string | number | Decimal;
	export type integer = number;
	/**
	 * Converts a value to a decimal (an instance of Decimal).
	 *
	 * The value may be a string, a number or a Decimal.
	 * Only finite values are allowed. Special values like NaN and Infinity will throw an error.
	 */
	export function toDecimal(value: Value): Decimal;
	/**
	 * Converts a value to a number.
	 *
	 * The value may be a string, a number or a decimal (an instance of Decimal).
	 * Only finite values are allowed. Special values like NaN and Infinity will throw an error.
	 */
	export function toNumber(value: Value): number;
	/**
	 * Converts a value to an integer.
	 *
	 * The value may be a string, a number or a decimal (an instance of Decimal).
	 * Only integer values are allowed. Non-integer values like 1.5, NaN and Infinity will throw an error.
	 */
	export function toInteger(value: Value): integer;
	export function newDecimal(s: string): Decimal;
	export function add(a: any, b: any): any;
	export function sub(a: any, b: any): number | import("decimal.js").Decimal;
	export function mul(a: any, b: any): number | import("decimal.js").Decimal;
	export function div(a: any, b: any): number | import("decimal.js").Decimal;
	export function compare(a: any, b: any): number | undefined;
	export function eq(a: any, b: any): boolean;
	export function strictEq(a: any, b: any): boolean;
	export function ne(a: any, b: any): boolean;
	export function strictNe(a: any, b: any): boolean;
	export function lt(a: any, b: any): boolean;
	export function lte(a: any, b: any): boolean;
	export function gt(a: any, b: any): boolean;
	export function gte(a: any, b: any): boolean;
	export function negated(a: any): number | import("decimal.js").Decimal;
	export function plus(a: any): any;
	export function abs(value: Value): Decimal | number;
	export function ceil(value: Value): number;
	export function floor(value: Value): number;
	export function pow(base: Value, exponent: Value): Decimal | number;
	export function max(...values: Value[]): Decimal | number;
	export function min(...values: Value[]): Decimal | number;
	export function round(value: Value): number;
	export function sum(...values: Value[]): Decimal | number;
	export function uselessFunctionV3(): void;
	//# sourceMappingURL=types-lib.d.ts.map
}
// From file: @sage/xtrem-decimal/build/lib/index.d.ts
declare module '@sage/xtrem-decimal/lib/index' {
	export { Decimal } from '@sage/xtrem-decimal/lib/decimal-class';
	export type { decimal } from '@sage/xtrem-decimal/lib/decimal-class';
	export { abs, add, ceil, compare, div, eq, floor, gt, gte, lt, lte, max, min, mul, ne, negated, newDecimal, plus, pow, round, strictEq, strictNe, sub, sum, toDecimal, toInteger, toNumber, } from '@sage/xtrem-decimal/lib/types-lib';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-decimal/build/lib/decimal-class.d.ts
declare module '@sage/xtrem-decimal/lib/decimal-class' {
	/**
	Use http://mikemcl.github.io/decimal.js/
	https://github.com/MikeMcl/decimal.js
	*/
	import { Decimal as _Decimal } from 'decimal.js';
	export type decimal = number;
	export class Decimal extends _Decimal {
	    static make(v: Decimal | string | number): Decimal;
	    static toNumber(v: Decimal | number): number;
	    static roundAt(v: Decimal | string | number, scale?: number): decimal;
	}
	//# sourceMappingURL=decimal-class.d.ts.map
}
declare module '@sage/xtrem-decimal' {
	export * from '@sage/xtrem-decimal/index';
}
