/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.OraclePool=void 0,exports.create=create;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_x3_sql_1=require("@sage/xtrem-x3-sql"),oracle=require("oracledb"),reader_1=require("./reader"),writableOracle=require("oracledb");function setFetchTypeHandler(e){e.fetchTypeHandler=t=>{if(t.dbType===oracle.DB_TYPE_NUMBER&&e&&e.decimalColumns&&e.decimalColumns.length&&e.decimalColumns.includes(t.name))return{type:oracle.STRING};if(t.dbType===oracle.DB_TYPE_DATE||t.dbType===oracle.DB_TYPE_TIMESTAMP)return{converter:e=>{if(e instanceof Date)return new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()));return e}};return}}writableOracle.fetchAsString=[oracle.NUMBER,oracle.CLOB],writableOracle.fetchAsBuffer=[oracle.BLOB];class OraclePool extends xtrem_x3_sql_1.Pool{constructor(e,t){if(super(e,t),this.dialect="oracle",this.config.connectString=`${e.hostname}${e.port?`:${e.port}`:""}/${e.database}`,"sys"===this.config.user)this.config.privilege=oracle.SYSDBA}param(e){return`:v${e+1}`}checkConnection(e){return e}async createConnection(){this.logger&&this.logger.debug(()=>"connecting ..."),process.env.ORA_SDTZ="UTC";const e=await require("oracledb").getConnection(this.config);return await e.execute("ALTER SESSION SET TIME_ZONE='UTC'"),e}async closeConnection(e){try{await e.close()}catch(e){this.logger?.error(e.stack)}}async execute(e,t,a,r){let s,c,n,E;if("string"==typeof e)s=null,c=e,n=t,E=a;else s=e,c=t,n=a,E=r;if(null==s)return this.withConnection(e=>this.execute(e,c,n,E));const i={outFormat:oracle.OUT_FORMAT_OBJECT};if(E=E||{},E.outputVars&&E.outputVars.length>0)E.outputVars.forEach(e=>{const t=oracle[e.type];if("number"!=typeof t)throw new Error(`invalid type: ${e.type}`);n[e.name]={dir:oracle.BIND_OUT,type:t}});if(E.decimalColumns)i.decimalColumns=E.decimalColumns;setFetchTypeHandler(i);const l=this?.logger.verbose(()=>`[${this.config.user}] Execute ${c}, args=${n?JSON.stringify(n):""}`);let N;try{N=await s.execute(c,this.convertArgs(n||[]),i),l?.success()}catch(e){throw l?.fail(`Failed: ${e.message} on ${c}`),e}if(N.rows)return N.rows;return{updateCount:N.rowsAffected,outputVars:E.outputVars&&E.outputVars.map(e=>N.outBinds[e.name][0])}}convertArgs(e){return e.reduce((e,t,a)=>(e[`v${a+1}`]=t,e),{})}createReader(e,t,a,r){this.logger&&this.logger.verbose(()=>`[${this.config.user}] Reader ${t}, args=${a?a.join(","):""}`);const s=r||{};return setFetchTypeHandler(s),(0,reader_1.oracleReader)(e,t,this.convertArgs(a||[]),s)}reader(e,t=[]){return new xtrem_async_helper_1.AsyncArrayReader(()=>this.withConnection(a=>this.createReader(a,e,t,{}).readAll()))}async tableExists(e,t){let a="SELECT * FROM all_tables WHERE TABLE_NAME= :v1";const r=[e];if(null!=t)a=`${a} AND OWNER= :v2`,r.push(t);return!!(await this.reader(a,r).toArray())[0]}async viewExists(e,t){let a="SELECT * FROM all_views WHERE VIEW_NAME= :v1";const r=[e];if(null!=t)a=`${a} AND OWNER= :v2`,r.push(t);return!!(await this.reader(a,r).toArray())[0]}describeNumberColumn(e,t,a){const r=+a.DATA_PRECISION,s=+a.DATA_SCALE;if(!r&&!s)switch(+a.TYPE_TYPE){case 0:if("UPDTICK_0"!==t.name)this.logger?.warn(`${e}.${t.name}: unknown number type, no info`);t.type="decimal",t.precision=38,t.scale=0;break;case 1:t.type="byte";break;case 2:t.type="short";break;case 3:t.type="integer";break;default:{if(4!==a.TYPE_TYPE)this.logger?.warn(`${e}.${t.name}: unknown number type, TYPTYP=${a.TYPE_TYPE}`);t.type="decimal";let r=+a.ZONE_LENGTH;if(0===r)r=+a.TYPE_LENGTH;t.precision=Math.floor(r),t.scale=Math.round(10*(r-t.precision)),t.precision+=t.scale,t.useFloatingPointFormat=a.ZONE_OPTION&&-1!==a.ZONE_OPTION.indexOf("F")||a.TYPE_OPTION&&-1!==a.TYPE_OPTION.indexOf("F");break}}else if(!s)switch(r){case 3:t.type="byte";break;case 5:t.type="short";break;case 10:t.type="integer";break;default:this.logger?.warn(`${e}.${t.name}: unknown number type, TYPTYP=${a.TYPE_TYPE}, precision=${r}`),t.type="decimal",t.precision=r,t.scale=0}else t.type="decimal",t.precision=r,t.scale=s}async readTableSchema(e,t,a){const r={schemaName:e,tableName:t,isView:await this.viewExists(t,e)};let s="";if(!a.skipColumns)s=`SELECT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_LENGTH, c.CHAR_USED, c.CHAR_LENGTH, c.DATA_PRECISION, c.DATA_SCALE, c.NULLABLE, c.DATA_DEFAULT, t.TYPTYP_0 TYPE_TYPE, t.OPTION_0 TYPE_OPTION, t.LNGTYP_0 TYPE_LENGTH, z.LONG_0 ZONE_LENGTH, z.OPTION_0 ZONE_OPTION FROM all_tables a JOIN all_tab_cols c ON a.TABLE_NAME = c.TABLE_NAME AND a.OWNER = c.OWNER LEFT JOIN ${this.getFullTableName(r.schemaName,"ATABZON")} z ON z.CODFIC_0 = c.TABLE_NAME AND c.COLUMN_NAME LIKE CONCAT(z.CODZONE_0, '\\_%') ESCAPE '\\' LEFT JOIN ${this.getFullTableName(r.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0 WHERE a.table_name = :v1 AND a.OWNER = :v2 UNION ALL  SELECT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_LENGTH, c.CHAR_USED, c.CHAR_LENGTH, c.DATA_PRECISION, c.DATA_SCALE, c.NULLABLE, c.DATA_DEFAULT, t.TYPTYP_0 TYPE_TYPE, t.OPTION_0 TYPE_OPTION, t.LNGTYP_0 TYPE_LENGTH, z.LNG_0 ZONE_LENGTH, z.OPTION_0 ZONE_OPTION FROM all_views a JOIN all_tab_cols c ON a.VIEW_NAME = c.TABLE_NAME AND a.OWNER = c.OWNER LEFT JOIN ${this.getFullTableName(r.schemaName,"AVIEWD")} z ON z.CODVUE_0 = c.TABLE_NAME AND c.COLUMN_NAME LIKE CONCAT(z.FLDVUE_0, '\\_%') ESCAPE '\\' LEFT JOIN ${this.getFullTableName(r.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0 WHERE a.VIEW_NAME = :v1 AND a.OWNER = :v2 ORDER BY COLUMN_NAME`,r.columns=(await this.reader(s,[r.tableName,r.schemaName]).toArray()).filter(e=>!e.COLUMN_NAME.startsWith("SYS_STS")).map(e=>{const t={name:e.COLUMN_NAME,isNullable:"N"!==e.NULLABLE};switch(e.DATA_TYPE){case"DATE":t.type="date";break;case"TIMESTAMP(3)":t.type="datetime";break;case"BINARY_DOUBLE":t.type="double";break;case"BINARY_FLOAT":t.type="float";break;case"NUMBER":this.describeNumberColumn(r.tableName,t,e);break;case"BLOB":t.type="binaryStream";break;case"CLOB":t.type="textStream";break;case"CHAR":case"VARCHAR":t.type="string",t.maxLength=parseInt(e.DATA_LENGTH,10);break;case"VARCHAR2":if(t.type="string","B"===e.CHAR_USED){if(e.DATA_LENGTH%4!=0)this.logger?.error(`${r.tableName}.${e.COLUMN_NAME}: invalid DATA_LENGTH value: ${e.DATA_LENGTH} (expected multiple of 4)`);t.maxLength=parseInt(e.DATA_LENGTH,10)/4}else t.maxLength=parseInt(e.CHAR_LENGTH,10);break;case"RAW":if(16===e.DATA_LENGTH)t.type="uuid";else t.type="binary",t.maxLength=e.DATA_LENGTH;break;default:throw new Error(`${r.tableName}.${r.tableName}: unknown column type ${e.DATA_TYPE}`)}if(e.DATA_DEFAULT)t.default=e.DATA_DEFAULT;else t.default=null;return t});if(!a.skipSecurity){s=`SELECT SECURE_0 FROM ${this.getFullTableName(r.schemaName,"ATABLE")} WHERE CODFIC_0 = ${this.param(0)} AND rownum=1`;const e=(await this.reader(s,[r.tableName]).toArray())[0];r.isOpenAccess=!e||2===e.SECURE_0}if(!a.skipIndexes){let e,t;s="select i.UNIQUENESS index_is_unique, ic.INDEX_NAME index_name, ic.COLUMN_NAME column_name, ic.DESCEND column_descending from ALL_IND_COLUMNS ic left join ALL_INDEXES i on ic.INDEX_NAME = i.INDEX_NAME and ic.TABLE_OWNER = i.TABLE_OWNER where ic.TABLE_NAME = :v1 and ic.TABLE_OWNER = :v2 order by ic.INDEX_NAME, ic.COLUMN_POSITION",r.indexes=[],(await this.reader(s,[r.tableName,r.schemaName]).toArray()).forEach(a=>{if(a.INDEX_NAME!==t)t=a.INDEX_NAME,e={name:a.INDEX_NAME,isPrimaryKey:false,isUnique:"UNIQUE"===a.INDEX_IS_UNIQUE,columns:[]},r.indexes.push(e);const s={name:a.COLUMN_NAME,ascending:"ASC"===a.COLUMN_DESCENDING};e.columns.push(s)})}if(!a.skipSequences)s="select LAST_NUMBER from ALL_SEQUENCES where SEQUENCE_NAME = :v1 and SEQUENCE_OWNER = :v2 and ROWNUM < 2",(await this.reader(s,[`SEQ_${r.tableName}`,r.schemaName]).toArray()).forEach(e=>{r.sequence=parseInt(e.LAST_NUMBER,10)});return r}getFullTableDefName(e){return this.getFullTableName(e.schemaName,e.tableName)}getFullTableName(e,t,a){const r=e?`"${e}"."${t}"`:`"${t}"`;return a?`${r} ${a}`:r}}function create(e,t){return new OraclePool(e,t)}exports.OraclePool=OraclePool;
//# sourceMappingURL=pool.js.map