/** @module @sage/xtrem-x3-oracle */
import { AnyValue, AsyncGenericReader } from '@sage/xtrem-async-helper';
import { LoggerInterface } from '@sage/xtrem-shared';
import { PoolConfig, PoolReaderOptions, SqlExecuteOptions, SqlReadTableSchemaOptions, TableDefinition, Pool as XtremX3Pool } from '@sage/xtrem-x3-sql';
import { Connection } from 'oracledb';
export declare class OraclePool extends XtremX3Pool<Connection> {
    readonly dialect = "oracle";
    constructor(config: PoolConfig, logger?: LoggerInterface);
    param(i: number): string;
    protected checkConnection(cnx: Connection): Connection | undefined;
    protected createConnection(): Promise<Connection>;
    protected closeConnection(cnx: Connection): Promise<void>;
    execute<T extends AnyValue>(sql?: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    execute<T extends AnyValue>(cnx?: Connection, sql?: string, args?: any[], opts?: SqlExecuteOptions): Promise<T>;
    private convertArgs;
    createReader<T extends AnyValue>(cnx: Connection, sql: string, args: any[], opts: PoolReaderOptions): AsyncGenericReader<T>;
    private reader;
    tableExists(tableName: string, schemaName: string): Promise<boolean>;
    viewExists(tableName: string, schemaName: string): Promise<boolean>;
    private describeNumberColumn;
    readTableSchema(schemaName: string, tableName: string, options?: SqlReadTableSchemaOptions): Promise<TableDefinition>;
    getFullTableDefName(tableDef: TableDefinition): string;
    getFullTableName(schemaName: string, tableName: string, alias?: string): string;
}
export declare function create(config: PoolConfig, logger?: LoggerInterface): XtremX3Pool<Connection>;
//# sourceMappingURL=pool.d.ts.map