// From file: @sage/xtrem-cli-transformers/build/index.d.ts
declare module '@sage/xtrem-cli-transformers/index' {
	export * from '@sage/xtrem-cli-transformers/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/utils.d.ts
declare module '@sage/xtrem-cli-transformers/lib/utils' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Gets the directory a file belongs to
	 * @param file Typescript source file
	 * @param relativeToLib Should we get directory relative to the lib folder in the path
	 *                      or do we get that last directory in the path. Default to false
	 * @returns name of th directory the given file belongs to
	 */
	export function getDirName(file: ts.SourceFile, relativeToLib?: boolean): string;
	/**
	 * Gets the base name of a file
	 * @param file Typescript source file
	 * @returns base name of the given file without any extension
	 */
	export function getFileName(file: ts.SourceFile): string;
	export const parseObjectLiteralToObject: (objectLiteral: ts.ObjectLiteralExpression) => Dict<any>;
	export function saveAsJson(filename: string, obj: object): void;
	export function getCrudBulkMutationNames(filename: string, node: ts.Decorator): string[];
	export function getDecoratorArguments(filename: string, node: ts.Decorator): ts.NodeArray<ts.ObjectLiteralElementLike>;
	export function getNodeStorageType(filename: string, node: ts.Decorator): string | undefined;
	export function isSubNodeDecorator(node: ts.Node): node is ts.Decorator;
	export function isNodeExtensionDecorator(node: ts.Node): node is ts.Decorator;
	export function isAbstractNodeDecorator(filename: string, node: ts.Decorator): boolean;
	export function canExportNodeDecorator(filename: string, node: ts.Decorator): boolean;
	export function hashFile(filePath: string): string;
	export function getMetadataFilePathForClientFile(dir: string, filePath: string): string;
	//# sourceMappingURL=utils.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/index.d.ts
declare module '@sage/xtrem-cli-transformers/lib/index' {
	export * from '@sage/xtrem-cli-transformers/lib/transformers/index';
	export * from '@sage/xtrem-cli-transformers/lib/utils';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/transformer-utils.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/transformer-utils' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	export const literalsCache: Record<string, any>;
	/**
	 * Turn nested bind property reference object to dot-notion reference. For example, it converts `{this:{is:{a:{nested:{bind:true}}}}}`
	 * to `this__is__a__nested__bind`.
	 * @param bind string or deep bind object
	 * @returns dot notion deep reference string
	 */
	export const convertDeepBindToPath: (bind?: any) => string | null;
	/**
	 * Creates a dictionary key
	 * @param prefix prefix for the generated key
	 * @param key translation key
	 * @returns dictionary key
	 */
	export const createDictionaryKey: (prefix: string, key: string, decoratorContext?: Dict<any>) => string;
	/**
	 * Determines whether the given file is a page or a sticker
	 * @param file
	 * @returns true if file is a page or a sticker
	 */
	export function isClientArtifactFile(fileName: string): boolean;
	/**
	 * Determines whether the given file is a node or node-extension
	 * @param file
	 * @returns true if file is a node or node-extension
	 */
	export function isNodeLikeArtifactFile(file: ts.SourceFile): boolean;
	export function isNodeArtifactFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is a service option
	 * @param file
	 * @returns true if file is a service option
	 */
	export function isServiceOptionFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is an activity
	 * @param file
	 * @returns true if file is an activity
	 */
	export function isActivityFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is a dataType
	 * @param file
	 * @returns true if file is an dataType
	 */
	export function isDataTypeFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is a test file
	 * @param file
	 * @returns true if file is a test file
	 */
	export function isTestFile(file: ts.SourceFile): boolean;
	/**
	 * Determines whether the given file is an enum file
	 * @param file
	 * @returns true if file is an enum file
	 */
	export function isEnumFile(file: ts.SourceFile): boolean;
	/**
	 * Returns a copy of the target without the properties received as second parameter
	 * @returns a copy of target without the given properties
	 */
	export const excludeProperties: (target: Dict<string>, properties: string[]) => Dict<string>;
	export const sortByKey: <T>(dict: Dict<T>) => Dict<T>;
	export const getLocaleFilePath: (dir: string, locale: string, isBuild?: boolean) => string;
	export function merge(target: Dict<string>, source: Dict<string>): Dict<string>;
	export function writeStringLiteralsToBase(currentLiterals: Dict<string>, dir: string): void;
	/**
	 * Adds dictionary entry
	 * @param key the translation key
	 * @param value the translation value
	 * @returns the newly created key
	 */
	export function addDictionaryEntry(dictionary: Dict<string>, key: string, value: string): string;
	//# sourceMappingURL=transformer-utils.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/service-option-name-extractor.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/service-option-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, filename: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
	 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function serviceOptionNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=service-option-name-extractor.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/queue-extractor.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/queue-extractor' {
	import * as ts from 'typescript';
	import { PackageTransformerContext } from '@sage/xtrem-cli-transformers/lib/transformers/package-transformer-context';
	export function isNodeLikeArtifactFile(file: ts.SourceFile): boolean;
	export function createQueueExtractor(packageContext: PackageTransformerContext): ts.TransformerFactory<ts.SourceFile>;
	//# sourceMappingURL=queue-extractor.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/page-metadata-transformer.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/page-metadata-transformer' {
	import { Maybe } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	interface AccessBinding {
	    node?: string;
	    bind?: string;
	}
	interface ComponentAttributes extends AccessBinding {
	    access?: AccessBinding;
	    extensionAccess?: AccessBinding;
	    isTransient?: boolean;
	    valueField?: string;
	    tunnelPage?: string;
	    fragment?: string;
	    helperTextField?: string;
	}
	type LiteralValueType = string | number | boolean;
	export abstract class PageMetadataBuilder {
	    /**
	     * Determines whether the given file is a source file
	     * @param file the TS file to be checked
	     * @returns true if file is a source file
	     */
	    static isSourceFile(file: ts.SourceFile): boolean;
	    /**
	     * Retrieve a value from an typescript object literal
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getValueFromObjectLiteralByKey: <T extends LiteralValueType>(root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => T | undefined;
	    /**
	     *
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getStringValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<string>;
	    /**
	     *
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getBooleanValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<boolean>;
	    /**
	     *
	     * @param root
	     * @param objectLiteralExp
	     * @param key
	     * @returns
	     */
	    static getNumberValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<number>;
	    /**
	     * Get the text of a source file element
	     * @param root
	     * @param element
	     * @returns
	     */
	    static getTsNodeText: (root: ts.SourceFile, element: ts.Node) => string;
	    static getLineAndCharacterOfTsNode(root: ts.SourceFile, element: ts.Node): ts.LineAndCharacter;
	    static getLocation(root: ts.SourceFile, element: ts.Node): string;
	    /**
	     * get
	     * @param root
	     * @param objectLiteralExp
	     * @param defaultNodeName
	     * @returns
	     */
	    static getAccessBindingFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, defaultNodeName?: string) => Maybe<AccessBinding>;
	    static getComponentAttributes: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, extendedNode?: string) => ComponentAttributes;
	    static resolvedBinding: (component: ComponentAttributes, nodeName?: string, pageNode?: string) => AccessBinding;
	    static getAuthorizationCodeFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getCategoryFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getGroupFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getDescriptionFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getListIconFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getExtendsFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
	    static getPriorityFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => number | undefined;
	    static resolveMenuItemId: (root: ts.SourceFile, packageRoot: string, buildDir: string, importPath: string, importedVariable: string) => string;
	    /**
	     * Typescript visitor
	     * @param ctx the transformation context
	     */
	    static visitor: (root: ts.SourceFile, pageNode: string, pageAttributes: ComponentAttributes, nodeName: string | undefined, plugins: string[], fragments: string[], nodes: string[], ctx: ts.TransformationContext) => ((node: ts.Node) => ts.Node);
	}
	/**
	 * This transformer is meant to be run AFTER the 'decorator-transformer' for pages/stickers &
	 * for every source file of an xtrem package
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function pageMetadataTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	export {};
	//# sourceMappingURL=page-metadata-transformer.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/package-transformer-context.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/package-transformer-context' {
	import * as ts from 'typescript';
	import { MessageQueueBuilder, RoutingBuilder } from '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/index';
	export interface PackageTransformerContextOptions {
	    skipQueueFileGeneration?: boolean;
	}
	export class PackageTransformerContext {
	    readonly rootDir: string;
	    readonly options: PackageTransformerContextOptions;
	    constructor(rootDir: string, options?: PackageTransformerContextOptions);
	    get routingBuilder(): RoutingBuilder;
	    get messageQueueBuilder(): MessageQueueBuilder;
	    createQueueExtractor(): ts.TransformerFactory<ts.SourceFile>;
	    postEmit(): void;
	}
	//# sourceMappingURL=package-transformer-context.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/node-property-name-extractor.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/node-property-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, filename: string, ctx: ts.TransformationContext, nodePrefix?: string) => (node: ts.Node) => ts.Node;
	export function getOperationDecoratorParameters(filename: string, node: ts.Decorator): any[] | undefined;
	/**
	 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
	 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function nodePropertyNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=node-property-name-extractor.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/message-transformer.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/message-transformer' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Typescript visitor
	 * @param ctx the transformation context
	 */
	export const messageTransformVisitor: (dictionary: Dict<string>, pkgName: string, fileName: string, ctx: ts.TransformationContext, skipPackageValidation?: boolean) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run AFTER the 'decorator-transformer' for pages/stickers &
	 * for every source file of an em-core package
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function messageTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	export function tsPatchMessageTransformer(): typeof messageTransformer;
	//# sourceMappingURL=message-transformer.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/merge-translation-files.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/merge-translation-files' {
	export const mergeTranslationFiles: (dir: string) => void;
	//# sourceMappingURL=merge-translation-files.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/merge-translation-files-current-dir.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/merge-translation-files-current-dir' {
	export {};
	//# sourceMappingURL=merge-translation-files-current-dir.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/menu-item-transformer.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/menu-item-transformer' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Typescript visitor
	 * @param ctx the transformation context
	 */
	export const visitor: (dictionary: Dict<string>, pkgName: string, fileName: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer extract menu item labels for translations from `menu-items` artifacts.
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function menuItemTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=menu-item-transformer.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/index.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/index' {
	export { activityNameExtractor } from '@sage/xtrem-cli-transformers/lib/transformers/activity-name-extractor';
	export { clientListTransformer } from '@sage/xtrem-cli-transformers/lib/transformers/client-list-transformer';
	export { dataTypesNameExtractor } from '@sage/xtrem-cli-transformers/lib/transformers/data-type-name-extractor';
	export { decimalTransformer } from '@sage/xtrem-cli-transformers/lib/transformers/decimal-transformer';
	export { decoratorTransformer } from '@sage/xtrem-cli-transformers/lib/transformers/decorator-transformer';
	export { enumTransformer } from '@sage/xtrem-cli-transformers/lib/transformers/enum-transformer';
	export { menuItemTransformer } from '@sage/xtrem-cli-transformers/lib/transformers/menu-item-transformer';
	export { mergeTranslationFiles } from '@sage/xtrem-cli-transformers/lib/transformers/merge-translation-files';
	export { messageTransformer, messageTransformVisitor } from '@sage/xtrem-cli-transformers/lib/transformers/message-transformer';
	export { nodePropertyNameExtractor } from '@sage/xtrem-cli-transformers/lib/transformers/node-property-name-extractor';
	export { PackageTransformerContext } from '@sage/xtrem-cli-transformers/lib/transformers/package-transformer-context';
	export { pageMetadataTransformer } from '@sage/xtrem-cli-transformers/lib/transformers/page-metadata-transformer';
	export { defaultElasticMq, getAllElasticMqConfigs, getElasticMqConfigs, getMessageQueueData, getMessageQueueFilePath, getRoutingData, getRoutingFilePath, mergeRoutings, MessageQueueFlavor, QueueConfig, Routing, updateElasticMqConfigFile, } from '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/index';
	export { createQueueExtractor } from '@sage/xtrem-cli-transformers/lib/transformers/queue-extractor';
	export { serviceOptionNameExtractor } from '@sage/xtrem-cli-transformers/lib/transformers/service-option-name-extractor';
	export { isClientArtifactFile } from '@sage/xtrem-cli-transformers/lib/transformers/transformer-utils';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/enum-transformer.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/enum-transformer' {
	import * as ts from 'typescript';
	/**
	 * This transformer is meant to be run AFTER the 'message-transformer' for pages/stickers &
	 * for every source file of a xtrem-services package
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function enumTransformer(): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=enum-transformer.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/decorator-transformer.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/decorator-transformer' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, prefix: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
	 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function decoratorTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=decorator-transformer.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/decimal-transformer.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/decimal-transformer' {
	import * as ts from 'typescript';
	export function decimalTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	export default decimalTransformer;
	//# sourceMappingURL=decimal-transformer.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/data-type-name-extractor.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/data-type-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, file: ts.SourceFile, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer extract data-types to create literals key/value for them
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function dataTypesNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=data-type-name-extractor.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/client-list-transformer.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/client-list-transformer' {
	import * as ts from 'typescript';
	/**
	 * Typescript visitor
	 * @param ctx the transformation context
	 */
	export const visitor: (usedStrings: string[], usedEnums: string[], file: ts.SourceFile, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer is meant to be run AFTER the 'decorator-transformer' and 'message-transformer' for pages/stickers &
	 * for every source file of an xtrem application package. For all client side artifacts it lists the strings that the
	 * page uses so the server can send the right strings to the client.
	 *
	 * @param ctx the transformation context
	 * @returns the transformed file
	 */
	export function clientListTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=client-list-transformer.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/activity-name-extractor.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/activity-name-extractor' {
	import { Dict } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	/**
	 * Top-level TS visitor
	 * @param prefix prefix for translation keys
	 */
	export const visitor: (dictionary: Dict<string>, packageName: string, dirName: string, filename: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
	/**
	 * This transformer extract activities to create literals key/value for them
	 *
	 * @param ctx transformation context
	 * @returns the transformed file
	 */
	export function activityNameExtractor(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
	//# sourceMappingURL=activity-name-extractor.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/queue-builder/routing.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/routing' {
	import { Dict } from '@sage/xtrem-shared';
	export interface Route {
	    queue: string;
	    topic: string;
	    sourceFileName: string;
	}
	export interface Routing {
	    [packageName: string]: Route[];
	}
	export interface MessageQueueFlavor {
	    type: 'send' | 'receive';
	    devOnly?: boolean;
	}
	export interface MessageQueue {
	    [queueName: string]: MessageQueueFlavor;
	}
	export function mergeRoutings(routing1: Routing, routing2: Routing): Routing;
	export function sortRoutesByTopic(routing: Routing): Routing;
	export function getRoutingData(routingFile: string): any;
	export function getRoutingFilePath(packageDir: string): string;
	export function getMessageQueueFilePath(packageDir: string): string;
	export function getMessageQueueData(messageQueueFile: string): any;
	export interface QueueConfig {
	    deadLetterQueue?: {
	        name: string;
	        maxReceiveCount: number;
	    };
	    defaultVisibilityTimeout: string;
	    delay: string;
	    fifo?: string;
	    receiveMessageWait: string;
	}
	/**
	 * Retrieves all ElasticMQ configurations based on the provided application and routing.
	 * Optionally, a test package name can be specified to generate unit test queues.
	 *
	 * @param application - The application object.
	 * @param routing - The routing object.
	 * @param testPackageName - The name of the optional test package.
	 * @returns A dictionary of queue configurations.
	 */
	export function getAllElasticMqConfigs(dir: string, routing: Routing, testPackageName?: string, additionalQueues?: Dict<QueueConfig>): Dict<QueueConfig>;
	/**
	 * Updates the ElasticMQ configuration with the provided queues.
	 *
	 * @param {string} projectConfigDir - The path to the project root dir where the local ElasticMq configuration file will be saved.
	 * @param {Dict<QueueConfig>} queues - The queues to be added or updated in the configuration.
	 * @returns {void}
	 */
	export function updateElasticMqConfigFile(workspaceId: string, projectConfigDir: string, queues: Dict<QueueConfig>): void;
	export function syncSharedElasticMqConfigFile(workspaceId: string, projectConfigDir: string): void;
	export function getElasticMqConfigs(names: string[]): Dict<QueueConfig>;
	export const defaultElasticMq: {
	    queues: {
	        [key: string]: QueueConfig;
	    };
	};
	//# sourceMappingURL=routing.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/queue-builder/routing-builder.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/routing-builder' {
	import { PackageJsonFile } from '@sage/xtrem-shared';
	import * as ts from 'typescript';
	import { Routing } from '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/routing';
	export interface Listener {
	    fileName: string;
	    packageName: string;
	    queue: string;
	    topic: string;
	}
	export class RoutingBuilder {
	    private readonly rootDir;
	    readonly routingFilename: string;
	    readonly packageJson: PackageJsonFile;
	    private readonly mutationNames;
	    constructor(rootDir: string | undefined);
	    get packageName(): string;
	    get queue(): string;
	    get routing(): Routing;
	    get filename(): string;
	    get filePath(): string;
	    setVisitingFile(filePath: string): void;
	    get nodeQueueName(): string | undefined;
	    set nodeQueueName(queueName: string | undefined);
	    get node(): ts.Decorator | undefined;
	    setVisitingNodeDecorator(node: ts.Decorator | undefined): void;
	    private static readRoutingData;
	    private getPackageQueueName;
	    private getPackageJson;
	    private static getPackageRootDir;
	    createListener(node: ts.CallExpression): Listener;
	    createAsyncMutationListener(node: ts.CallExpression): Listener;
	    createAsyncMutationListenerObject(classDeclaration: ts.ClassDeclaration, name: string, 
	    /**
	     * Override of the default queue name (by default, the queue name is based on the package name)
	     */
	    queueNameOverride?: string): Listener;
	    private static getQueue;
	    private static getTopic;
	    updateRouting(listener: Listener): void;
	    private static isRouteInList;
	    writeRoutingData(): void;
	    private static getAsyncMutationClassName;
	    /**
	     * Retrieve (if defined) the 'queue' parameter set in the decorator of the asyncMutation
	     */
	    private static getAsyncMutationQueueName;
	    createListeners(): void;
	    createStandardBulkMutationListener(name: string): Listener;
	    createAsyncExportMutationListener(): Listener | undefined;
	}
	//# sourceMappingURL=routing-builder.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/queue-builder/message-queue-builder.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/message-queue-builder' {
	import { MessageQueueFlavor } from '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/routing';
	export class MessageQueueBuilder {
	    private readonly dir;
	    constructor(dir: string);
	    getQueueFileDetails(filePath: string): {
	        isQueue: boolean;
	        isDevOnly: boolean;
	    };
	    private static isQueueFile;
	    addQueue(queueName: string, flavor: MessageQueueFlavor): void;
	    writeQueueData(): void;
	}
	//# sourceMappingURL=message-queue-builder.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/queue-builder/logger.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/logger' {
	function printInfoMessage(message: string): void;
	function printErrorMessage(message: string): void;
	export { printInfoMessage as info };
	export { printErrorMessage as error };
	//# sourceMappingURL=logger.d.ts.map
}
// From file: @sage/xtrem-cli-transformers/build/lib/transformers/queue-builder/index.d.ts
declare module '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/index' {
	export * from '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/message-queue-builder';
	export * from '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/routing';
	export * from '@sage/xtrem-cli-transformers/lib/transformers/queue-builder/routing-builder';
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/xtrem-cli-transformers' {
	export * from '@sage/xtrem-cli-transformers/index';
}
