import { Dict } from '@sage/xtrem-shared';
import * as ts from 'typescript';
/**
 * Gets the directory a file belongs to
 * @param file Typescript source file
 * @param relativeToLib Should we get directory relative to the lib folder in the path
 *                      or do we get that last directory in the path. Default to false
 * @returns name of th directory the given file belongs to
 */
export declare function getDirName(file: ts.SourceFile, relativeToLib?: boolean): string;
/**
 * Gets the base name of a file
 * @param file Typescript source file
 * @returns base name of the given file without any extension
 */
export declare function getFileName(file: ts.SourceFile): string;
export declare const parseObjectLiteralToObject: (objectLiteral: ts.ObjectLiteralExpression) => Dict<any>;
export declare function saveAsJson(filename: string, obj: object): void;
export declare function getCrudBulkMutationNames(filename: string, node: ts.Decorator): string[];
export declare function getDecoratorArguments(filename: string, node: ts.Decorator): ts.NodeArray<ts.ObjectLiteralElementLike>;
export declare function getNodeStorageType(filename: string, node: ts.Decorator): string | undefined;
export declare function isSubNodeDecorator(node: ts.Node): node is ts.Decorator;
export declare function isNodeExtensionDecorator(node: ts.Node): node is ts.Decorator;
export declare function isAbstractNodeDecorator(filename: string, node: ts.Decorator): boolean;
export declare function canExportNodeDecorator(filename: string, node: ts.Decorator): boolean;
export declare function hashFile(filePath: string): string;
export declare function getMetadataFilePathForClientFile(dir: string, filePath: string): string;
//# sourceMappingURL=utils.d.ts.map