import { Dict } from '@sage/xtrem-shared';
export interface Route {
    queue: string;
    topic: string;
    sourceFileName: string;
}
export interface Routing {
    [packageName: string]: Route[];
}
export interface MessageQueueFlavor {
    type: 'send' | 'receive';
    devOnly?: boolean;
}
export interface MessageQueue {
    [queueName: string]: MessageQueueFlavor;
}
export declare function mergeRoutings(routing1: Routing, routing2: Routing): Routing;
export declare function sortRoutesByTopic(routing: Routing): Routing;
export declare function getRoutingData(routingFile: string): any;
export declare function getRoutingFilePath(packageDir: string): string;
export declare function getMessageQueueFilePath(packageDir: string): string;
export declare function getMessageQueueData(messageQueueFile: string): any;
export interface QueueConfig {
    deadLetterQueue?: {
        name: string;
        maxReceiveCount: number;
    };
    defaultVisibilityTimeout: string;
    delay: string;
    fifo?: string;
    receiveMessageWait: string;
}
/**
 * Retrieves all ElasticMQ configurations based on the provided application and routing.
 * Optionally, a test package name can be specified to generate unit test queues.
 *
 * @param application - The application object.
 * @param routing - The routing object.
 * @param testPackageName - The name of the optional test package.
 * @returns A dictionary of queue configurations.
 */
export declare function getAllElasticMqConfigs(dir: string, routing: Routing, testPackageName?: string, additionalQueues?: Dict<QueueConfig>): Dict<QueueConfig>;
/**
 * Updates the ElasticMQ configuration with the provided queues.
 *
 * @param {string} projectConfigDir - The path to the project root dir where the local ElasticMq configuration file will be saved.
 * @param {Dict<QueueConfig>} queues - The queues to be added or updated in the configuration.
 * @returns {void}
 */
export declare function updateElasticMqConfigFile(workspaceId: string, projectConfigDir: string, queues: Dict<QueueConfig>): void;
export declare function syncSharedElasticMqConfigFile(workspaceId: string, projectConfigDir: string): void;
export declare function getElasticMqConfigs(names: string[]): Dict<QueueConfig>;
export declare const defaultElasticMq: {
    queues: {
        [key: string]: QueueConfig;
    };
};
//# sourceMappingURL=routing.d.ts.map