"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageQueueBuilder = void 0;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const _ = require("lodash");
const fs = require("node:fs");
const path = require("node:path");
const transformer_utils_1 = require("../transformer-utils");
const routing_1 = require("./routing");
class MessageQueueBuilder {
    #queueFilename;
    #messageQueues = (0, xtrem_shared_1.createDictionary)();
    constructor(dir) {
        this.dir = dir;
        const queueFileDir = this.dir;
        this.#queueFilename = (0, routing_1.getMessageQueueFilePath)(queueFileDir);
    }
    getQueueFileDetails(filePath) {
        const fileName = path.basename(filePath, '.ts');
        const isQueue = MessageQueueBuilder.isQueueFile(fileName);
        return {
            isQueue,
            isDevOnly: isQueue && path.resolve(filePath).startsWith(path.resolve(this.dir, 'test')),
        };
    }
    static isQueueFile(fileName) {
        return /-queue$/.test(fileName);
    }
    addQueue(queueName, flavor) {
        this.#messageQueues[queueName] = _.pick(flavor, ['type', 'devOnly']);
    }
    writeQueueData() {
        const queueFileExists = fs.existsSync(this.#queueFilename);
        const sortedQueueData = (0, transformer_utils_1.sortByKey)(this.#messageQueues);
        const queueCount = Object.keys(sortedQueueData).length;
        if (queueCount > 0) {
            fs.writeFileSync(this.#queueFilename, `${JSON.stringify(sortedQueueData, null, 4)}\n`, 'utf-8');
        }
        else if (queueFileExists) {
            fs.unlinkSync(this.#queueFilename);
        }
    }
}
exports.MessageQueueBuilder = MessageQueueBuilder;
//# sourceMappingURL=message-queue-builder.js.map