import { Maybe } from '@sage/xtrem-shared';
import * as ts from 'typescript';
interface AccessBinding {
    node?: string;
    bind?: string;
}
interface ComponentAttributes extends AccessBinding {
    access?: AccessBinding;
    extensionAccess?: AccessBinding;
    isTransient?: boolean;
    valueField?: string;
    tunnelPage?: string;
    fragment?: string;
    helperTextField?: string;
}
type LiteralValueType = string | number | boolean;
export declare abstract class PageMetadataBuilder {
    /**
     * Determines whether the given file is a source file
     * @param file the TS file to be checked
     * @returns true if file is a source file
     */
    static isSourceFile(file: ts.SourceFile): boolean;
    /**
     * Retrieve a value from an typescript object literal
     * @param root
     * @param objectLiteralExp
     * @param key
     * @returns
     */
    static getValueFromObjectLiteralByKey: <T extends LiteralValueType>(root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => T | undefined;
    /**
     *
     * @param root
     * @param objectLiteralExp
     * @param key
     * @returns
     */
    static getStringValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<string>;
    /**
     *
     * @param root
     * @param objectLiteralExp
     * @param key
     * @returns
     */
    static getBooleanValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<boolean>;
    /**
     *
     * @param root
     * @param objectLiteralExp
     * @param key
     * @returns
     */
    static getNumberValueFromObjectLiteralByKey: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, key: string) => Maybe<number>;
    /**
     * Get the text of a source file element
     * @param root
     * @param element
     * @returns
     */
    static getTsNodeText: (root: ts.SourceFile, element: ts.Node) => string;
    static getLineAndCharacterOfTsNode(root: ts.SourceFile, element: ts.Node): ts.LineAndCharacter;
    static getLocation(root: ts.SourceFile, element: ts.Node): string;
    /**
     * get
     * @param root
     * @param objectLiteralExp
     * @param defaultNodeName
     * @returns
     */
    static getAccessBindingFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, defaultNodeName?: string) => Maybe<AccessBinding>;
    static getComponentAttributes: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression, extendedNode?: string) => ComponentAttributes;
    static resolvedBinding: (component: ComponentAttributes, nodeName?: string, pageNode?: string) => AccessBinding;
    static getAuthorizationCodeFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
    static getCategoryFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
    static getGroupFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
    static getDescriptionFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
    static getListIconFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
    static getExtendsFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => string | undefined;
    static getPriorityFromObjectLiteralExpression: (root: ts.SourceFile, objectLiteralExp: ts.ObjectLiteralExpression) => number | undefined;
    static resolveMenuItemId: (root: ts.SourceFile, packageRoot: string, buildDir: string, importPath: string, importedVariable: string) => string;
    /**
     * Typescript visitor
     * @param ctx the transformation context
     */
    static visitor: (root: ts.SourceFile, pageNode: string, pageAttributes: ComponentAttributes, nodeName: string | undefined, plugins: string[], fragments: string[], nodes: string[], ctx: ts.TransformationContext) => ((node: ts.Node) => ts.Node);
}
/**
 * This transformer is meant to be run AFTER the 'decorator-transformer' for pages/stickers &
 * for every source file of an xtrem package
 * @param ctx the transformation context
 * @returns the transformed file
 */
export declare function pageMetadataTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
export {};
//# sourceMappingURL=page-metadata-transformer.d.ts.map