"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageTransformerContext = void 0;
const queue_builder_1 = require("./queue-builder");
const queue_extractor_1 = require("./queue-extractor");
class PackageTransformerContext {
    #routingBuilder;
    #messageQueueBuilder;
    constructor(rootDir, options = {}) {
        this.rootDir = rootDir;
        this.options = options;
        this.#routingBuilder = new queue_builder_1.RoutingBuilder(rootDir);
        this.#messageQueueBuilder = new queue_builder_1.MessageQueueBuilder(rootDir);
    }
    get routingBuilder() {
        return this.#routingBuilder;
    }
    get messageQueueBuilder() {
        return this.#messageQueueBuilder;
    }
    createQueueExtractor() {
        return (0, queue_extractor_1.createQueueExtractor)(this);
    }
    postEmit() {
        if (!this.options?.skipQueueFileGeneration) {
            this.#routingBuilder.writeRoutingData();
            this.#messageQueueBuilder.writeQueueData();
        }
    }
}
exports.PackageTransformerContext = PackageTransformerContext;
//# sourceMappingURL=package-transformer-context.js.map